/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.collection;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class TrieMap<V>
extends AbstractMap<CharSequence, V>
implements Serializable,
Map<CharSequence, V> {
    private static final long serialVersionUID = 1L;
    private final TrieNode<V> root;
    int size;
    transient int modCount;
    private transient Set<CharSequence> keySet;
    private transient Collection<V> values;
    private transient Set<Map.Entry<CharSequence, V>> entrySet;

    public TrieMap() {
        this(null, true);
    }

    public TrieMap(Map<CharSequence, ? extends V> map) {
        this(map, false);
        this.putAll(map);
    }

    public TrieMap(TrieMap<? extends V> map) {
        this(map, false);
    }

    private TrieMap(Map<CharSequence, ? extends V> map, boolean nullAllowed) {
        this.root = nullAllowed && map == null || !(map instanceof TrieMap) ? new TrieNode(false) : ((TrieMap)map).root.cloneDeep();
        this.size = 0;
        this.modCount = 0;
    }

    TrieNode<V> getRoot() {
        return this.root;
    }

    @Override
    public V put(CharSequence key, V value) {
        Object replacedValue;
        int i;
        CharSequence checkedKey = TrieMap.keyCheck(key);
        int keyLength = checkedKey.length();
        TrieNode currentNode = this.getRoot();
        TrieNode lastNode = null;
        for (i = 0; i < keyLength && currentNode != null; ++i) {
            lastNode = currentNode;
            currentNode = (TrieNode)currentNode.children.get(Character.valueOf(checkedKey.charAt(i)));
        }
        if (currentNode == null) {
            currentNode = lastNode;
            TrieNode newNode = new TrieNode(true);
            this.addNode(currentNode, checkedKey, --i, newNode);
            this.modifyData(newNode, value);
            replacedValue = null;
        } else if (currentNode.inUse) {
            replacedValue = currentNode.value;
            if (!(replacedValue == value || replacedValue != null && replacedValue.equals(value))) {
                currentNode.value = value;
            }
        } else {
            this.modifyData(currentNode, value);
            currentNode.inUse = true;
            replacedValue = null;
        }
        return (V)replacedValue;
    }

    void modifyData(TrieNode<V> node, V value) {
        ((TrieNode)node).value = value;
        ++this.modCount;
        ++this.size;
    }

    private void addNode(TrieNode<V> node, CharSequence key, int beginIndex, TrieNode<V> newNode) {
        int i;
        int lastKeyIndex = key.length() - 1;
        TrieNode<V> currentNode = node;
        for (i = beginIndex; i < lastKeyIndex; ++i) {
            TrieNode nextNode = new TrieNode(false);
            ((TrieNode)currentNode).children.put(Character.valueOf(key.charAt(i)), nextNode);
            currentNode = nextNode;
        }
        ((TrieNode)currentNode).children.put(Character.valueOf(key.charAt(i)), newNode);
    }

    @Override
    public V get(Object key) {
        TrieNode<V> node = this.findNode(TrieMap.keyCheck(key));
        return (V)(node == null ? null : ((TrieNode)node).value);
    }

    private TrieNode<V> findNode(CharSequence key) {
        int strLen = key.length();
        TrieNode currentNode = this.getRoot();
        for (int i = 0; i < strLen && currentNode != null; ++i) {
            currentNode = (TrieNode)currentNode.children.get(Character.valueOf(key.charAt(i)));
        }
        return currentNode;
    }

    public String getBestMatch(CharSequence str) {
        int i;
        int strLen = str.length();
        TrieNode curNode = this.getRoot();
        for (i = 0; i < strLen && curNode != null; ++i) {
            curNode = (TrieNode)curNode.children.get(Character.valueOf(str.charAt(i)));
        }
        return new StringBuilder(i - 1).append(str, 0, i - 1).toString();
    }

    @Override
    public boolean containsKey(Object key) {
        TrieNode<V> node = this.findNode(TrieMap.keyCheck(key));
        return node != null && ((TrieNode)node).inUse;
    }

    public boolean containsKeyPrefix(CharSequence prefix) {
        return this.findNode(TrieMap.keyCheck(prefix)) != null;
    }

    @Override
    public V remove(Object o) {
        CharSequence key = TrieMap.keyCheck(o);
        TrieNode<V> currentNode = this.findPreviousNode(key);
        if (currentNode == null) {
            return null;
        }
        TrieNode node = (TrieNode)((TrieNode)currentNode).children.get(Character.valueOf(key.charAt(key.length() - 1)));
        if (node == null || !node.inUse) {
            return null;
        }
        Object removed = node.value;
        node.unset();
        --this.size;
        ++this.modCount;
        if (node.children.isEmpty()) {
            this.compact(key);
        }
        return (V)removed;
    }

    private TrieNode<V> findPreviousNode(CharSequence key) {
        int lastKeyIndex = key.length() - 1;
        TrieNode currentNode = this.getRoot();
        for (int i = 0; i < lastKeyIndex && currentNode != null; ++i) {
            currentNode = (TrieNode)currentNode.children.get(Character.valueOf(key.charAt(i)));
        }
        return currentNode;
    }

    V removeMapping(Object o) {
        if (!(o instanceof Map.Entry)) {
            throw new IllegalArgumentException();
        }
        Map.Entry e = (Map.Entry)o;
        CharSequence key = TrieMap.keyCheck((CharSequence)e.getKey());
        Object value = e.getValue();
        TrieNode<V> currentNode = this.findPreviousNode(key);
        if (currentNode == null) {
            return null;
        }
        TrieNode node = (TrieNode)((TrieNode)currentNode).children.get(Character.valueOf(key.charAt(key.length() - 1)));
        if (node == null || !node.inUse) {
            return null;
        }
        Object removed = node.value;
        if (!(removed == value || removed != null && removed.equals(value))) {
            return null;
        }
        node.unset();
        --this.size;
        ++this.modCount;
        if (node.children.isEmpty()) {
            this.compact(key);
        }
        return (V)removed;
    }

    @Override
    public void clear() {
        TrieNode<V> rootNode = this.root;
        ((TrieNode)rootNode).children.clear();
        rootNode.unset();
        ++this.modCount;
        this.size = 0;
    }

    private void compact(CharSequence key) {
        int i;
        TrieNode currentNode;
        int keyLength = key.length();
        TrieNode lastInUseNode = currentNode = this.getRoot();
        int lastInUseIndex = 0;
        for (i = 0; i < keyLength && currentNode != null; ++i) {
            if (currentNode.inUse) {
                lastInUseNode = currentNode;
                lastInUseIndex = i;
            }
            currentNode = (TrieNode)currentNode.children.get(Character.valueOf(key.charAt(i)));
        }
        currentNode = lastInUseNode;
        for (i = lastInUseIndex; i < keyLength; ++i) {
            currentNode = ((TrieNode)currentNode.children.remove(Character.valueOf(key.charAt(i)))).unset();
        }
    }

    private static CharSequence keyCheck(Object key) {
        if (key == null) {
            throw new IllegalArgumentException("This map does not support null keys");
        }
        if (!(key instanceof CharSequence)) {
            throw new IllegalArgumentException("Argument must be instance of CharSequence");
        }
        return (CharSequence)key;
    }

    private static CharSequence keyCheck(CharSequence key) {
        if (key == null) {
            throw new IllegalArgumentException("This map does not support null keys");
        }
        return key;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Set<CharSequence> keySet() {
        KeySet ks = this.keySet;
        return ks != null ? ks : (this.keySet = new KeySet());
    }

    @Override
    public Set<Map.Entry<CharSequence, V>> entrySet() {
        EntrySet es = this.entrySet;
        return es != null ? es : (this.entrySet = new EntrySet());
    }

    @Override
    public Collection<V> values() {
        Values v = this.values;
        return v != null ? v : (this.values = new Values());
    }

    public TrieMap<V> subMap(CharSequence prefix) {
        return new SubTrieMap(this, TrieMap.keyCheck(prefix));
    }

    private static class SubTrieMap<V>
    extends TrieMap<V> {
        private static final long serialVersionUID = 1L;
        private TrieNode<V> subRootNode;
        private TrieMap<V> parent;
        private final CharSequence prefix;

        public SubTrieMap(TrieMap<V> parent, CharSequence prefix) {
            this.parent = parent;
            this.prefix = prefix;
            this.modCount = -1;
        }

        private void ensureLatest() {
            int parentModCount = this.parent.modCount;
            if (this.modCount < parentModCount) {
                this.modCount = parentModCount;
                this.subRootNode = ((TrieMap)this.parent).findNode(this.prefix);
                this.size = this.size(this.subRootNode);
            }
        }

        private int size(TrieNode<V> node) {
            if (node == null) {
                return 0;
            }
            int newSize = 0;
            if (((TrieNode)node).inUse) {
                ++newSize;
            }
            for (Map.Entry entry : ((TrieNode)node).children.entrySet()) {
                newSize += this.size((TrieNode)entry.getValue());
            }
            return newSize;
        }

        @Override
        TrieNode<V> getRoot() {
            this.ensureLatest();
            return this.subRootNode;
        }

        @Override
        public V put(CharSequence key, V value) {
            this.ensureLatest();
            if (this.subRootNode == null) {
                CharSequence localPrefix = this.prefix;
                return this.parent.put(new StringBuilder(localPrefix.length() + key.length()).append(localPrefix).append(key).toString(), value);
            }
            return super.put(key, value);
        }

        @Override
        void modifyData(TrieNode<V> curNode, V value) {
            this.parent.modifyData(curNode, value);
            ++this.modCount;
            ++this.size;
        }

        @Override
        public V remove(Object o) {
            this.ensureLatest();
            CharSequence key = TrieMap.keyCheck(o);
            if (key.length() == 0) {
                CharSequence localPrefix = this.prefix;
                return this.parent.remove(new StringBuilder(localPrefix.length() + key.length()).append(localPrefix).append(key).toString());
            }
            int capturedModCount = this.modCount;
            Object removed = super.remove(key);
            if (capturedModCount != this.modCount) {
                TrieMap<V> parentMap = this.parent;
                ++parentMap.modCount;
                --parentMap.size;
            }
            return removed;
        }

        @Override
        V removeMapping(Object o) {
            CharSequence key = TrieMap.keyCheck(o);
            if (key.length() == 0) {
                CharSequence localPrefix = this.prefix;
                return this.parent.removeMapping(new StringBuilder(localPrefix.length() + key.length()).append(localPrefix).append(key).toString());
            }
            int capturedModCount = this.modCount;
            Object removed = super.removeMapping(key);
            if (capturedModCount != this.modCount) {
                TrieMap<V> parentMap = this.parent;
                ++parentMap.modCount;
                --parentMap.size;
            }
            return removed;
        }

        @Override
        public void clear() {
            this.ensureLatest();
            int oldSize = this.size;
            super.clear();
            this.subRootNode.unset();
            TrieMap<V> parentMap = this.parent;
            parentMap.size -= oldSize;
            ++parentMap.modCount;
        }

        @Override
        public int size() {
            this.ensureLatest();
            return super.size();
        }

        @Override
        public TrieMap<V> subMap(CharSequence prefix) {
            this.ensureLatest();
            CharSequence localPrefix = this.prefix;
            return this.parent.subMap(new StringBuilder(localPrefix.length() + prefix.length()).append(localPrefix).append(prefix).toString());
        }
    }

    private final class Values
    extends AbstractCollection<V> {
        private Values() {
        }

        @Override
        public void clear() {
            TrieMap.this.clear();
        }

        @Override
        public boolean contains(Object o) {
            return TrieMap.this.containsValue(o);
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public int size() {
            return TrieMap.this.size();
        }
    }

    private final class EntrySet
    extends AbstractSet<Map.Entry<CharSequence, V>> {
        private EntrySet() {
        }

        @Override
        public void clear() {
            TrieMap.this.clear();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object value = TrieMap.this.get(e.getKey());
            return value != null && value.equals(e.getValue());
        }

        @Override
        public Iterator<Map.Entry<CharSequence, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean remove(Object o) {
            return TrieMap.this.removeMapping(o) != null;
        }

        @Override
        public int size() {
            return TrieMap.this.size();
        }
    }

    private final class KeySet
    extends AbstractSet<CharSequence> {
        private KeySet() {
        }

        @Override
        public Iterator<CharSequence> iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return TrieMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return TrieMap.this.containsKey((CharSequence)o);
        }

        @Override
        public boolean remove(Object o) {
            return TrieMap.this.remove((CharSequence)o) != null;
        }

        @Override
        public void clear() {
            TrieMap.this.clear();
        }
    }

    private final class ValueIterator
    extends TrieIterator<V> {
        private ValueIterator() {
        }

        @Override
        public V next() {
            return this.nextEntry().getValue();
        }
    }

    private final class EntryIterator
    extends TrieIterator<Map.Entry<CharSequence, V>> {
        private EntryIterator() {
        }

        @Override
        public Map.Entry<CharSequence, V> next() {
            return this.nextEntry();
        }
    }

    private final class KeyIterator
    extends TrieIterator<CharSequence> {
        private KeyIterator() {
        }

        @Override
        public CharSequence next() {
            return this.nextEntry().getKey();
        }
    }

    private abstract class TrieIterator<E>
    implements Iterator<E> {
        protected int expectedModCount;
        private final Deque<TrieEntry> deque;
        private Map.Entry<CharSequence, V> next;
        private Map.Entry<CharSequence, V> current;

        public TrieIterator() {
            this(trieMap.getRoot(), "");
        }

        public TrieIterator(TrieNode<V> startNode, CharSequence key) {
            this.expectedModCount = TrieMap.this.modCount;
            this.deque = new ArrayDeque<TrieEntry>();
            this.deque.add(new TrieEntry(key, startNode));
            this.fetchEntry();
        }

        private void fetchEntry() {
            Deque<TrieEntry> localDeque = this.deque;
            TrieEntry localNext = null;
            while (localNext == null && !localDeque.isEmpty()) {
                TrieEntry tempEntry = localDeque.removeFirst();
                CharSequence key = tempEntry.key;
                TrieNode node = tempEntry.node;
                StringBuilder sb = new StringBuilder(key.length() + 1);
                sb.append(key).append(' ');
                if (node.inUse) {
                    localNext = tempEntry;
                }
                for (Map.Entry entry : node.children.entrySet()) {
                    sb.setCharAt(key.length(), ((Character)entry.getKey()).charValue());
                    localDeque.addFirst(new TrieEntry(sb.toString(), (TrieNode)entry.getValue()));
                }
            }
            this.next = localNext;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        public Map.Entry<CharSequence, V> nextEntry() {
            if (TrieMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Map.Entry entry = this.next;
            this.current = entry;
            if (entry == null) {
                throw new NoSuchElementException();
            }
            this.fetchEntry();
            return entry;
        }

        @Override
        public void remove() {
            Map.Entry entry = this.current;
            if (entry == null) {
                throw new IllegalStateException();
            }
            int localModCount = TrieMap.this.modCount;
            if (localModCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            TrieMap.this.remove(entry.getKey());
            this.expectedModCount = localModCount;
        }
    }

    private final class TrieEntry
    implements Map.Entry<CharSequence, V> {
        private final CharSequence key;
        private final TrieNode<V> node;

        public TrieEntry(CharSequence key, TrieNode<V> node) {
            this.key = key;
            this.node = node;
        }

        @Override
        public final CharSequence getKey() {
            return this.key;
        }

        @Override
        public final V getValue() {
            return this.node.value;
        }

        @Override
        public final V setValue(V value) {
            Object oldValue = this.node.value;
            this.node.value = value;
            return oldValue;
        }

        @Override
        public int hashCode() {
            CharSequence k = this.key;
            Object v = this.node.value;
            int hash = 7;
            hash = 37 * hash + (k != null ? k.hashCode() : 0);
            hash = 37 * hash + (v != null ? v.hashCode() : 0);
            return hash;
        }

        @Override
        public boolean equals(Object obj) {
            Object v2;
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Map.Entry)) {
                return false;
            }
            CharSequence k1 = this.key;
            Map.Entry other = (Map.Entry)obj;
            Object k2 = other.getKey();
            if (!(k1 == k2 || k1 != null && k1.equals(k2))) {
                return false;
            }
            Object v1 = this.node.value;
            return v1 == (v2 = other.getValue()) || v1 != null && v1.equals(v2);
        }
    }

    private static final class TrieNode<V>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final Map<Character, TrieNode<V>> children;
        private V value;
        private boolean inUse;

        public TrieNode(V value, boolean inUse) {
            this.children = new HashMap<Character, TrieNode<V>>();
            this.value = value;
            this.inUse = inUse;
        }

        private TrieNode(V value, boolean inUse, int childrenSize) {
            this.children = new HashMap<Character, TrieNode<V>>(childrenSize);
            this.value = value;
            this.inUse = inUse;
        }

        public TrieNode(boolean inUse) {
            this(null, inUse);
        }

        public TrieNode<V> unset() {
            this.inUse = false;
            this.value = null;
            return this;
        }

        public TrieNode<V> cloneDeep() {
            TrieNode<V> node = new TrieNode<V>(this.value, this.inUse, this.children.size());
            Map<Character, TrieNode<TrieNode<V>>> nodeChildren = node.children;
            for (Map.Entry<Character, TrieNode<V>> entry : this.children.entrySet()) {
                nodeChildren.put(entry.getKey(), entry.getValue().cloneDeep());
            }
            return node;
        }
    }
}

