/*
 * Decompiled with CFR 0.152.
 */
package com.blankj.utilcode.util;

import android.content.ContentResolver;
import android.provider.Settings;
import android.view.Window;
import android.view.WindowManager;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import com.blankj.utilcode.util.Utils;

public final class BrightnessUtils {
    private BrightnessUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static boolean isAutoBrightnessEnabled() {
        try {
            int mode = Settings.System.getInt((ContentResolver)Utils.getApp().getContentResolver(), (String)"screen_brightness_mode");
            return mode == 1;
        }
        catch (Settings.SettingNotFoundException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean setAutoBrightnessEnabled(boolean enabled) {
        return Settings.System.putInt((ContentResolver)Utils.getApp().getContentResolver(), (String)"screen_brightness_mode", (int)(enabled ? 1 : 0));
    }

    public static int getBrightness() {
        try {
            return Settings.System.getInt((ContentResolver)Utils.getApp().getContentResolver(), (String)"screen_brightness");
        }
        catch (Settings.SettingNotFoundException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static boolean setBrightness(@IntRange(from=0L, to=255L) int brightness) {
        ContentResolver resolver = Utils.getApp().getContentResolver();
        boolean b = Settings.System.putInt((ContentResolver)resolver, (String)"screen_brightness", (int)brightness);
        resolver.notifyChange(Settings.System.getUriFor((String)"screen_brightness"), null);
        return b;
    }

    public static void setWindowBrightness(@NonNull Window window, @IntRange(from=0L, to=255L) int brightness) {
        if (window == null) {
            throw new NullPointerException("Argument 'window' of type Window (#0 out of 2, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        WindowManager.LayoutParams lp = window.getAttributes();
        lp.screenBrightness = (float)brightness / 255.0f;
        window.setAttributes(lp);
    }

    public static int getWindowBrightness(@NonNull Window window) {
        if (window == null) {
            throw new NullPointerException("Argument 'window' of type Window (#0 out of 1, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        WindowManager.LayoutParams lp = window.getAttributes();
        float brightness = lp.screenBrightness;
        if (brightness < 0.0f) {
            return BrightnessUtils.getBrightness();
        }
        return (int)(brightness * 255.0f);
    }
}

