/*
 * Decompiled with CFR 0.152.
 */
package com.blankj.utilcode.util;

import android.content.res.Resources;
import android.util.DisplayMetrics;
import androidx.annotation.NonNull;
import com.blankj.utilcode.util.Utils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

public final class AdaptScreenUtils {
    private static List<Field> sMetricsFields;

    private AdaptScreenUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    @NonNull
    public static Resources adaptWidth(@NonNull Resources resources, int designWidth) {
        if (resources == null) {
            throw new NullPointerException("Argument 'resources' of type Resources (#0 out of 2, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        float newXdpi = (float)resources.getDisplayMetrics().widthPixels * 72.0f / (float)designWidth;
        AdaptScreenUtils.applyDisplayMetrics(resources, newXdpi);
        Resources tmpTrauteVar2 = resources;
        if (tmpTrauteVar2 == null) {
            throw new NullPointerException("Detected an attempt to return null from a method com.blankj.utilcode.util.AdaptScreenUtils.adaptWidth() marked by @androidx.annotation.NonNull");
        }
        return tmpTrauteVar2;
    }

    @NonNull
    public static Resources adaptHeight(@NonNull Resources resources, int designHeight) {
        if (resources == null) {
            throw new NullPointerException("Argument 'resources' of type Resources (#0 out of 2, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        Resources tmpTrauteVar2 = AdaptScreenUtils.adaptHeight(resources, designHeight, false);
        if (tmpTrauteVar2 == null) {
            throw new NullPointerException("Detected an attempt to return null from a method com.blankj.utilcode.util.AdaptScreenUtils.adaptHeight() marked by @androidx.annotation.NonNull");
        }
        return tmpTrauteVar2;
    }

    @NonNull
    public static Resources adaptHeight(@NonNull Resources resources, int designHeight, boolean includeNavBar) {
        if (resources == null) {
            throw new NullPointerException("Argument 'resources' of type Resources (#0 out of 3, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        float screenHeight = (float)(resources.getDisplayMetrics().heightPixels + (includeNavBar ? AdaptScreenUtils.getNavBarHeight(resources) : 0)) * 72.0f;
        float newXdpi = screenHeight / (float)designHeight;
        AdaptScreenUtils.applyDisplayMetrics(resources, newXdpi);
        Resources tmpTrauteVar2 = resources;
        if (tmpTrauteVar2 == null) {
            throw new NullPointerException("Detected an attempt to return null from a method com.blankj.utilcode.util.AdaptScreenUtils.adaptHeight() marked by @androidx.annotation.NonNull");
        }
        return tmpTrauteVar2;
    }

    private static int getNavBarHeight(@NonNull Resources resources) {
        if (resources == null) {
            throw new NullPointerException("Argument 'resources' of type Resources (#0 out of 1, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        int resourceId = resources.getIdentifier("navigation_bar_height", "dimen", "android");
        if (resourceId != 0) {
            return resources.getDimensionPixelSize(resourceId);
        }
        return 0;
    }

    @NonNull
    public static Resources closeAdapt(@NonNull Resources resources) {
        if (resources == null) {
            throw new NullPointerException("Argument 'resources' of type Resources (#0 out of 1, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        float newXdpi = Resources.getSystem().getDisplayMetrics().density * 72.0f;
        AdaptScreenUtils.applyDisplayMetrics(resources, newXdpi);
        Resources tmpTrauteVar2 = resources;
        if (tmpTrauteVar2 == null) {
            throw new NullPointerException("Detected an attempt to return null from a method com.blankj.utilcode.util.AdaptScreenUtils.closeAdapt() marked by @androidx.annotation.NonNull");
        }
        return tmpTrauteVar2;
    }

    public static int pt2Px(float ptValue) {
        DisplayMetrics metrics = Utils.getApp().getResources().getDisplayMetrics();
        return (int)((double)(ptValue * metrics.xdpi / 72.0f) + 0.5);
    }

    public static int px2Pt(float pxValue) {
        DisplayMetrics metrics = Utils.getApp().getResources().getDisplayMetrics();
        return (int)((double)(pxValue * 72.0f / metrics.xdpi) + 0.5);
    }

    private static void applyDisplayMetrics(@NonNull Resources resources, float newXdpi) {
        if (resources == null) {
            throw new NullPointerException("Argument 'resources' of type Resources (#0 out of 2, zero-based) is marked by @androidx.annotation.NonNull but got null for it");
        }
        resources.getDisplayMetrics().xdpi = newXdpi;
        Utils.getApp().getResources().getDisplayMetrics().xdpi = newXdpi;
        AdaptScreenUtils.applyOtherDisplayMetrics(resources, newXdpi);
    }

    static Runnable getPreLoadRunnable() {
        return new Runnable(){

            @Override
            public void run() {
                AdaptScreenUtils.preLoad();
            }
        };
    }

    private static void preLoad() {
        AdaptScreenUtils.applyDisplayMetrics(Resources.getSystem(), Resources.getSystem().getDisplayMetrics().xdpi);
    }

    private static void applyOtherDisplayMetrics(Resources resources, float newXdpi) {
        if (sMetricsFields == null) {
            sMetricsFields = new ArrayList<Field>();
            Class<?> resCls = resources.getClass();
            Field[] declaredFields = resCls.getDeclaredFields();
            while (declaredFields != null && declaredFields.length > 0) {
                for (Field field : declaredFields) {
                    if (!field.getType().isAssignableFrom(DisplayMetrics.class)) continue;
                    field.setAccessible(true);
                    DisplayMetrics tmpDm = AdaptScreenUtils.getMetricsFromField(resources, field);
                    if (tmpDm == null) continue;
                    sMetricsFields.add(field);
                    tmpDm.xdpi = newXdpi;
                }
                if ((resCls = resCls.getSuperclass()) != null) {
                    declaredFields = resCls.getDeclaredFields();
                    continue;
                }
                break;
            }
        } else {
            AdaptScreenUtils.applyMetricsFields(resources, newXdpi);
        }
    }

    private static void applyMetricsFields(Resources resources, float newXdpi) {
        for (Field metricsField : sMetricsFields) {
            try {
                DisplayMetrics dm = (DisplayMetrics)metricsField.get(resources);
                if (dm == null) continue;
                dm.xdpi = newXdpi;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static DisplayMetrics getMetricsFromField(Resources resources, Field field) {
        try {
            return (DisplayMetrics)field.get(resources);
        }
        catch (Exception ignore) {
            return null;
        }
    }
}

