/*
 * Decompiled with CFR 0.152.
 */
package com.blade.server.netty;

import com.blade.Blade;
import com.blade.mvc.handler.WebSocketHandlerWrapper;
import com.blade.mvc.websocket.WebSocketContext;
import com.blade.mvc.websocket.WebSocketSession;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import io.netty.util.ReferenceCountUtil;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketHandler
extends SimpleChannelInboundHandler<Object> {
    private static final Logger log = LoggerFactory.getLogger(WebSocketHandler.class);
    private WebSocketServerHandshaker handshaker;
    private WebSocketSession session;
    private com.blade.mvc.handler.WebSocketHandler handler;
    private String uri;
    private Blade blade;

    public WebSocketHandler(Blade blade) {
        this.blade = blade;
    }

    protected void channelRead0(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof HttpRequest) {
            this.handleHttpRequest(ctx, (HttpRequest)msg);
        } else if (msg instanceof WebSocketFrame) {
            this.initHandlerWrapper();
            this.handleWebSocketFrame(ctx, (WebSocketFrame)msg);
        } else {
            ReferenceCountUtil.retain((Object)msg);
            ctx.fireChannelRead(msg);
        }
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
    }

    private void handleHttpRequest(ChannelHandlerContext ctx, HttpRequest req) {
        if (this.isWebSocketRequest(req)) {
            WebSocketServerHandshakerFactory wsFactory = new WebSocketServerHandshakerFactory(req.uri(), null, true);
            this.handshaker = wsFactory.newHandshaker(req);
            if (this.handshaker == null) {
                WebSocketServerHandshakerFactory.sendUnsupportedVersionResponse((Channel)ctx.channel());
            } else {
                this.handshaker.handshake(ctx.channel(), req);
                this.session = new WebSocketSession(ctx);
                this.uri = req.uri();
                this.initHandlerWrapper();
                CompletableFuture.completedFuture(new WebSocketContext(this.session, this.handler)).thenAcceptAsync(this.handler::onConnect, (Executor)ctx.executor());
            }
        } else {
            ReferenceCountUtil.retain((Object)req);
            ctx.fireChannelRead((Object)req);
        }
    }

    private void handleWebSocketFrame(ChannelHandlerContext ctx, WebSocketFrame frame) {
        if (frame instanceof CloseWebSocketFrame) {
            this.handshaker.close(ctx.channel(), (CloseWebSocketFrame)frame.retain());
            CompletableFuture.completedFuture(new WebSocketContext(this.session, this.handler)).thenAcceptAsync(this.handler::onDisConnect);
            return;
        }
        if (frame instanceof PingWebSocketFrame) {
            ctx.channel().write((Object)new PongWebSocketFrame(frame.content().retain()));
            return;
        }
        if (!(frame instanceof TextWebSocketFrame)) {
            throw new UnsupportedOperationException("unsupported frame type: " + frame.getClass().getName());
        }
        CompletableFuture.completedFuture(new WebSocketContext(this.session, this.handler, ((TextWebSocketFrame)frame).text())).thenAcceptAsync(this.handler::onText, (Executor)ctx.executor());
    }

    private boolean isWebSocketRequest(HttpRequest req) {
        return req != null && (this.handler = this.blade.routeMatcher().getWebSocket(req.uri())) != null && req.decoderResult().isSuccess() && "websocket".equals(req.headers().get("Upgrade"));
    }

    private void initHandlerWrapper() {
        if (this.handler != null && this.handler instanceof WebSocketHandlerWrapper) {
            ((WebSocketHandlerWrapper)this.handler).setPath(this.uri);
        }
    }
}

