/*
 * Decompiled with CFR 0.152.
 */
package com.blade.server.netty;

import io.netty.channel.ChannelProgressiveFuture;
import io.netty.channel.ChannelProgressiveFutureListener;
import java.io.RandomAccessFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProgressiveFutureListener
implements ChannelProgressiveFutureListener {
    private static final Logger log = LoggerFactory.getLogger(ProgressiveFutureListener.class);
    private RandomAccessFile raf;

    public ProgressiveFutureListener(RandomAccessFile raf) {
        this.raf = raf;
    }

    public void operationProgressed(ChannelProgressiveFuture future, long progress, long total) {
        if (total < 0L) {
            log.debug("{} Transfer progress: {}", (Object)future.channel(), (Object)progress);
        } else {
            log.debug("{} Transfer progress: {}/{}", new Object[]{future.channel(), progress, total});
        }
    }

    public void operationComplete(ChannelProgressiveFuture future) {
        try {
            this.raf.close();
            log.debug("{} Transfer complete.", (Object)future.channel());
        }
        catch (Exception e) {
            log.error("RandomAccessFile close error", (Throwable)e);
        }
    }

    public static ProgressiveFutureListener build(RandomAccessFile raf) {
        return new ProgressiveFutureListener(raf);
    }
}

