/*
 * Decompiled with CFR 0.152.
 */
package com.blade.mvc.websocket;

import com.blade.mvc.handler.WebSocketHandler;
import com.blade.mvc.websocket.WebSocketSession;
import io.netty.channel.ChannelFutureListener;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.util.concurrent.GenericFutureListener;

public class WebSocketContext {
    private WebSocketSession session;
    private String message;
    private WebSocketHandler handler;

    public WebSocketContext(WebSocketSession session, WebSocketHandler handler) {
        this.session = session;
        this.handler = handler;
    }

    public WebSocketContext(WebSocketSession session, WebSocketHandler handler, String message) {
        this(session, handler);
        this.message = message;
    }

    public void message(String value) {
        this.session.handlerContext().writeAndFlush((Object)new TextWebSocketFrame(value));
    }

    public void disconnect() {
        this.session.handlerContext().disconnect().addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        this.handler.onDisConnect(this);
    }

    public WebSocketSession session() {
        return this.session;
    }

    public String message() {
        return this.message;
    }
}

