/*
 * Decompiled with CFR 0.152.
 */
package com.blade.mvc.http;

import com.blade.exception.HttpParseException;
import com.blade.kit.CaseInsensitiveHashMap;
import com.blade.kit.PathKit;
import com.blade.kit.StringKit;
import com.blade.mvc.WebContext;
import com.blade.mvc.handler.SessionHandler;
import com.blade.mvc.http.Cookie;
import com.blade.mvc.http.HttpMethod;
import com.blade.mvc.http.Request;
import com.blade.mvc.http.Session;
import com.blade.mvc.http.session.SessionManager;
import com.blade.mvc.multipart.FileItem;
import com.blade.mvc.route.Route;
import com.blade.server.netty.HttpServerHandler;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import io.netty.handler.codec.http.multipart.Attribute;
import io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import io.netty.handler.codec.http.multipart.DiskAttribute;
import io.netty.handler.codec.http.multipart.DiskFileUpload;
import io.netty.handler.codec.http.multipart.FileUpload;
import io.netty.handler.codec.http.multipart.HttpData;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.util.CharsetUtil;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRequest
implements Request {
    private static final Logger log = LoggerFactory.getLogger(HttpRequest.class);
    private static final HttpDataFactory HTTP_DATA_FACTORY = new DefaultHttpDataFactory(true);
    private static final ByteBuf EMPTY_BUF = Unpooled.copiedBuffer((CharSequence)"", (Charset)CharsetUtil.UTF_8);
    private static final SessionHandler SESSION_HANDLER = new SessionHandler(WebContext.blade());
    private ByteBuf body = EMPTY_BUF;
    private String remoteAddress;
    private String uri;
    private String url;
    private String protocol;
    private String method;
    private boolean keepAlive;
    private Session session;
    private boolean isMultipart;
    private boolean isEnd;
    private boolean initCookie;
    private boolean initQueryParam;
    private HttpData partialContent;
    private HttpHeaders httpHeaders;
    private io.netty.handler.codec.http.HttpRequest nettyRequest;
    private HttpPostRequestDecoder decoder;
    private Queue<HttpContent> contents = new LinkedList<HttpContent>();
    private Map<String, String> headers = null;
    private Map<String, Object> attributes = null;
    private Map<String, String> pathParams = null;
    private Map<String, List<String>> parameters = new HashMap<String, List<String>>(8);
    private Map<String, Cookie> cookies = new HashMap<String, Cookie>(8);
    private Map<String, FileItem> fileItems = new HashMap<String, FileItem>(8);

    public HttpRequest(Request request) {
        this.pathParams = request.pathParams();
        this.cookies = request.cookies();
        this.attributes = request.attributes();
        this.body = request.body();
        this.fileItems = request.fileItems();
        this.headers = request.headers();
        this.keepAlive = request.keepAlive();
        this.method = request.method();
        this.url = request.url();
        if (null != this.url && this.url.length() > 0) {
            int pathEndPos = this.url.indexOf(63);
            this.uri = pathEndPos < 0 ? this.url : this.url.substring(0, pathEndPos);
        }
        this.parameters = request.parameters();
        this.protocol = request.protocol();
    }

    @Override
    public Request initPathParams(@NonNull Route route) {
        if (route == null) {
            throw new NullPointerException("route");
        }
        if (null != route.getPathParams()) {
            this.pathParams = route.getPathParams();
        }
        return this;
    }

    @Override
    public String host() {
        return this.header("Host");
    }

    @Override
    public String remoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public String uri() {
        return this.uri;
    }

    @Override
    public String url() {
        return this.url;
    }

    @Override
    public String protocol() {
        return this.protocol;
    }

    @Override
    public Map<String, String> pathParams() {
        return this.pathParams;
    }

    @Override
    public String queryString() {
        if (null == this.url || !this.url.contains("?")) {
            return "";
        }
        return this.url.substring(this.url.indexOf("?") + 1);
    }

    @Override
    public Map<String, List<String>> parameters() {
        if (this.initQueryParam) {
            return this.parameters;
        }
        this.initQueryParam = true;
        if (!this.url.contains("?")) {
            return this.parameters;
        }
        Map parameters = new QueryStringDecoder(this.url, CharsetUtil.UTF_8).parameters();
        if (null != parameters) {
            this.parameters.putAll(parameters);
        }
        return this.parameters;
    }

    @Override
    public Set<String> parameterNames() {
        return this.parameters.keySet();
    }

    @Override
    public List<String> parameterValues(String paramName) {
        return this.parameters.get(paramName);
    }

    @Override
    public String method() {
        return this.method;
    }

    @Override
    public HttpMethod httpMethod() {
        return HttpMethod.valueOf(this.method());
    }

    @Override
    public boolean useGZIP() {
        boolean useGZIP = WebContext.blade().environment().getBoolean("http.gzip.enable", false);
        if (!useGZIP) {
            return false;
        }
        String acceptEncoding = this.header("Accept-Encoding");
        if (StringKit.isEmpty(acceptEncoding)) {
            return false;
        }
        return acceptEncoding.contains("gzip");
    }

    @Override
    public Session session() {
        return this.session;
    }

    @Override
    public boolean isSecure() {
        return false;
    }

    @Override
    public boolean isIE() {
        String ua = this.userAgent();
        return ua.contains("MSIE") || ua.contains("TRIDENT");
    }

    @Override
    public Map<String, Cookie> cookies() {
        if (!this.initCookie) {
            this.initCookie = true;
            String cookie = this.header("Cookie");
            if (StringKit.isNotEmpty(cookie)) {
                ServerCookieDecoder.LAX.decode(cookie).forEach(this::parseCookie);
            }
        }
        return this.cookies;
    }

    @Override
    public Cookie cookieRaw(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        return this.cookies().get(name);
    }

    @Override
    public Request cookie(@NonNull Cookie cookie) {
        if (cookie == null) {
            throw new NullPointerException("cookie");
        }
        this.cookies().put(cookie.name(), cookie);
        return this;
    }

    @Override
    public Map<String, String> headers() {
        if (null == this.headers) {
            this.headers = new CaseInsensitiveHashMap<String>(this.httpHeaders.size());
            for (Map.Entry header : this.httpHeaders) {
                this.headers.put((String)header.getKey(), (String)header.getValue());
            }
        }
        return this.headers;
    }

    @Override
    public boolean keepAlive() {
        return this.keepAlive;
    }

    @Override
    public Map<String, Object> attributes() {
        if (null == this.attributes) {
            this.attributes = new HashMap<String, Object>(4);
        }
        return this.attributes;
    }

    @Override
    public Map<String, FileItem> fileItems() {
        return this.fileItems;
    }

    @Override
    public ByteBuf body() {
        return this.body;
    }

    @Override
    public boolean chunkIsEnd() {
        return this.isEnd;
    }

    @Override
    public boolean isMultipart() {
        return this.isMultipart;
    }

    public void setNettyRequest(io.netty.handler.codec.http.HttpRequest nettyRequest) {
        this.nettyRequest = nettyRequest;
    }

    public void appendContent(HttpContent msg) {
        this.contents.add(msg.retain());
        if (msg instanceof LastHttpContent) {
            this.isEnd = true;
        }
    }

    public void init(String remoteAddress) {
        SessionManager sessionManager;
        this.remoteAddress = remoteAddress.substring(1);
        this.keepAlive = HttpUtil.isKeepAlive((HttpMessage)this.nettyRequest);
        this.url = this.nettyRequest.uri();
        int pathEndPos = this.url().indexOf(63);
        this.uri = pathEndPos < 0 ? this.url() : this.url().substring(0, pathEndPos);
        this.protocol = this.nettyRequest.protocolVersion().text();
        this.method = this.nettyRequest.method().name();
        String cleanUri = this.uri;
        if (!"/".equals(this.contextPath())) {
            this.uri = cleanUri = PathKit.cleanPath(cleanUri.replaceFirst(this.contextPath(), "/"));
        }
        this.httpHeaders = this.nettyRequest.headers();
        if (!HttpServerHandler.PERFORMANCE && null != (sessionManager = WebContext.blade().sessionManager())) {
            this.session = SESSION_HANDLER.createSession(this);
        }
        if ("GET".equals(this.method())) {
            return;
        }
        try {
            HttpPostRequestDecoder decoder = new HttpPostRequestDecoder(HTTP_DATA_FACTORY, this.nettyRequest);
            this.isMultipart = decoder.isMultipart();
            ArrayList<ByteBuf> byteBuffs = new ArrayList<ByteBuf>(this.contents.size());
            for (HttpContent content : this.contents) {
                if (!this.isMultipart) {
                    byteBuffs.add(content.content().copy());
                }
                decoder.offer(content);
                this.readHttpDataChunkByChunk(decoder);
                content.release();
            }
            if (!byteBuffs.isEmpty()) {
                this.body = Unpooled.copiedBuffer((ByteBuf[])byteBuffs.toArray(new ByteBuf[0]));
            }
        }
        catch (Exception e) {
            throw new HttpParseException("build decoder fail", e);
        }
    }

    private void readHttpDataChunkByChunk(HttpPostRequestDecoder decoder) {
        try {
            InterfaceHttpData data;
            while (decoder.hasNext()) {
                data = decoder.next();
                if (data == null) continue;
                if (this.partialContent == data) {
                    this.partialContent = null;
                }
                try {
                    this.writeHttpData(data);
                }
                finally {
                    data.release();
                }
            }
            data = decoder.currentPartialHttpData();
            if (data != null && this.partialContent == null) {
                this.partialContent = (HttpData)data;
            }
        }
        catch (HttpPostRequestDecoder.EndOfDataDecoderException endOfDataDecoderException) {
            // empty catch block
        }
    }

    private void writeHttpData(InterfaceHttpData data) {
        try {
            InterfaceHttpData.HttpDataType dataType = data.getHttpDataType();
            if (dataType == InterfaceHttpData.HttpDataType.Attribute) {
                this.parseAttribute((Attribute)data);
            } else if (dataType == InterfaceHttpData.HttpDataType.FileUpload) {
                this.parseFileUpload((FileUpload)data);
            }
        }
        catch (IOException e) {
            log.error("Parse request parameter error", (Throwable)e);
        }
    }

    private void parseAttribute(Attribute attribute) throws IOException {
        String name = attribute.getName();
        String value = attribute.getValue();
        if (this.parameters.containsKey(name)) {
            List<String> values = this.parameters.get(name);
            values.add(value);
        } else {
            ArrayList<String> values = new ArrayList<String>();
            values.add(value);
            this.parameters.put(name, values);
        }
    }

    private void parseFileUpload(FileUpload fileUpload) throws IOException {
        if (!fileUpload.isCompleted()) {
            return;
        }
        FileItem fileItem = new FileItem();
        fileItem.setName(fileUpload.getName());
        fileItem.setFileName(fileUpload.getFilename());
        Path tmpFile = Files.createTempFile(Paths.get(fileUpload.getFile().getParent(), new String[0]), "blade_", "_upload", new FileAttribute[0]);
        Path fileUploadPath = Paths.get(fileUpload.getFile().getPath(), new String[0]);
        Files.move(fileUploadPath, tmpFile, StandardCopyOption.REPLACE_EXISTING);
        fileItem.setFile(tmpFile.toFile());
        fileItem.setPath(tmpFile.toFile().getPath());
        fileItem.setContentType(fileUpload.getContentType());
        fileItem.setLength(fileUpload.length());
        this.fileItems.put(fileItem.getName(), fileItem);
    }

    private void parseCookie(io.netty.handler.codec.http.cookie.Cookie nettyCookie) {
        Cookie cookie = new Cookie();
        cookie.name(nettyCookie.name());
        cookie.value(nettyCookie.value());
        cookie.httpOnly(nettyCookie.isHttpOnly());
        cookie.path(nettyCookie.path());
        cookie.domain(nettyCookie.domain());
        cookie.maxAge(nettyCookie.maxAge());
        this.cookies.put(cookie.name(), cookie);
    }

    public HttpRequest() {
    }

    static {
        DiskFileUpload.deleteOnExitTemporaryFile = true;
        DiskFileUpload.baseDirectory = null;
        DiskAttribute.deleteOnExitTemporaryFile = true;
        DiskAttribute.baseDirectory = null;
    }
}

