/*
 * Decompiled with CFR 0.152.
 */
package com.blade.mvc.handler;

import com.blade.Blade;
import com.blade.kit.ReflectKit;
import com.blade.mvc.annotation.OnClose;
import com.blade.mvc.annotation.OnMessage;
import com.blade.mvc.annotation.OnOpen;
import com.blade.mvc.handler.WebSocketHandler;
import com.blade.mvc.websocket.WebSocketContext;
import io.netty.util.concurrent.FastThreadLocal;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WebSocketHandlerWrapper
implements WebSocketHandler {
    private static final Logger log = LoggerFactory.getLogger(WebSocketHandlerWrapper.class);
    private final Map<String, Class<?>> handlers = new HashMap(4);
    private final Map<String, Map<Class<? extends Annotation>, Method>> methodCache = new HashMap<String, Map<Class<? extends Annotation>, Method>>(4);
    private final FastThreadLocal<String> path = new FastThreadLocal();
    private final Blade blade;

    public static WebSocketHandlerWrapper init(Blade blade) {
        return new WebSocketHandlerWrapper(blade);
    }

    private WebSocketHandlerWrapper(Blade blade) {
        this.blade = blade;
    }

    public void setPath(String path) {
        this.path.set((Object)path);
    }

    public void wrapHandler(String path, Class<?> handler) {
        Method[] methods = handler.getMethods();
        HashMap<Class<? extends Annotation>, Method> cache = new HashMap<Class<? extends Annotation>, Method>(3);
        WebSocketHandlerWrapper.cacheMethod(cache, methods, OnOpen.class);
        WebSocketHandlerWrapper.cacheMethod(cache, methods, OnMessage.class);
        WebSocketHandlerWrapper.cacheMethod(cache, methods, OnClose.class);
        if (cache.size() <= 0) {
            throw new RuntimeException("Do not found any annotation of [@OnOpen / @OnMessage / @OnClose] in class: " + handler.getName());
        }
        this.methodCache.put(path, cache);
        this.handlers.put(path, handler);
    }

    private static void cacheMethod(Map<Class<? extends Annotation>, Method> cache, Method[] methods, Class<? extends Annotation> filter) {
        List methodList = Stream.of(methods).filter(method -> method.isAnnotationPresent(filter)).collect(Collectors.toList());
        if (methodList.size() == 1) {
            cache.put(filter, (Method)methodList.get(0));
        } else if (methodList.size() > 1) {
            throw new RuntimeException("Duplicate annotation @" + filter.getSimpleName() + " in class: " + ((Method)methodList.get(0)).getDeclaringClass().getName());
        }
    }

    @Override
    public void onConnect(WebSocketContext ctx) {
        this.invoke(ctx, OnOpen.class);
    }

    @Override
    public void onText(WebSocketContext ctx) {
        this.invoke(ctx, OnMessage.class);
    }

    @Override
    public void onDisConnect(WebSocketContext ctx) {
        this.invoke(ctx, OnClose.class);
    }

    private void invoke(WebSocketContext ctx, Class<? extends Annotation> event) {
        Method method;
        Map<Class<? extends Annotation>, Method> methodCache = this.methodCache.get(this.path.get());
        if (methodCache != null && (method = methodCache.get(event)) != null) {
            Class<?>[] paramTypes = method.getParameterTypes();
            Object[] param = new Object[paramTypes.length];
            try {
                for (int i = 0; i < paramTypes.length; ++i) {
                    Object bean;
                    Class<?> paramType = paramTypes[i];
                    param[i] = paramType == WebSocketContext.class ? ctx : ((bean = this.blade.getBean(paramType)) != null ? bean : ReflectKit.newInstance(paramType));
                }
                method.invoke(this.blade.getBean(this.handlers.get(this.path.get())), param);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

