/*
 * Decompiled with CFR 0.152.
 */
package com.blade.kit;

import com.blade.exception.BladeException;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class UncheckedFnKit {
    public static <T> Consumer<T> consumer(Consumer_WithExceptions<T, Throwable> consumer) {
        return t -> {
            try {
                consumer.accept(t);
            }
            catch (Throwable throwable) {
                throw new BladeException(throwable);
            }
        };
    }

    public static <T, U> BiConsumer<T, U> biConsumer(BiConsumer_WithExceptions<T, U, Throwable> biConsumer) {
        return (t, u) -> {
            try {
                biConsumer.accept(t, u);
            }
            catch (Throwable throwable) {
                throw new BladeException(throwable);
            }
        };
    }

    public static <T, R> Function<T, R> function(Function_WithExceptions<T, R, Throwable> function) {
        return t -> {
            try {
                return function.apply(t);
            }
            catch (Throwable throwable) {
                throw new BladeException(throwable);
            }
        };
    }

    public static <T> Supplier<T> supplier(Supplier_WithExceptions<T, Throwable> function) {
        return () -> {
            try {
                return function.get();
            }
            catch (Throwable throwable) {
                throw new BladeException(throwable);
            }
        };
    }

    public static Runnable runnable(Runnable_WithExceptions t) {
        return () -> {
            try {
                t.run();
            }
            catch (Throwable throwable) {
                throw new BladeException(throwable);
            }
        };
    }

    @FunctionalInterface
    public static interface Runnable_WithExceptions<E extends Throwable> {
        public void run() throws E;
    }

    @FunctionalInterface
    public static interface Supplier_WithExceptions<T, E extends Throwable> {
        public T get() throws E;
    }

    @FunctionalInterface
    public static interface Function_WithExceptions<T, R, E extends Throwable> {
        public R apply(T var1) throws E;
    }

    @FunctionalInterface
    public static interface BiConsumer_WithExceptions<T, U, E extends Throwable> {
        public void accept(T var1, U var2) throws E;
    }

    @FunctionalInterface
    public static interface Consumer_WithExceptions<T, E extends Throwable> {
        public void accept(T var1) throws E;
    }
}

