/*
 * Decompiled with CFR 0.152.
 */
package com.blade.kit;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;

public class CaseInsensitiveHashMap<V>
extends LinkedHashMap<String, V> {
    private final Map<String, String> KEY_MAPPING;

    public CaseInsensitiveHashMap() {
        this.KEY_MAPPING = new HashMap<String, String>();
    }

    public CaseInsensitiveHashMap(int initialCapacity) {
        super(initialCapacity);
        this.KEY_MAPPING = new HashMap<String, String>(initialCapacity);
    }

    public CaseInsensitiveHashMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
        this.KEY_MAPPING = new HashMap<String, String>(initialCapacity);
    }

    @Override
    public boolean containsKey(Object key) {
        return super.containsKey(this.realKey(key));
    }

    @Override
    public V get(Object key) {
        return super.get(this.realKey(key));
    }

    @Override
    public V put(String key, V value) {
        if (key == null) {
            return super.put(null, value);
        }
        String oldKey = this.KEY_MAPPING.put(key.toLowerCase(Locale.ENGLISH), key);
        Object oldValue = super.remove(oldKey);
        super.put(key, value);
        return oldValue;
    }

    @Override
    public void putAll(Map<? extends String, ? extends V> m) {
        m.forEach(this::put);
    }

    @Override
    public V remove(Object key) {
        String realKey = key != null ? this.KEY_MAPPING.remove(key.toString().toLowerCase(Locale.ENGLISH)) : null;
        return super.remove(realKey);
    }

    @Override
    public V getOrDefault(Object key, V defaultValue) {
        if (key != null && !this.KEY_MAPPING.containsKey(key.toString().toLowerCase(Locale.ENGLISH))) {
            return defaultValue;
        }
        return super.getOrDefault(this.realKey(key), defaultValue);
    }

    @Override
    public void clear() {
        this.KEY_MAPPING.clear();
        super.clear();
    }

    private Object realKey(Object key) {
        if (key != null) {
            return this.KEY_MAPPING.get(key.toString().toLowerCase(Locale.ENGLISH));
        }
        return null;
    }
}

