/**
 * Copyright (c) 2018, biezhi 王爵 (biezhi.me@gmail.com)
 * <p>
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * <p>
 * http://www.apache.org/licenses/LICENSE-2.0
 * <p>
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.blade.exception;

import lombok.Getter;

/**
 * Java Bean Validator Exception
 *
 * @author biezhi
 * @date 2018/4/21
 */
public class ValidatorException extends RuntimeException {

    @Getter
    private Integer code;

    public ValidatorException(Integer code, String message) {
        super(message);
        this.code = code;
    }

    public ValidatorException(String message) {
        super(message);
    }

}
