/*
 * Decompiled with CFR 0.152.
 */
package com.blade.test;

import com.blade.Blade;
import com.blade.ioc.annotation.Inject;
import com.blade.test.BladeApplication;
import java.lang.reflect.Field;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;

public class BladeTestRunner
extends BlockJUnit4ClassRunner {
    private Class<?> clazz;
    private Class<?> mainCls;
    private Blade blade;

    public BladeTestRunner(Class<?> clazz) throws InitializationError {
        super(clazz);
        this.clazz = clazz;
        BladeApplication bladeApplication = clazz.getAnnotation(BladeApplication.class);
        if (null == bladeApplication) {
            throw new RuntimeException("Please use @BladeApplication configuration main class type :)");
        }
        this.mainCls = bladeApplication.value();
    }

    protected Statement withBeforeClasses(Statement statement) {
        final Statement junitStatement = super.withBeforeClasses(statement);
        return new Statement(){

            public void evaluate() throws Throwable {
                BladeTestRunner.this.blade = Blade.me().start(BladeTestRunner.this.mainCls, new String[0]).await();
                junitStatement.evaluate();
            }
        };
    }

    protected Statement withBefores(FrameworkMethod method, Object target, Statement statement) {
        Field[] declaredFields;
        for (Field declaredField : declaredFields = this.clazz.getDeclaredFields()) {
            Inject inject = declaredField.getAnnotation(Inject.class);
            if (null == inject) continue;
            Object bean = this.blade.getBean(declaredField.getType());
            try {
                declaredField.setAccessible(true);
                declaredField.set(target, bean);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        final Statement junitStatement = super.withBefores(method, target, statement);
        return new Statement(){

            public void evaluate() throws Throwable {
                junitStatement.evaluate();
            }
        };
    }

    protected Statement withAfters(FrameworkMethod method, Object target, Statement statement) {
        final Statement junitStatement = super.withAfters(method, target, statement);
        return new Statement(){

            public void evaluate() throws Throwable {
                junitStatement.evaluate();
            }
        };
    }

    protected Statement withAfterClasses(Statement statement) {
        final Statement junitStatement = super.withAfterClasses(statement);
        return new Statement(){

            public void evaluate() throws Throwable {
                junitStatement.evaluate();
                BladeTestRunner.this.blade.stop();
            }
        };
    }
}

