/*
 * Decompiled with CFR 0.152.
 */
package com.blade.server.netty;

import com.blade.exception.BladeException;
import com.blade.exception.InternalErrorException;
import com.blade.exception.NotFoundException;
import com.blade.kit.BladeCache;
import com.blade.kit.BladeKit;
import com.blade.kit.ReflectKit;
import com.blade.mvc.RouteContext;
import com.blade.mvc.WebContext;
import com.blade.mvc.annotation.JSON;
import com.blade.mvc.annotation.Path;
import com.blade.mvc.handler.RequestHandler;
import com.blade.mvc.handler.RouteHandler;
import com.blade.mvc.handler.RouteHandler0;
import com.blade.mvc.hook.WebHook;
import com.blade.mvc.http.BodyWriter;
import com.blade.mvc.http.Cookie;
import com.blade.mvc.http.RawBody;
import com.blade.mvc.http.Request;
import com.blade.mvc.http.Response;
import com.blade.mvc.http.Session;
import com.blade.mvc.http.ViewBody;
import com.blade.mvc.route.Route;
import com.blade.mvc.route.RouteMatcher;
import com.blade.mvc.ui.ModelAndView;
import com.blade.reflectasm.MethodAccess;
import com.blade.server.netty.HttpConst;
import com.blade.server.netty.HttpServerInitializer;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.cookie.ServerCookieEncoder;
import io.netty.handler.stream.ChunkedStream;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.Closeable;
import java.io.InputStream;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouteMethodHandler
implements RequestHandler {
    private static final Logger log = LoggerFactory.getLogger(RouteMethodHandler.class);
    private final RouteMatcher routeMatcher = WebContext.blade().routeMatcher();
    private final boolean hasMiddleware = this.routeMatcher.getMiddleware().size() > 0;
    private final boolean hasBeforeHook = this.routeMatcher.hasBeforeHook();
    private final boolean hasAfterHook = this.routeMatcher.hasAfterHook();

    @Override
    public void handle(WebContext webContext) throws Exception {
        RouteContext context = new RouteContext(webContext.getRequest(), webContext.getResponse());
        String uri = context.uri();
        Route route = webContext.getRoute();
        if (null == route) {
            throw new NotFoundException(context.uri());
        }
        context.initRoute(route);
        if (this.hasMiddleware && !this.invokeMiddleware(this.routeMatcher.getMiddleware(), context)) {
            return;
        }
        context.injectParameters();
        if (this.hasBeforeHook && !this.invokeHook(this.routeMatcher.getBefore(uri), context)) {
            return;
        }
        this.routeHandle(context);
        if (this.hasAfterHook) {
            this.invokeHook(this.routeMatcher.getAfter(uri), context);
        }
    }

    public FullHttpResponse handleResponse(final Request request, final Response response, final ChannelHandlerContext context) {
        Session session = request.session();
        if (null != session) {
            Cookie cookie = new Cookie();
            cookie.name(WebContext.sessionKey());
            cookie.value(session.id());
            cookie.httpOnly(true);
            cookie.secure(request.isSecure());
            response.cookie(cookie);
        }
        FullHttpResponse fullHttpResponse = response.body().write(new BodyWriter(){

            @Override
            public FullHttpResponse onByteBuf(ByteBuf byteBuf) {
                return RouteMethodHandler.this.createResponseByByteBuf(response, byteBuf);
            }

            @Override
            public FullHttpResponse onStream(Closeable closeable) {
                return null;
            }

            @Override
            public FullHttpResponse onView(ViewBody body) {
                try {
                    StringWriter sw = new StringWriter();
                    WebContext.blade().templateEngine().render(body.modelAndView(), sw);
                    WebContext.response().contentType("text/html; charset=UTF-8");
                    return this.onByteBuf(Unpooled.copiedBuffer((byte[])sw.toString().getBytes(StandardCharsets.UTF_8)));
                }
                catch (Exception e) {
                    log.error("Render view error", (Throwable)e);
                    return null;
                }
            }

            @Override
            public FullHttpResponse onRawBody(RawBody body) {
                return body.httpResponse();
            }

            @Override
            public FullHttpResponse onByteBuf(Object byteBuf) {
                DefaultHttpResponse httpResponse = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf((int)response.statusCode()));
                for (Map.Entry<String, String> next : response.headers().entrySet()) {
                    httpResponse.headers().set(next.getKey(), (Object)next.getValue());
                }
                if (request.keepAlive()) {
                    httpResponse.headers().set((CharSequence)HttpConst.CONNECTION, (Object)HttpConst.KEEP_ALIVE);
                }
                context.write((Object)httpResponse, context.voidPromise());
                ChannelFuture lastContentFuture = context.writeAndFlush(byteBuf);
                if (!request.keepAlive()) {
                    lastContentFuture.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                }
                return null;
            }
        });
        if (request.keepAlive()) {
            fullHttpResponse.headers().set((CharSequence)HttpConst.CONNECTION, (Object)HttpConst.KEEP_ALIVE);
        }
        return fullHttpResponse;
    }

    private void setDefaultHeaders(HttpHeaders headers) {
        headers.set((CharSequence)HttpConst.DATE, (Object)HttpServerInitializer.date);
        headers.set((CharSequence)HttpConst.X_POWER_BY, (Object)HttpConst.HEADER_VERSION);
    }

    public Void handleStreamResponse(Response response, InputStream body, ChannelHandlerContext context, boolean keepAlive) {
        DefaultHttpResponse httpResponse = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf((int)response.statusCode()));
        httpResponse.headers().set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
        this.setDefaultHeaders(httpResponse.headers());
        for (Map.Entry<String, String> next : response.headers().entrySet()) {
            httpResponse.headers().set(next.getKey(), (Object)next.getValue());
        }
        context.write((Object)response);
        context.write((Object)new ChunkedStream(body));
        ChannelFuture lastContentFuture = context.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
        if (!keepAlive) {
            lastContentFuture.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
        return null;
    }

    private FullHttpResponse createResponseByByteBuf(Response response, ByteBuf byteBuf) {
        Map<String, String> headers = response.headers();
        DefaultFullHttpResponse httpResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf((int)response.statusCode()), byteBuf);
        httpResponse.headers().set((CharSequence)HttpConst.CONTENT_LENGTH, (Object)httpResponse.content().readableBytes());
        this.setDefaultHeaders(httpResponse.headers());
        if (response.cookiesRaw().size() > 0) {
            this.appendCookie(response, httpResponse);
        }
        for (Map.Entry<String, String> next : headers.entrySet()) {
            httpResponse.headers().set((CharSequence)HttpConst.getAsciiString(next.getKey()), (Object)next.getValue());
        }
        return httpResponse;
    }

    private void appendCookie(Response response, DefaultFullHttpResponse httpResponse) {
        for (io.netty.handler.codec.http.cookie.Cookie next : response.cookiesRaw()) {
            httpResponse.headers().add((CharSequence)HttpConst.SET_COOKIE, (Object)ServerCookieEncoder.LAX.encode(next));
        }
    }

    private void routeHandle(RouteContext context) {
        Object routeHandler;
        Object target = context.routeTarget();
        if (null == target) {
            Class<?> clazz = context.routeAction().getDeclaringClass();
            target = WebContext.blade().getBean(clazz);
        }
        if (context.targetType() == RouteHandler.class) {
            routeHandler = (RouteHandler)target;
            routeHandler.handle(context);
        } else if (context.targetType() == RouteHandler0.class) {
            routeHandler = (RouteHandler0)target;
            routeHandler.handle(context.request(), context.response());
        } else {
            boolean isRestful;
            Method actionMethod = context.routeAction();
            Class<?> returnType = actionMethod.getReturnType();
            Path path = target.getClass().getAnnotation(Path.class);
            JSON JSON2 = actionMethod.getAnnotation(JSON.class);
            boolean bl = isRestful = null != JSON2 || null != path && path.restful();
            if (isRestful) {
                if (!context.isIE()) {
                    context.contentType("application/json; charset=UTF-8");
                } else {
                    context.contentType("text/html; charset=UTF-8");
                }
            }
            int len = actionMethod.getParameterTypes().length;
            MethodAccess methodAccess = BladeCache.getMethodAccess(target.getClass());
            Object returnParam = methodAccess.invoke(target, actionMethod.getName(), len > 0 ? context.routeParameters() : null);
            if (null == returnParam) {
                return;
            }
            if (isRestful) {
                context.json(returnParam);
                return;
            }
            if (returnType == String.class) {
                context.body(ViewBody.of(new ModelAndView(returnParam.toString())));
                return;
            }
            if (returnType == ModelAndView.class) {
                context.body(ViewBody.of((ModelAndView)returnParam));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean invokeHook(RouteContext context, Route hookRoute) throws Exception {
        Object returnParam;
        Method hookMethod = hookRoute.getAction();
        Object target = WebContext.blade().ioc().getBean(hookRoute.getTargetType());
        if (null == target) {
            Class<?> clazz = hookRoute.getAction().getDeclaringClass();
            target = WebContext.blade().ioc().getBean(clazz);
            hookRoute.setTarget(target);
        }
        int len = hookMethod.getParameterTypes().length;
        hookMethod.setAccessible(true);
        if (len > 0) {
            MethodAccess methodAccess;
            if (len == 1) {
                methodAccess = BladeCache.getMethodAccess(target.getClass());
                returnParam = methodAccess.invoke(target, hookMethod.getName(), new Object[]{context});
            } else {
                if (len != 2) throw new InternalErrorException("Bad web hook structure");
                methodAccess = BladeCache.getMethodAccess(target.getClass());
                returnParam = methodAccess.invoke(target, hookMethod.getName(), new Object[]{context.request(), context.response()});
            }
        } else {
            returnParam = ReflectKit.invokeMethod(target, hookMethod, new Object[0]);
        }
        if (null == returnParam) {
            return true;
        }
        Class<?> returnType = returnParam.getClass();
        if (returnType != Boolean.class && returnType != Boolean.TYPE) return true;
        return Boolean.valueOf(returnParam.toString());
    }

    private boolean invokeMiddleware(List<Route> middleware, RouteContext context) throws BladeException {
        if (BladeKit.isEmpty(middleware)) {
            return true;
        }
        for (Route route : middleware) {
            WebHook webHook = (WebHook)WebContext.blade().ioc().getBean(route.getTargetType());
            boolean flag = webHook.before(context);
            if (flag) continue;
            return false;
        }
        return true;
    }

    private boolean invokeHook(List<Route> hooks, RouteContext context) throws Exception {
        for (Route hook : hooks) {
            if (hook.getTargetType() == RouteHandler.class) {
                RouteHandler routeHandler = (RouteHandler)hook.getTarget();
                routeHandler.handle(context);
                if (!context.isAbort()) continue;
                return false;
            }
            if (hook.getTargetType() == RouteHandler0.class) {
                RouteHandler0 routeHandler = (RouteHandler0)hook.getTarget();
                routeHandler.handle(context.request(), context.response());
                continue;
            }
            boolean flag = this.invokeHook(context, hook);
            if (flag) continue;
            return false;
        }
        return true;
    }
}

