/*
 * Decompiled with CFR 0.152.
 */
package com.blade.mvc.route;

import com.blade.kit.StringKit;
import com.blade.mvc.route.PathBuilderMeta;
import java.util.Arrays;

public class PathRegexBuilder {
    private static final String PATH_VARIABLE_REPLACE = "([^/]+)";
    private static final String DEFAULT_SEPARATOR = "/";
    private static final String DEFAULT_START = "(/";
    private static final String DEFAULT_END = ")|";
    private final StringBuilder pathBuilder = new StringBuilder("(/");
    private final String separator;

    public PathRegexBuilder() {
        this.separator = DEFAULT_SEPARATOR;
    }

    private void join(PathBuilderMeta row) {
        if (row.getType() == PathBuilderMeta.PathTypeEnum.COMMON) {
            this.pathBuilder.append(row.getName()).append(this.separator);
        } else {
            this.pathBuilder.append(row.getRegex()).append(this.separator);
        }
    }

    public String build(boolean isSuffix) {
        if (isSuffix) {
            this.pathBuilder.append(DEFAULT_END);
        }
        return this.pathBuilder.toString();
    }

    public String parsePath(String path) {
        if (StringKit.isBlank(path)) {
            return path;
        }
        String[] pathModule = path.split(DEFAULT_SEPARATOR);
        Arrays.stream(pathModule).filter(row -> !row.isEmpty()).map(this::rowToPath).forEach(this::join);
        this.pathBuilder.deleteCharAt(this.pathBuilder.length() - 1);
        return this.build(true);
    }

    private PathBuilderMeta rowToPath(String row) {
        if (!row.contains(":")) {
            return PathBuilderMeta.builder().name(row).type(PathBuilderMeta.PathTypeEnum.COMMON).build();
        }
        String[] itemPath = row.split(":");
        if (StringKit.isBlank(itemPath[0])) {
            return PathBuilderMeta.builder().name(itemPath[1]).regex(PATH_VARIABLE_REPLACE).type(PathBuilderMeta.PathTypeEnum.PARAM).build();
        }
        return PathBuilderMeta.builder().name(itemPath[0]).regex("(" + itemPath[1] + ")").type(PathBuilderMeta.PathTypeEnum.REGEX).build();
    }
}

