/*
 * Decompiled with CFR 0.152.
 */
package com.blade.kit.reload;

import com.blade.Environment;
import com.blade.mvc.Const;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileChangeDetector {
    private static final Logger log = LoggerFactory.getLogger(FileChangeDetector.class);
    private WatchService watcher;
    private Map<WatchKey, Path> pathMap = new HashMap<WatchKey, Path>();

    public FileChangeDetector(String dirPath) throws IOException {
        this.watcher = FileSystems.getDefault().newWatchService();
        this.registerAll(Paths.get(dirPath, new String[0]));
    }

    private void register(Path dir) throws IOException {
        WatchKey key = dir.register(this.watcher, StandardWatchEventKinds.ENTRY_MODIFY);
        this.pathMap.put(key, dir);
    }

    private void registerAll(Path dir) throws IOException {
        Files.walkFileTree(dir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                FileChangeDetector.this.register(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public void processEvent(BiConsumer<WatchEvent.Kind<Path>, Path> processor) {
        while (true) {
            WatchKey key;
            try {
                key = this.watcher.take();
            }
            catch (InterruptedException e) {
                return;
            }
            Path dir = this.pathMap.get(key);
            for (WatchEvent<?> event : key.pollEvents()) {
                WatchEvent.Kind<?> kind = event.kind();
                Path filePath = dir.resolve((Path)event.context());
                if (Files.isDirectory(filePath, new LinkOption[0])) continue;
                log.info("File {} changes detected!", (Object)filePath.toString());
                processor.accept(kind, filePath);
            }
            key.reset();
        }
    }

    public static Path getDestPath(Path src, Environment env) {
        String templateDir = env.get("mvc.template.path", "/templates");
        Optional<String> staticDir = env.get("mvc.statics");
        ArrayList<String> templateOrStaticDirKeyword = new ArrayList<String>();
        templateOrStaticDirKeyword.add(templateDir);
        if (staticDir.isPresent()) {
            templateOrStaticDirKeyword.addAll(Arrays.asList(staticDir.get().split(",")));
        } else {
            templateOrStaticDirKeyword.addAll(Const.DEFAULT_STATICS);
        }
        List result = templateOrStaticDirKeyword.stream().filter(dir -> src.toString().indexOf((String)dir) != -1).collect(Collectors.toList());
        if (result.size() != 1) {
            log.info("Cannot get dest dir");
            return null;
        }
        String key = (String)result.get(0);
        log.info(Const.CLASSPATH + src.toString().substring(src.toString().indexOf(key)));
        return Paths.get(Const.CLASSPATH + src.toString().substring(src.toString().indexOf(key)), new String[0]);
    }
}

