/*
 * Decompiled with CFR 0.152.
 */
package com.blade.reflectasm.method;

import com.blade.reflectasm.method.EmptyMethodVisitor;
import com.blade.reflectasm.method.MethodParameter;
import java.lang.reflect.Array;
import org.objectweb.asm.Label;

public final class ParamExtractor
extends EmptyMethodVisitor {
    private final int paramCount;
    private final int ignoreCount;
    private MethodParameter[] methodParameters;
    private int currentParam;
    boolean debugInfoPresent;

    ParamExtractor(int ignoreCount, int paramCount) {
        this.ignoreCount = ignoreCount;
        this.paramCount = paramCount;
        this.methodParameters = new MethodParameter[paramCount];
        this.currentParam = 0;
        this.debugInfoPresent = paramCount == 0;
    }

    @Override
    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
        if (index >= this.ignoreCount && index < this.ignoreCount + this.paramCount) {
            if (!name.equals("arg" + this.currentParam)) {
                this.debugInfoPresent = true;
            }
            if (signature == null) {
                signature = desc;
            }
            this.methodParameters[this.currentParam] = new MethodParameter(name, signature);
            ++this.currentParam;
        }
    }

    @Override
    public void visitEnd() {
        if (this.methodParameters.length > this.currentParam) {
            this.methodParameters = ParamExtractor.subarray(this.methodParameters, 0, this.currentParam);
        }
    }

    MethodParameter[] getMethodParameters() {
        return this.methodParameters;
    }

    public static <T> T[] subarray(T[] buffer, int offset, int length) {
        Class<?> componentType = buffer.getClass().getComponentType();
        return ParamExtractor.subarray(buffer, offset, length, componentType);
    }

    public static <T> T[] subarray(T[] buffer, int offset, int length, Class<T> componentType) {
        Object[] temp = (Object[])Array.newInstance(componentType, length);
        System.arraycopy(buffer, offset, temp, 0, length);
        return temp;
    }
}

