/*
 * Decompiled with CFR 0.152.
 */
package com.birbit.android.jobqueue.persistentQueue.sqlite;

import androidx.collection.LruCache;
import com.birbit.android.jobqueue.Constraint;
import com.birbit.android.jobqueue.TagConstraint;
import com.birbit.android.jobqueue.persistentQueue.sqlite.DbOpenHelper;
import com.birbit.android.jobqueue.persistentQueue.sqlite.SqlHelper;
import com.birbit.android.jobqueue.persistentQueue.sqlite.Where;

class WhereQueryCache {
    private static final int INT_SIZE = 6;
    private static final int BOOL_SIZE = 1;
    private static final int TAG_TYPE = 0;
    private static final int TAG_COUNT = 2;
    private static final int GROUP_COUNT = 8;
    private static final int JOB_COUNT = 14;
    private static final int EXCLUDE_RUNNING = 20;
    private static final int TIME_LIMIT = 21;
    private static final int INT_LIMIT = 64;
    static final int DEADLINE_COLUMN_INDEX = 1;
    private final LruCache<Long, Where> queryCache = new LruCache<Long, Where>(15){

        protected void entryRemoved(boolean evicted, Long key, Where oldValue, Where newValue) {
            oldValue.destroy();
        }
    };
    private final String sessionId;

    public WhereQueryCache(long sessionId) {
        this.sessionId = Long.toString(sessionId);
    }

    public Where build(Constraint constraint, StringBuilder stringBuilder) {
        Where where;
        boolean cacheable = this.isCacheable(constraint);
        long cacheKey = this.cacheKey(constraint);
        Where where2 = where = cacheable ? (Where)this.queryCache.get((Object)cacheKey) : null;
        if (where == null) {
            where = this.createWhere(cacheKey, constraint, stringBuilder);
            if (cacheable) {
                this.queryCache.put((Object)cacheKey, (Object)where);
            }
        }
        this.fillWhere(constraint, where);
        return where;
    }

    private void fillWhere(Constraint constraint, Where where) {
        int count = 0;
        where.args[count++] = Long.toString(constraint.getNowInNs());
        where.args[count++] = Integer.toString(constraint.getMaxNetworkType());
        if (constraint.getTimeLimit() != null) {
            where.args[count++] = Long.toString(constraint.getTimeLimit());
        }
        if (constraint.getTagConstraint() != null) {
            for (String tag : constraint.getTags()) {
                where.args[count++] = tag;
            }
        }
        for (String group : constraint.getExcludeGroups()) {
            where.args[count++] = group;
        }
        for (String jobId : constraint.getExcludeJobIds()) {
            where.args[count++] = jobId;
        }
        if (constraint.excludeRunning()) {
            where.args[count++] = this.sessionId;
        }
        if (count != where.args.length) {
            throw new IllegalStateException("something is wrong with where query cache for " + where.query);
        }
    }

    private Where createWhere(long cacheKey, Constraint constraint, StringBuilder reusedStringBuilder) {
        reusedStringBuilder.setLength(0);
        int argCount = 0;
        reusedStringBuilder.append("( (").append(DbOpenHelper.DEADLINE_COLUMN.columnName).append(" != ").append(Where.FOREVER).append(" AND ").append(DbOpenHelper.DEADLINE_COLUMN.columnName).append(" <= ?) OR ");
        ++argCount;
        reusedStringBuilder.append(DbOpenHelper.REQUIRED_NETWORK_TYPE_COLUMN.columnName).append(" <= ?)");
        reusedStringBuilder.append(" AND (").append(DbOpenHelper.CANCELLED_COLUMN.columnName).append(" IS NULL OR ").append(DbOpenHelper.CANCELLED_COLUMN.columnName).append(" != 1)");
        ++argCount;
        if (constraint.getTimeLimit() != null) {
            reusedStringBuilder.append(" AND ").append(DbOpenHelper.DELAY_UNTIL_NS_COLUMN.columnName).append(" <= ?");
            ++argCount;
        }
        if (constraint.getTagConstraint() != null) {
            if (constraint.getTags().isEmpty()) {
                reusedStringBuilder.append(" AND 0 ");
            } else {
                reusedStringBuilder.append(" AND ").append(DbOpenHelper.ID_COLUMN.columnName).append(" IN ( SELECT ").append(DbOpenHelper.TAGS_JOB_ID_COLUMN.columnName).append(" FROM ").append("job_holder_tags").append(" WHERE ").append(DbOpenHelper.TAGS_NAME_COLUMN.columnName).append(" IN (");
                SqlHelper.addPlaceholdersInto(reusedStringBuilder, constraint.getTags().size());
                reusedStringBuilder.append(")");
                if (constraint.getTagConstraint() == TagConstraint.ANY) {
                    reusedStringBuilder.append(")");
                } else if (constraint.getTagConstraint() == TagConstraint.ALL) {
                    reusedStringBuilder.append(" GROUP BY (`").append(DbOpenHelper.TAGS_JOB_ID_COLUMN.columnName).append("`)").append(" HAVING count(*) = ").append(constraint.getTags().size()).append(")");
                } else {
                    throw new IllegalArgumentException("unknown constraint " + constraint);
                }
                argCount += constraint.getTags().size();
            }
        }
        if (!constraint.getExcludeGroups().isEmpty()) {
            reusedStringBuilder.append(" AND (").append(DbOpenHelper.GROUP_ID_COLUMN.columnName).append(" IS NULL OR ").append(DbOpenHelper.GROUP_ID_COLUMN.columnName).append(" NOT IN(");
            SqlHelper.addPlaceholdersInto(reusedStringBuilder, constraint.getExcludeGroups().size());
            reusedStringBuilder.append("))");
            argCount += constraint.getExcludeGroups().size();
        }
        if (!constraint.getExcludeJobIds().isEmpty()) {
            reusedStringBuilder.append(" AND ").append(DbOpenHelper.ID_COLUMN.columnName).append(" NOT IN(");
            SqlHelper.addPlaceholdersInto(reusedStringBuilder, constraint.getExcludeJobIds().size());
            reusedStringBuilder.append(")");
            argCount += constraint.getExcludeJobIds().size();
        }
        if (constraint.excludeRunning()) {
            reusedStringBuilder.append(" AND ").append(DbOpenHelper.RUNNING_SESSION_ID_COLUMN.columnName).append(" != ?");
            ++argCount;
        }
        String[] args = new String[argCount];
        Where where = new Where(cacheKey, reusedStringBuilder.toString(), args);
        return where;
    }

    private boolean isCacheable(Constraint constraint) {
        return constraint.getTags().size() < 64 && constraint.getExcludeGroups().size() < 64 && constraint.getExcludeJobIds().size() < 64;
    }

    private long cacheKey(Constraint constraint) {
        long key = (constraint.getTagConstraint() == null ? 2 : constraint.getTagConstraint().ordinal()) << 0 | constraint.getTags().size() << 2 | constraint.getExcludeGroups().size() << 8 | constraint.getExcludeJobIds().size() << 14 | (constraint.excludeRunning() ? 1 : 0) << 20 | (constraint.getTimeLimit() == null ? 1 : 0) << 21;
        return key;
    }
}

