/*
 * Decompiled with CFR 0.152.
 */
package com.birbit.android.jobqueue.persistentQueue.sqlite;

import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteDoneException;
import android.database.sqlite.SQLiteStatement;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.birbit.android.jobqueue.Constraint;
import com.birbit.android.jobqueue.Job;
import com.birbit.android.jobqueue.JobHolder;
import com.birbit.android.jobqueue.JobQueue;
import com.birbit.android.jobqueue.config.Configuration;
import com.birbit.android.jobqueue.log.JqLog;
import com.birbit.android.jobqueue.persistentQueue.sqlite.DbOpenHelper;
import com.birbit.android.jobqueue.persistentQueue.sqlite.FileStorage;
import com.birbit.android.jobqueue.persistentQueue.sqlite.SqlHelper;
import com.birbit.android.jobqueue.persistentQueue.sqlite.Where;
import com.birbit.android.jobqueue.persistentQueue.sqlite.WhereQueryCache;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class SqliteJobQueue
implements JobQueue {
    private DbOpenHelper dbOpenHelper;
    private final long sessionId;
    private SQLiteDatabase db;
    private SqlHelper sqlHelper;
    private JobSerializer jobSerializer;
    private FileStorage jobStorage;
    private final StringBuilder reusedStringBuilder = new StringBuilder();
    private final WhereQueryCache whereQueryCache;

    public SqliteJobQueue(Configuration configuration, long sessionId, JobSerializer serializer) {
        this.sessionId = sessionId;
        this.jobStorage = new FileStorage(configuration.getAppContext(), "jobs_" + configuration.getId());
        this.whereQueryCache = new WhereQueryCache(sessionId);
        this.dbOpenHelper = new DbOpenHelper(configuration.getAppContext(), configuration.isInTestMode() ? null : "db_" + configuration.getId());
        this.db = this.dbOpenHelper.getWritableDatabase();
        this.sqlHelper = new SqlHelper(this.db, "job_holder", DbOpenHelper.ID_COLUMN.columnName, 12, "job_holder_tags", 3, sessionId);
        this.jobSerializer = serializer;
        if (configuration.resetDelaysOnRestart()) {
            this.sqlHelper.resetDelayTimesTo(Long.MIN_VALUE);
        }
        this.reEnablePendingCancellations();
        this.cleanupFiles();
    }

    private void reEnablePendingCancellations() {
        this.db.execSQL(this.sqlHelper.RE_ENABLE_PENDING_CANCELLATIONS_QUERY);
    }

    private void cleanupFiles() {
        HashSet<String> jobIds = new HashSet<String>();
        try (Cursor cursor = this.db.rawQuery(this.sqlHelper.LOAD_ALL_IDS_QUERY, null);){
            while (cursor.moveToNext()) {
                jobIds.add(cursor.getString(0));
            }
        }
        this.jobStorage.truncateExcept(jobIds);
    }

    @VisibleForTesting
    public SQLiteDatabase getDb() {
        return this.db;
    }

    @Override
    public boolean insert(@NonNull JobHolder jobHolder) {
        this.persistJobToDisk(jobHolder);
        if (jobHolder.hasTags()) {
            return this.insertWithTags(jobHolder);
        }
        SQLiteStatement stmt = this.sqlHelper.getInsertStatement();
        stmt.clearBindings();
        this.bindValues(stmt, jobHolder);
        long insertId = stmt.executeInsert();
        jobHolder.setInsertionOrder(insertId);
        return insertId != -1L;
    }

    private void persistJobToDisk(@NonNull JobHolder jobHolder) {
        try {
            this.jobStorage.save(jobHolder.getId(), this.jobSerializer.serialize(jobHolder.getJob()));
        }
        catch (IOException e) {
            throw new RuntimeException("cannot save job to disk", e);
        }
    }

    @Override
    public void substitute(@NonNull JobHolder newJob, @NonNull JobHolder oldJob) {
        this.db.beginTransaction();
        try {
            this.remove(oldJob);
            this.insert(newJob);
            this.db.setTransactionSuccessful();
        }
        finally {
            this.db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean insertWithTags(JobHolder jobHolder) {
        SQLiteStatement stmt = this.sqlHelper.getInsertStatement();
        SQLiteStatement tagsStmt = this.sqlHelper.getInsertTagsStatement();
        this.db.beginTransaction();
        try {
            boolean insertResult;
            stmt.clearBindings();
            this.bindValues(stmt, jobHolder);
            boolean bl = insertResult = stmt.executeInsert() != -1L;
            if (!insertResult) {
                boolean bl2 = false;
                return bl2;
            }
            for (String tag : jobHolder.getTags()) {
                tagsStmt.clearBindings();
                this.bindTag(tagsStmt, jobHolder.getId(), tag);
                tagsStmt.executeInsert();
            }
            this.db.setTransactionSuccessful();
            boolean bl3 = true;
            return bl3;
        }
        catch (Throwable t) {
            JqLog.e(t, "error while inserting job with tags", new Object[0]);
            boolean bl = false;
            return bl;
        }
        finally {
            this.db.endTransaction();
        }
    }

    private void bindTag(SQLiteStatement stmt, String jobId, String tag) {
        stmt.bindString(DbOpenHelper.TAGS_JOB_ID_COLUMN.columnIndex + 1, jobId);
        stmt.bindString(DbOpenHelper.TAGS_NAME_COLUMN.columnIndex + 1, tag);
    }

    private void bindValues(SQLiteStatement stmt, JobHolder jobHolder) {
        if (jobHolder.getInsertionOrder() != null) {
            stmt.bindLong(DbOpenHelper.INSERTION_ORDER_COLUMN.columnIndex + 1, jobHolder.getInsertionOrder().longValue());
        }
        stmt.bindString(DbOpenHelper.ID_COLUMN.columnIndex + 1, jobHolder.getId());
        stmt.bindLong(DbOpenHelper.PRIORITY_COLUMN.columnIndex + 1, (long)jobHolder.getPriority());
        if (jobHolder.getGroupId() != null) {
            stmt.bindString(DbOpenHelper.GROUP_ID_COLUMN.columnIndex + 1, jobHolder.getGroupId());
        }
        stmt.bindLong(DbOpenHelper.RUN_COUNT_COLUMN.columnIndex + 1, (long)jobHolder.getRunCount());
        stmt.bindLong(DbOpenHelper.CREATED_NS_COLUMN.columnIndex + 1, jobHolder.getCreatedNs());
        stmt.bindLong(DbOpenHelper.DELAY_UNTIL_NS_COLUMN.columnIndex + 1, jobHolder.getDelayUntilNs());
        stmt.bindLong(DbOpenHelper.RUNNING_SESSION_ID_COLUMN.columnIndex + 1, jobHolder.getRunningSessionId());
        stmt.bindLong(DbOpenHelper.REQUIRED_NETWORK_TYPE_COLUMN.columnIndex + 1, (long)jobHolder.getRequiredNetworkType());
        stmt.bindLong(DbOpenHelper.DEADLINE_COLUMN.columnIndex + 1, jobHolder.getDeadlineNs());
        stmt.bindLong(DbOpenHelper.CANCEL_ON_DEADLINE_COLUMN.columnIndex + 1, jobHolder.shouldCancelOnDeadline() ? 1L : 0L);
        stmt.bindLong(DbOpenHelper.CANCELLED_COLUMN.columnIndex + 1, jobHolder.isCancelled() ? 1L : 0L);
    }

    @Override
    public boolean insertOrReplace(@NonNull JobHolder jobHolder) {
        if (jobHolder.getInsertionOrder() == null) {
            return this.insert(jobHolder);
        }
        this.persistJobToDisk(jobHolder);
        jobHolder.setRunningSessionId(Long.MIN_VALUE);
        SQLiteStatement stmt = this.sqlHelper.getInsertOrReplaceStatement();
        stmt.clearBindings();
        this.bindValues(stmt, jobHolder);
        boolean result = stmt.executeInsert() != -1L;
        JqLog.d("reinsert job result %s", result);
        return result;
    }

    @Override
    public void remove(@NonNull JobHolder jobHolder) {
        this.delete(jobHolder.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void delete(String id) {
        this.db.beginTransaction();
        try {
            SQLiteStatement stmt = this.sqlHelper.getDeleteStatement();
            stmt.clearBindings();
            stmt.bindString(1, id);
            stmt.execute();
            SQLiteStatement deleteTagsStmt = this.sqlHelper.getDeleteJobTagsStatement();
            deleteTagsStmt.bindString(1, id);
            deleteTagsStmt.execute();
            this.db.setTransactionSuccessful();
            this.jobStorage.delete(id);
        }
        finally {
            this.db.endTransaction();
        }
    }

    @Override
    public int count() {
        SQLiteStatement stmt = this.sqlHelper.getCountStatement();
        stmt.clearBindings();
        stmt.bindLong(1, this.sessionId);
        return (int)stmt.simpleQueryForLong();
    }

    @Override
    public int countReadyJobs(@NonNull Constraint constraint) {
        Where where = this.createWhere(constraint);
        long result = where.countReady(this.db, this.reusedStringBuilder).simpleQueryForLong();
        return (int)result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JobHolder findJobById(@NonNull String id) {
        try (Cursor cursor = this.db.rawQuery(this.sqlHelper.FIND_BY_ID_QUERY, new String[]{id});){
            if (!cursor.moveToFirst()) {
                JobHolder jobHolder = null;
                return jobHolder;
            }
            JobHolder jobHolder = this.createJobHolderFromCursor(cursor);
            return jobHolder;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public Set<JobHolder> findJobs(@NonNull Constraint constraint) {
        Where where = this.createWhere(constraint);
        String selectQuery = where.findJobs(this.sqlHelper);
        HashSet<JobHolder> jobs = new HashSet<JobHolder>();
        try (Cursor cursor = this.db.rawQuery(selectQuery, where.args);){
            while (cursor.moveToNext()) {
                jobs.add(this.createJobHolderFromCursor(cursor));
            }
        }
        return jobs;
    }

    @Override
    public void onJobCancelled(JobHolder jobHolder) {
        SQLiteStatement stmt = this.sqlHelper.getMarkAsCancelledStatement();
        stmt.clearBindings();
        stmt.bindString(1, jobHolder.getId());
        stmt.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JobHolder nextJobAndIncRunCount(@NonNull Constraint constraint) {
        Where where = this.createWhere(constraint);
        String selectQuery = where.nextJob(this.sqlHelper);
        while (true) {
            Cursor cursor = this.db.rawQuery(selectQuery, where.args);
            try {
                if (!cursor.moveToNext()) {
                    JobHolder jobHolder = null;
                    return jobHolder;
                }
                JobHolder holder = this.createJobHolderFromCursor(cursor);
                this.setSessionIdOnJob(holder);
                JobHolder jobHolder = holder;
                return jobHolder;
            }
            catch (InvalidJobException e) {
                String jobId = cursor.getString(DbOpenHelper.ID_COLUMN.columnIndex);
                if (jobId == null) {
                    JqLog.e("cannot find job id on a retrieved job", new Object[0]);
                    continue;
                }
                this.delete(jobId);
                continue;
            }
            finally {
                cursor.close();
                continue;
            }
            break;
        }
    }

    private Where createWhere(Constraint constraint) {
        return this.whereQueryCache.build(constraint, this.reusedStringBuilder);
    }

    @Override
    public Long getNextJobDelayUntilNs(@NonNull Constraint constraint) {
        Where where = this.createWhere(constraint);
        try {
            long result = where.nextJobDelayUntil(this.db, this.sqlHelper).simpleQueryForLong();
            return result == Long.MAX_VALUE ? null : Long.valueOf(result);
        }
        catch (SQLiteDoneException empty) {
            return null;
        }
    }

    @Override
    public void clear() {
        this.sqlHelper.truncate();
        this.cleanupFiles();
    }

    private void setSessionIdOnJob(JobHolder jobHolder) {
        SQLiteStatement stmt = this.sqlHelper.getOnJobFetchedForRunningStatement();
        jobHolder.setRunCount(jobHolder.getRunCount() + 1);
        jobHolder.setRunningSessionId(this.sessionId);
        stmt.clearBindings();
        stmt.bindLong(1, (long)jobHolder.getRunCount());
        stmt.bindLong(2, this.sessionId);
        stmt.bindString(3, jobHolder.getId());
        stmt.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String logJobs() {
        StringBuilder sb = new StringBuilder();
        String select = this.sqlHelper.createSelect(null, 100, new SqlHelper.Order(DbOpenHelper.PRIORITY_COLUMN, SqlHelper.Order.Type.DESC), new SqlHelper.Order(DbOpenHelper.CREATED_NS_COLUMN, SqlHelper.Order.Type.ASC), new SqlHelper.Order(DbOpenHelper.INSERTION_ORDER_COLUMN, SqlHelper.Order.Type.ASC));
        try (Cursor cursor = this.db.rawQuery(select, new String[0]);){
            while (cursor.moveToNext()) {
                String id = cursor.getString(DbOpenHelper.ID_COLUMN.columnIndex);
                sb.append(cursor.getLong(DbOpenHelper.INSERTION_ORDER_COLUMN.columnIndex)).append(" ").append(id).append(" id:").append(cursor.getString(DbOpenHelper.GROUP_ID_COLUMN.columnIndex)).append(" deadline:").append(cursor.getLong(DbOpenHelper.DEADLINE_COLUMN.columnIndex)).append(" cancelled:").append(cursor.getInt(DbOpenHelper.CANCELLED_COLUMN.columnIndex) == 1).append(" delay until:").append(cursor.getLong(DbOpenHelper.DELAY_UNTIL_NS_COLUMN.columnIndex)).append(" sessionId:").append(cursor.getLong(DbOpenHelper.RUNNING_SESSION_ID_COLUMN.columnIndex)).append(" reqNetworkType:").append(cursor.getLong(DbOpenHelper.REQUIRED_NETWORK_TYPE_COLUMN.columnIndex));
                try (Cursor tags = this.db.rawQuery("SELECT " + DbOpenHelper.TAGS_NAME_COLUMN.columnName + " FROM " + "job_holder_tags" + " WHERE " + DbOpenHelper.TAGS_JOB_ID_COLUMN.columnName + " = ?", new String[]{id});){
                    while (tags.moveToNext()) {
                        sb.append(", ").append(tags.getString(0));
                    }
                }
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    private JobHolder createJobHolderFromCursor(Cursor cursor) throws InvalidJobException {
        Job job;
        String jobId = cursor.getString(DbOpenHelper.ID_COLUMN.columnIndex);
        try {
            job = this.safeDeserialize(this.jobStorage.load(jobId));
        }
        catch (IOException e) {
            throw new InvalidJobException("cannot load job from disk", e);
        }
        if (job == null) {
            throw new InvalidJobException("null job");
        }
        Set<String> tags = this.loadTags(jobId);
        JobHolder holder = new JobHolder.Builder().insertionOrder(cursor.getLong(DbOpenHelper.INSERTION_ORDER_COLUMN.columnIndex)).priority(cursor.getInt(DbOpenHelper.PRIORITY_COLUMN.columnIndex)).groupId(cursor.getString(DbOpenHelper.GROUP_ID_COLUMN.columnIndex)).runCount(cursor.getInt(DbOpenHelper.RUN_COUNT_COLUMN.columnIndex)).job(job).id(jobId).tags(tags).persistent(true).deadline(cursor.getLong(DbOpenHelper.DEADLINE_COLUMN.columnIndex), cursor.getInt(DbOpenHelper.CANCEL_ON_DEADLINE_COLUMN.columnIndex) == 1).createdNs(cursor.getLong(DbOpenHelper.CREATED_NS_COLUMN.columnIndex)).delayUntilNs(cursor.getLong(DbOpenHelper.DELAY_UNTIL_NS_COLUMN.columnIndex)).runningSessionId(cursor.getLong(DbOpenHelper.RUNNING_SESSION_ID_COLUMN.columnIndex)).requiredNetworkType(cursor.getInt(DbOpenHelper.REQUIRED_NETWORK_TYPE_COLUMN.columnIndex)).build();
        return holder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> loadTags(String jobId) {
        try (Cursor cursor = this.db.rawQuery(this.sqlHelper.LOAD_TAGS_QUERY, new String[]{jobId});){
            if (cursor.getCount() == 0) {
                Set set = Collections.EMPTY_SET;
                return set;
            }
            HashSet<String> tags = new HashSet<String>();
            while (cursor.moveToNext()) {
                tags.add(cursor.getString(0));
            }
            HashSet<String> hashSet = tags;
            return hashSet;
        }
    }

    private Job safeDeserialize(byte[] bytes) {
        try {
            return this.jobSerializer.deserialize(bytes);
        }
        catch (Throwable t) {
            JqLog.e(t, "error while deserializing job", new Object[0]);
            return null;
        }
    }

    public static interface JobSerializer {
        public byte[] serialize(Object var1) throws IOException;

        public <T extends Job> T deserialize(byte[] var1) throws IOException, ClassNotFoundException;
    }

    public static class JavaSerializer
    implements JobSerializer {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public byte[] serialize(Object object) throws IOException {
            if (object == null) {
                return null;
            }
            try (ByteArrayOutputStream bos = null;){
                bos = new ByteArrayOutputStream();
                ObjectOutputStream out = new ObjectOutputStream(bos);
                out.writeObject(object);
                byte[] byArray = bos.toByteArray();
                return byArray;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T extends Job> T deserialize(byte[] bytes) throws IOException, ClassNotFoundException {
            if (bytes == null || bytes.length == 0) {
                return null;
            }
            try (ObjectInputStream in = null;){
                in = new ObjectInputStream(new ByteArrayInputStream(bytes));
                Job job = (Job)in.readObject();
                return (T)job;
            }
        }
    }

    static class InvalidJobException
    extends Exception {
        InvalidJobException(String detailMessage) {
            super(detailMessage);
        }

        InvalidJobException(String detailMessage, Throwable throwable) {
            super(detailMessage, throwable);
        }
    }
}

