/*
 * Decompiled with CFR 0.152.
 */
package com.birbit.android.jobqueue;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.birbit.android.jobqueue.CancelResult;
import com.birbit.android.jobqueue.Job;
import com.birbit.android.jobqueue.callback.JobManagerCallback;
import com.birbit.android.jobqueue.log.JqLog;
import com.birbit.android.jobqueue.messaging.Message;
import com.birbit.android.jobqueue.messaging.MessageFactory;
import com.birbit.android.jobqueue.messaging.MessageQueueConsumer;
import com.birbit.android.jobqueue.messaging.SafeMessageQueue;
import com.birbit.android.jobqueue.messaging.Type;
import com.birbit.android.jobqueue.messaging.message.CallbackMessage;
import com.birbit.android.jobqueue.messaging.message.CancelResultMessage;
import com.birbit.android.jobqueue.messaging.message.CommandMessage;
import com.birbit.android.jobqueue.messaging.message.PublicQueryMessage;
import com.birbit.android.jobqueue.timer.Timer;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class CallbackManager {
    final SafeMessageQueue messageQueue;
    private final CopyOnWriteArrayList<JobManagerCallback> callbacks;
    private final MessageFactory factory;
    private final AtomicInteger callbacksSize = new AtomicInteger(0);
    private final Timer timer;
    private final AtomicBoolean started = new AtomicBoolean(false);

    public CallbackManager(MessageFactory factory, Timer timer) {
        this.timer = timer;
        this.messageQueue = new SafeMessageQueue(timer, factory, "jq_callback");
        this.callbacks = new CopyOnWriteArrayList();
        this.factory = factory;
    }

    void addCallback(@NonNull JobManagerCallback callback) {
        this.callbacks.add(callback);
        this.callbacksSize.incrementAndGet();
        this.startIfNeeded();
    }

    private void startIfNeeded() {
        if (!this.started.getAndSet(true)) {
            this.start();
        }
    }

    @VisibleForTesting
    public boolean waitUntilAllMessagesAreConsumed(int seconds) {
        final CountDownLatch latch = new CountDownLatch(1);
        CommandMessage poke = this.factory.obtain(CommandMessage.class);
        poke.set(3);
        poke.setRunnable(new Runnable(){

            @Override
            public void run() {
                latch.countDown();
            }
        });
        this.messageQueue.post(poke);
        try {
            return latch.await(seconds, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    boolean removeCallback(@NonNull JobManagerCallback callback) {
        boolean removed = this.callbacks.remove(callback);
        if (removed) {
            this.callbacksSize.decrementAndGet();
        }
        return removed;
    }

    private void start() {
        Thread callbackThread = new Thread(new Runnable(){

            @Override
            public void run() {
                CallbackManager.this.messageQueue.consume(new MessageQueueConsumer(){
                    long lastDelivery = Long.MIN_VALUE;

                    @Override
                    public void onStart() {
                    }

                    @Override
                    public void handleMessage(Message message) {
                        if (message.type == Type.CALLBACK) {
                            CallbackMessage cm = (CallbackMessage)message;
                            CallbackManager.this.deliverMessage(cm);
                            this.lastDelivery = CallbackManager.this.timer.nanoTime();
                        } else if (message.type == Type.CANCEL_RESULT_CALLBACK) {
                            CallbackManager.this.deliverCancelResult((CancelResultMessage)message);
                            this.lastDelivery = CallbackManager.this.timer.nanoTime();
                        } else if (message.type == Type.COMMAND) {
                            CommandMessage command = (CommandMessage)message;
                            int what = command.getWhat();
                            if (what == 1) {
                                CallbackManager.this.messageQueue.stop();
                                CallbackManager.this.started.set(false);
                            } else if (what == 3) {
                                command.getRunnable().run();
                            }
                        } else if (message.type == Type.PUBLIC_QUERY) {
                            ((PublicQueryMessage)message).getCallback().onResult(0);
                        }
                    }

                    @Override
                    public void onIdle() {
                    }
                });
            }
        }, "job-manager-callbacks");
        try {
            callbackThread.start();
        }
        catch (InternalError error) {
            JqLog.e(error, "Cannot start a thread. Looks like app is shutting down.See issue #294 for details.", new Object[0]);
        }
    }

    private void deliverCancelResult(@NonNull CancelResultMessage message) {
        message.getCallback().onCancelled(message.getResult());
        this.startIfNeeded();
    }

    private void deliverMessage(@NonNull CallbackMessage cm) {
        switch (cm.getWhat()) {
            case 1: {
                this.notifyOnAddedListeners(cm.getJob());
                break;
            }
            case 5: {
                this.notifyAfterRunListeners(cm.getJob(), cm.getResultCode());
                break;
            }
            case 3: {
                this.notifyOnCancelListeners(cm.getJob(), cm.isByUserRequest(), cm.getThrowable());
                break;
            }
            case 4: {
                this.notifyOnDoneListeners(cm.getJob());
                break;
            }
            case 2: {
                this.notifyOnRunListeners(cm.getJob(), cm.getResultCode());
            }
        }
    }

    private void notifyOnCancelListeners(@NonNull Job job, boolean byCancelRequest, @Nullable Throwable throwable) {
        for (JobManagerCallback callback : this.callbacks) {
            callback.onJobCancelled(job, byCancelRequest, throwable);
        }
    }

    private void notifyOnRunListeners(@NonNull Job job, int resultCode) {
        for (JobManagerCallback callback : this.callbacks) {
            callback.onJobRun(job, resultCode);
        }
    }

    private void notifyAfterRunListeners(@NonNull Job job, int resultCode) {
        for (JobManagerCallback callback : this.callbacks) {
            callback.onAfterJobRun(job, resultCode);
        }
    }

    private void notifyOnDoneListeners(@NonNull Job job) {
        for (JobManagerCallback callback : this.callbacks) {
            callback.onDone(job);
        }
    }

    private void notifyOnAddedListeners(@NonNull Job job) {
        for (JobManagerCallback callback : this.callbacks) {
            callback.onJobAdded(job);
        }
    }

    public void notifyOnRun(@NonNull Job job, int result) {
        if (!this.hasAnyCallbacks()) {
            return;
        }
        CallbackMessage callback = this.factory.obtain(CallbackMessage.class);
        callback.set(job, 2, result);
        this.messageQueue.post(callback);
    }

    private boolean hasAnyCallbacks() {
        return this.callbacksSize.get() > 0;
    }

    public void notifyAfterRun(@NonNull Job job, int result) {
        if (!this.hasAnyCallbacks()) {
            return;
        }
        CallbackMessage callback = this.factory.obtain(CallbackMessage.class);
        callback.set(job, 5, result);
        this.messageQueue.post(callback);
    }

    public void notifyOnCancel(@NonNull Job job, boolean byCancelRequest, @Nullable Throwable throwable) {
        if (!this.hasAnyCallbacks()) {
            return;
        }
        CallbackMessage callback = this.factory.obtain(CallbackMessage.class);
        callback.set(job, 3, byCancelRequest, throwable);
        this.messageQueue.post(callback);
    }

    public void notifyOnAdded(@NonNull Job job) {
        if (!this.hasAnyCallbacks()) {
            return;
        }
        CallbackMessage callback = this.factory.obtain(CallbackMessage.class);
        callback.set(job, 1);
        this.messageQueue.post(callback);
    }

    public void notifyOnDone(@NonNull Job job) {
        if (!this.hasAnyCallbacks()) {
            return;
        }
        CallbackMessage callback = this.factory.obtain(CallbackMessage.class);
        callback.set(job, 4);
        this.messageQueue.post(callback);
    }

    public void notifyCancelResult(@NonNull CancelResult result, @NonNull CancelResult.AsyncCancelCallback callback) {
        CancelResultMessage message = this.factory.obtain(CancelResultMessage.class);
        message.set(callback, result);
        this.messageQueue.post(message);
        this.startIfNeeded();
    }

    public void destroy() {
        if (!this.started.get()) {
            return;
        }
        CommandMessage message = this.factory.obtain(CommandMessage.class);
        message.set(1);
        this.messageQueue.post(message);
    }
}

