/*
 * Decompiled with CFR 0.152.
 */
package com.birbit.android.jobqueue;

import android.content.Context;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.birbit.android.jobqueue.scheduling.Scheduler;
import com.birbit.android.jobqueue.scheduling.SchedulerConstraint;
import com.birbit.android.jobqueue.timer.Timer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class BatchingScheduler
extends Scheduler {
    public static final long DEFAULT_BATCHING_PERIOD_IN_MS = TimeUnit.SECONDS.toMillis(900L);
    @VisibleForTesting
    final long batchingDurationInMs;
    @VisibleForTesting
    final long batchingDurationInNs;
    private final Scheduler delegate;
    private final List<ConstraintWrapper> constraints = new ArrayList<ConstraintWrapper>();
    private final Timer timer;

    public BatchingScheduler(Scheduler delegate, Timer timer) {
        this(delegate, timer, DEFAULT_BATCHING_PERIOD_IN_MS);
    }

    public BatchingScheduler(Scheduler delegate, Timer timer, long batchingDurationInMs) {
        this.delegate = delegate;
        this.timer = timer;
        this.batchingDurationInMs = batchingDurationInMs;
        this.batchingDurationInNs = TimeUnit.MILLISECONDS.toNanos(batchingDurationInMs);
    }

    @Override
    public void init(Context context, Scheduler.Callback callback) {
        super.init(context, callback);
        this.delegate.init(context, new Scheduler.Callback(){

            @Override
            public boolean start(SchedulerConstraint constraint) {
                BatchingScheduler.this.removeFromConstraints(constraint);
                return BatchingScheduler.this.start(constraint);
            }

            @Override
            public boolean stop(SchedulerConstraint constraint) {
                return BatchingScheduler.this.stop(constraint);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromConstraints(SchedulerConstraint constraint) {
        List<ConstraintWrapper> list = this.constraints;
        synchronized (list) {
            for (int i = this.constraints.size() - 1; i >= 0; --i) {
                ConstraintWrapper existing = this.constraints.get(i);
                if (!existing.constraint.getUuid().equals(constraint.getUuid())) continue;
                this.constraints.remove(i);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addToConstraints(SchedulerConstraint constraint) {
        long now = this.timer.nanoTime();
        long expectedRunTime = TimeUnit.MILLISECONDS.toNanos(constraint.getDelayInMs()) + now;
        Long expectedDeadline = constraint.getOverrideDeadlineInMs() == null ? null : Long.valueOf(TimeUnit.MILLISECONDS.toNanos(constraint.getOverrideDeadlineInMs()) + now);
        List<ConstraintWrapper> list = this.constraints;
        synchronized (list) {
            for (ConstraintWrapper existing : this.constraints) {
                if (!this.covers(existing, constraint, expectedRunTime, expectedDeadline)) continue;
                return false;
            }
            long group = constraint.getDelayInMs() / this.batchingDurationInMs;
            long newDelay = (group + 1L) * this.batchingDurationInMs;
            constraint.setDelayInMs(newDelay);
            Long deadline = null;
            if (constraint.getOverrideDeadlineInMs() != null) {
                group = constraint.getOverrideDeadlineInMs() / this.batchingDurationInMs;
                deadline = (group + 1L) * this.batchingDurationInMs;
                constraint.setOverrideDeadlineInMs(deadline);
            }
            this.constraints.add(new ConstraintWrapper(now + TimeUnit.MILLISECONDS.toNanos(newDelay), deadline == null ? null : Long.valueOf(now + TimeUnit.MILLISECONDS.toNanos(deadline)), constraint));
            return true;
        }
    }

    private boolean covers(ConstraintWrapper existing, SchedulerConstraint constraint, long expectedRunTime, Long expectedDeadline) {
        long timeDiff;
        if (existing.constraint.getNetworkStatus() != constraint.getNetworkStatus()) {
            return false;
        }
        if (expectedDeadline != null) {
            if (existing.deadlineNs == null) {
                return false;
            }
            timeDiff = existing.deadlineNs - expectedDeadline;
            if (timeDiff < 1L || timeDiff > this.batchingDurationInNs) {
                return false;
            }
        } else if (existing.deadlineNs != null) {
            return false;
        }
        return (timeDiff = existing.delayUntilNs - expectedRunTime) > 0L && timeDiff <= this.batchingDurationInNs;
    }

    @Override
    public void request(SchedulerConstraint constraint) {
        if (this.addToConstraints(constraint)) {
            this.delegate.request(constraint);
        }
    }

    @Override
    public void onFinished(SchedulerConstraint constraint, boolean reschedule) {
        this.removeFromConstraints(constraint);
        this.delegate.onFinished(constraint, false);
        if (reschedule) {
            this.request(constraint);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelAll() {
        List<ConstraintWrapper> list = this.constraints;
        synchronized (list) {
            this.constraints.clear();
        }
        this.delegate.cancelAll();
    }

    private static class ConstraintWrapper {
        final long delayUntilNs;
        @Nullable
        final Long deadlineNs;
        final SchedulerConstraint constraint;

        public ConstraintWrapper(long delayUntilNs, @Nullable Long deadlineNs, SchedulerConstraint constraint) {
            this.delayUntilNs = delayUntilNs;
            this.deadlineNs = deadlineNs;
            this.constraint = constraint;
        }
    }
}

