/*
 * Decompiled with CFR 0.152.
 */
package com.birbit.android.jobqueue.persistentQueue.sqlite;

import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteStatement;
import com.birbit.android.jobqueue.persistentQueue.sqlite.DbOpenHelper;
import com.birbit.android.jobqueue.persistentQueue.sqlite.SqlHelper;

public class Where {
    public final long cacheKey;
    public final String query;
    public final String[] args;
    private SQLiteStatement countReadyStmt;
    private String findJobsQuery;
    private SQLiteStatement nextJobDelayUntilStmt;
    private String nextJobQuery;
    static final String NEVER = Long.toString(Long.MIN_VALUE);
    static final String FOREVER = Long.toString(Long.MAX_VALUE);

    public Where(long cacheKey, String query, String[] args) {
        this.cacheKey = cacheKey;
        this.query = query;
        this.args = args;
    }

    public SQLiteStatement countReady(SQLiteDatabase database, StringBuilder stringBuilder) {
        if (this.countReadyStmt == null) {
            stringBuilder.setLength(0);
            stringBuilder.append("SELECT SUM(case WHEN ").append(DbOpenHelper.GROUP_ID_COLUMN.columnName).append(" is null then group_cnt else 1 end) from (").append("SELECT count(*) group_cnt, ").append(DbOpenHelper.GROUP_ID_COLUMN.columnName).append(" FROM ").append("job_holder").append(" WHERE ").append(this.query).append(" GROUP BY ").append(DbOpenHelper.GROUP_ID_COLUMN.columnName).append(")");
            this.countReadyStmt = database.compileStatement(stringBuilder.toString());
        } else {
            this.countReadyStmt.clearBindings();
        }
        for (int i = 1; i <= this.args.length; ++i) {
            this.countReadyStmt.bindString(i, this.args[i - 1]);
        }
        return this.countReadyStmt;
    }

    public SQLiteStatement nextJobDelayUntil(SQLiteDatabase database, SqlHelper sqlHelper) {
        if (this.nextJobDelayUntilStmt == null) {
            String deadlineQuery = sqlHelper.createSelectOneField(DbOpenHelper.DEADLINE_COLUMN.columnName, this.query, null, new SqlHelper.Order[0]);
            String delayQuery = sqlHelper.createSelectOneField(DbOpenHelper.DELAY_UNTIL_NS_COLUMN.columnName, this.query, null, new SqlHelper.Order[0]);
            StringBuilder sb = sqlHelper.reusedStringBuilder;
            sb.setLength(0);
            sb.append("SELECT * FROM (").append(deadlineQuery).append(" ORDER BY 1 ASC LIMIT 1").append(") UNION SELECT * FROM (").append(delayQuery).append(" ORDER BY 1 ASC LIMIT 1").append(") ORDER BY 1 ASC LIMIT 1");
            String selectQuery = sb.toString();
            this.nextJobDelayUntilStmt = database.compileStatement(selectQuery);
        } else {
            this.nextJobDelayUntilStmt.clearBindings();
        }
        for (int i = 1; i <= this.args.length; ++i) {
            this.nextJobDelayUntilStmt.bindString(i, this.args[i - 1]);
            this.nextJobDelayUntilStmt.bindString(i + this.args.length, this.args[i - 1]);
        }
        this.nextJobDelayUntilStmt.bindString(1, FOREVER);
        this.nextJobDelayUntilStmt.bindString(1 + this.args.length, NEVER);
        return this.nextJobDelayUntilStmt;
    }

    public String nextJob(SqlHelper sqlHelper) {
        if (this.nextJobQuery == null) {
            this.nextJobQuery = sqlHelper.createSelect(this.query, 1, new SqlHelper.Order(DbOpenHelper.PRIORITY_COLUMN, SqlHelper.Order.Type.DESC), new SqlHelper.Order(DbOpenHelper.CREATED_NS_COLUMN, SqlHelper.Order.Type.ASC), new SqlHelper.Order(DbOpenHelper.INSERTION_ORDER_COLUMN, SqlHelper.Order.Type.ASC));
        }
        return this.nextJobQuery;
    }

    public String findJobs(SqlHelper sqlHelper) {
        if (this.findJobsQuery == null) {
            this.findJobsQuery = sqlHelper.createSelect(this.query, null, new SqlHelper.Order[0]);
        }
        return this.findJobsQuery;
    }

    public void destroy() {
        if (this.countReadyStmt != null) {
            this.countReadyStmt.close();
            this.countReadyStmt = null;
        }
        if (this.nextJobDelayUntilStmt != null) {
            this.nextJobDelayUntilStmt.close();
            this.nextJobDelayUntilStmt = null;
        }
    }
}

