/*
 * Decompiled with CFR 0.152.
 */
package com.birbit.android.jobqueue.persistentQueue.sqlite;

import android.content.Context;
import android.support.annotation.Nullable;
import com.birbit.android.jobqueue.log.JqLog;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.Okio;
import okio.Sink;
import okio.Source;

class FileStorage {
    private static final String EXT = ".jobs";
    private final File folder;

    FileStorage(Context appContext, String id) {
        this.folder = new File(appContext.getDir("com_birbit_jobqueue_jobs", 0), "files_" + id);
        this.folder.mkdirs();
    }

    void delete(String id) {
        File file = this.toFile(id);
        if (file.exists()) {
            file.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    byte[] load(String id) throws IOException {
        File file = this.toFile(id);
        if (file.exists() && file.canRead()) {
            BufferedSource source = Okio.buffer((Source)Okio.source((File)file));
            try {
                byte[] byArray = source.readByteArray();
                return byArray;
            }
            finally {
                FileStorage.closeQuitely((Closeable)source);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void save(String id, byte[] data) throws IOException {
        File file = this.toFile(id);
        BufferedSink sink = Okio.buffer((Sink)Okio.sink((File)file));
        try {
            sink.write(data).flush();
        }
        finally {
            FileStorage.closeQuitely((Closeable)sink);
        }
    }

    private static String filename(String id) {
        return id + EXT;
    }

    private File toFile(String id) {
        return new File(this.folder, FileStorage.filename(id));
    }

    @Nullable
    private static String filenameToId(String filename) {
        if (filename.length() < EXT.length() + 1) {
            return null;
        }
        return filename.substring(0, filename.length() - EXT.length());
    }

    void truncateExcept(Set<String> ids) {
        for (String filename : this.folder.list()) {
            File file;
            String id;
            if (!filename.endsWith(EXT) || ids.contains(id = FileStorage.filenameToId(filename)) || (file = new File(this.folder, filename)).delete()) continue;
            JqLog.d("cannot delete unused job toFile " + file.getAbsolutePath(), new Object[0]);
        }
    }

    private static void closeQuitely(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

