/*
 * Decompiled with CFR 0.152.
 */
package com.birbit.android.jobqueue.messaging;

import com.birbit.android.jobqueue.log.JqLog;
import com.birbit.android.jobqueue.messaging.Message;
import com.birbit.android.jobqueue.messaging.MessageFactory;
import com.birbit.android.jobqueue.messaging.MessagePredicate;
import com.birbit.android.jobqueue.messaging.MessageQueue;

class DelayedMessageBag {
    Message queue = null;
    final MessageFactory factory;

    DelayedMessageBag(MessageFactory factory) {
        this.factory = factory;
    }

    Long flushReadyMessages(long now, MessageQueue addInto) {
        JqLog.d("flushing messages at time %s", now);
        while (this.queue != null && this.queue.readyNs <= now) {
            Message msg = this.queue;
            this.queue = msg.next;
            msg.next = null;
            addInto.post(msg);
        }
        if (this.queue != null) {
            JqLog.d("returning next ready at %d ns", this.queue.readyNs - now);
            return this.queue.readyNs;
        }
        return null;
    }

    void add(Message message, long readyNs) {
        JqLog.d("add delayed message %s at time %s", message, readyNs);
        message.readyNs = readyNs;
        if (this.queue == null) {
            this.queue = message;
            return;
        }
        Message prev = null;
        Message curr = this.queue;
        while (curr != null && curr.readyNs <= readyNs) {
            prev = curr;
            curr = curr.next;
        }
        if (prev == null) {
            message.next = this.queue;
            this.queue = message;
        } else {
            prev.next = message;
            message.next = curr;
        }
    }

    public void clear() {
        while (this.queue != null) {
            Message curr = this.queue;
            this.queue = curr.next;
            this.factory.release(curr);
        }
        this.queue = null;
    }

    public void removeMessages(MessagePredicate predicate) {
        Message prev = null;
        Message curr = this.queue;
        while (curr != null) {
            boolean remove = predicate.onMessage(curr);
            Message next = curr.next;
            if (remove) {
                if (prev == null) {
                    this.queue = curr.next;
                } else {
                    prev.next = curr.next;
                }
                this.factory.release(curr);
            } else {
                prev = curr;
            }
            curr = next;
        }
    }
}

