/*
 * Decompiled with CFR 0.152.
 */
package com.birbit.android.jobqueue;

import com.birbit.android.jobqueue.CancelResult;
import com.birbit.android.jobqueue.Constraint;
import com.birbit.android.jobqueue.ConsumerManager;
import com.birbit.android.jobqueue.Job;
import com.birbit.android.jobqueue.JobHolder;
import com.birbit.android.jobqueue.JobManagerThread;
import com.birbit.android.jobqueue.TagConstraint;
import com.birbit.android.jobqueue.log.JqLog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;

class CancelHandler {
    private Set<String> running;
    private final TagConstraint tagConstraint;
    private final String[] tags;
    private final Collection<JobHolder> cancelled;
    private final Collection<JobHolder> failedToCancel;
    private final CancelResult.AsyncCancelCallback callback;

    CancelHandler(TagConstraint constraint, String[] tags, CancelResult.AsyncCancelCallback callback) {
        this.tagConstraint = constraint;
        this.tags = tags;
        this.cancelled = new ArrayList<JobHolder>();
        this.failedToCancel = new ArrayList<JobHolder>();
        this.callback = callback;
    }

    void query(JobManagerThread jobManagerThread, ConsumerManager consumerManager) {
        this.running = consumerManager.markJobsCancelled(this.tagConstraint, this.tags);
        Constraint queryConstraint = jobManagerThread.queryConstraint;
        queryConstraint.clear();
        queryConstraint.setNowInNs(jobManagerThread.timer.nanoTime());
        queryConstraint.setTagConstraint(this.tagConstraint);
        queryConstraint.setExcludeJobIds(this.running);
        queryConstraint.setTags(this.tags);
        queryConstraint.setExcludeRunning(true);
        queryConstraint.setMaxNetworkType(2);
        Set<JobHolder> nonPersistentInQueue = jobManagerThread.nonPersistentJobQueue.findJobs(queryConstraint);
        Set<JobHolder> persistentInQueue = jobManagerThread.persistentJobQueue.findJobs(queryConstraint);
        for (JobHolder nonPersistent : nonPersistentInQueue) {
            nonPersistent.markAsCancelled();
            this.cancelled.add(nonPersistent);
            jobManagerThread.nonPersistentJobQueue.onJobCancelled(nonPersistent);
        }
        for (JobHolder persistent : persistentInQueue) {
            persistent.markAsCancelled();
            this.cancelled.add(persistent);
            jobManagerThread.persistentJobQueue.onJobCancelled(persistent);
        }
    }

    void commit(JobManagerThread jobManagerThread) {
        for (JobHolder jobHolder : this.cancelled) {
            try {
                jobHolder.onCancel(3);
            }
            catch (Throwable t) {
                JqLog.e(t, "job's on cancel has thrown an exception. Ignoring...", new Object[0]);
            }
            if (!jobHolder.getJob().isPersistent()) continue;
            jobManagerThread.persistentJobQueue.remove(jobHolder);
        }
        if (this.callback != null) {
            ArrayList<Job> cancelledJobs = new ArrayList<Job>(this.cancelled.size());
            ArrayList<Job> failedToCancelJobs = new ArrayList<Job>(this.failedToCancel.size());
            for (JobHolder holder : this.cancelled) {
                cancelledJobs.add(holder.getJob());
            }
            for (JobHolder holder : this.failedToCancel) {
                failedToCancelJobs.add(holder.getJob());
            }
            CancelResult result = new CancelResult(cancelledJobs, failedToCancelJobs);
            jobManagerThread.callbackManager.notifyCancelResult(result, this.callback);
        }
        for (JobHolder jobHolder : this.cancelled) {
            jobManagerThread.callbackManager.notifyOnCancel(jobHolder.getJob(), true, jobHolder.getThrowable());
        }
    }

    void onJobRun(JobHolder holder, int resultCode) {
        boolean exists = this.running.remove(holder.getId());
        if (exists) {
            if (resultCode == 3) {
                this.cancelled.add(holder);
            } else {
                this.failedToCancel.add(holder);
            }
        }
    }

    boolean isDone() {
        return this.running.isEmpty();
    }
}

