/*
 * Decompiled with CFR 0.152.
 */
package com.bingzer.android.eula;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.FragmentActivity;
import android.text.Html;
import android.text.method.ScrollingMovementMethod;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.TextView;
import com.bingzer.android.Res;
import com.bingzer.android.eula.OnEulaAgreedTo;
import com.bingzer.android.eula.R;

public class EulaFragment
extends DialogFragment {
    static String TAG = "EulaFragment";
    private TextView textView;
    private Button agreeButton;
    private Button disagreeButton;

    @TargetApi(value=11)
    public void onAttach(Activity activity) {
        super.onAttach(activity);
        if (Build.VERSION.SDK_INT >= 11) {
            this.setStyle(0, 16973934);
        } else {
            this.setStyle(0, 16973838);
        }
        this.setRetainInstance(true);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View root = inflater.inflate(R.layout.br_fragment_eula, container, false);
        if (root != null) {
            this.textView = this.initializeTextView(root);
            this.agreeButton = this.initializeAgreeButton(root);
            this.disagreeButton = this.initializeDisagreeButton(root);
            this.initializeDialog();
        }
        return root;
    }

    public void onResume() {
        super.onResume();
        this.textView.postDelayed(new Runnable(){

            @Override
            public void run() {
                String eulaRaw = Res.readRaw((int)EulaFragment.this.getRawEulaResourceId()).toString();
                String eulaText = eulaRaw.replaceAll("%APP_NAME%", Res.getApplicationName()).replaceAll("%APP_VERSION%", Res.getVersionName());
                EulaFragment.this.textView.setText((CharSequence)Html.fromHtml((String)eulaRaw));
                EulaFragment.this.agreeButton.setEnabled(true);
            }
        }, 1000L);
    }

    protected String getDialogTitle() {
        return "EULA";
    }

    protected String getAgreedText() {
        return "Agreed";
    }

    protected String getDisagreeText() {
        return "Disagree";
    }

    protected int getRawEulaResourceId() {
        return R.raw.eula_html;
    }

    private Button initializeAgreeButton(View root) {
        this.agreeButton = (Button)root.findViewById(R.id.br_button1);
        this.agreeButton.setText((CharSequence)this.getAgreedText());
        this.agreeButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Res.setPreference((String)EulaFragment.getPreferenceName(), (boolean)true);
                EulaFragment.this.dismiss();
                if (EulaFragment.this.getActivity() instanceof OnEulaAgreedTo) {
                    ((OnEulaAgreedTo)EulaFragment.this.getActivity()).onEulaAgreed();
                }
            }
        });
        return this.agreeButton;
    }

    private Button initializeDisagreeButton(View root) {
        this.disagreeButton = (Button)root.findViewById(R.id.br_button);
        this.disagreeButton.setText((CharSequence)this.getDisagreeText());
        this.disagreeButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                EulaFragment.this.getActivity().finish();
            }
        });
        return this.disagreeButton;
    }

    private TextView initializeTextView(View root) {
        this.textView = (TextView)root.findViewById(R.id.br_text);
        this.textView.setMovementMethod(ScrollingMovementMethod.getInstance());
        return this.textView;
    }

    private void initializeDialog() {
        this.getDialog().setTitle((CharSequence)this.getDialogTitle());
    }

    public static void showDialog(FragmentActivity fa) {
        boolean accepted = Res.getPreference((String)EulaFragment.getPreferenceName(), (boolean)false);
        if (!accepted) {
            EulaFragment fragment = (EulaFragment)EulaFragment.instantiate((Context)fa, (String)EulaFragment.class.getName());
            fragment.show(fa.getSupportFragmentManager(), TAG);
        } else if (fa instanceof OnEulaAgreedTo) {
            ((OnEulaAgreedTo)fa).onEulaAgreed();
        }
    }

    public static void setEulaAccepted(boolean accepted) {
        Res.setPreference((String)EulaFragment.getPreferenceName(), (boolean)accepted);
    }

    private static String getPreferenceName() {
        return "com.bingzer.android.bundleKey.uri:" + Res.getPackageName();
    }
}

