/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.lib.zip;

import android.text.TextUtils;
import com.bihe0832.android.lib.file.FileUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.model.FileHeader;
import net.lingala.zip4j.model.ZipParameters;

public class ZipUtils {
    private static final int BUFFER = 8192;
    private static final String ZIP_DOWNLOADED_FILE_SUFFIX = ".zip";

    public static boolean isZipFile(String filePath) {
        if (TextUtils.isEmpty((CharSequence)filePath)) {
            return false;
        }
        try {
            ZipFile zipFile = new ZipFile(filePath);
            return zipFile.isValidZipFile();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isZipFile(String filePath, boolean justCheckSuffix) {
        if (TextUtils.isEmpty((CharSequence)filePath)) {
            return false;
        }
        if (justCheckSuffix) {
            return filePath.toLowerCase().endsWith(ZIP_DOWNLOADED_FILE_SUFFIX);
        }
        try {
            ZipFile zipFile = new ZipFile(filePath);
            return zipFile.isValidZipFile();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static void compress(String srcPathName, String targetFilePath) {
        ZipUtils.zip(srcPathName, targetFilePath);
    }

    public static void compress(List<String> paths, String fileName) {
        ZipUtils.zip(paths, fileName);
    }

    public static void zip(String srcPathName, String targetFilePath) {
        ZipUtils.zip(srcPathName, targetFilePath, "");
    }

    public static void zip(List<String> paths, String fileName) {
        ZipUtils.zip(paths, fileName, "");
    }

    public static boolean unCompress(String srcPath, String fileDir) {
        return ZipUtils.unzip(srcPath, fileDir);
    }

    public static boolean unzip(String srcPath, String fileDir) {
        try {
            return ZipUtils.unzipAll(srcPath, fileDir, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean unCompress(String srcPath, String fileName, String fileDir) {
        return ZipUtils.unzip(srcPath, fileName, fileDir);
    }

    public static boolean unzip(String srcPath, String fileName, String fileDir) {
        try {
            return ZipUtils.unzipFile(srcPath, fileName, fileDir, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean unCompressWithOutPath(String zipFileName, String sourceFileName, String dstFolder) {
        return ZipUtils.unzipFileWithOutPath(zipFileName, sourceFileName, dstFolder);
    }

    public static boolean unzipFileWithOutPath(String zipFileName, String sourceFileName, String dstFolder) {
        return ZipUtils.unzipFile(zipFileName, sourceFileName, dstFolder, FileUtils.INSTANCE.getFileName(sourceFileName), null);
    }

    public static List<String> getFileList(String zipFileName) {
        return ZipUtils.getFileList(zipFileName, "");
    }

    public static List<String> getFileList(String zipFileName, String password) {
        if (TextUtils.isEmpty((CharSequence)zipFileName)) {
            return Collections.emptyList();
        }
        ArrayList<String> fileNameList = new ArrayList<String>();
        try {
            ZipFile zipFile = new ZipFile(zipFileName);
            if (zipFile.isEncrypted() && password != null) {
                zipFile.setPassword(password);
            }
            for (Object header : zipFile.getFileHeaders()) {
                if (!(header instanceof FileHeader)) continue;
                fileNameList.add(((FileHeader)header).getFileName());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return fileNameList;
    }

    private static void zip(String srcPathName, String targetFilePath, String password) {
        if (TextUtils.isEmpty((CharSequence)srcPathName) || TextUtils.isEmpty((CharSequence)targetFilePath)) {
            return;
        }
        try {
            ZipParameters parameters = new ZipParameters();
            parameters.setCompressionMethod(8);
            parameters.setCompressionLevel(5);
            if (password.length() > 0) {
                parameters.setEncryptFiles(true);
                parameters.setEncryptionMethod(99);
                parameters.setAesKeyStrength(3);
                parameters.setPassword(password);
            }
            ZipFile zipFile = new ZipFile(targetFilePath);
            zipFile.setRunInThread(false);
            File targetFile = new File(srcPathName);
            if (targetFile.isDirectory()) {
                zipFile.addFolder(targetFile, parameters);
            } else {
                zipFile.addFile(targetFile, parameters);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static boolean zip(List<String> list, String targetFilePath, String password) {
        if (list == null || list.size() == 0 || TextUtils.isEmpty((CharSequence)targetFilePath)) {
            return false;
        }
        try {
            ZipParameters parameters = new ZipParameters();
            parameters.setCompressionMethod(8);
            parameters.setCompressionLevel(5);
            if (password.length() > 0) {
                parameters.setEncryptFiles(true);
                parameters.setEncryptionMethod(99);
                parameters.setAesKeyStrength(3);
                parameters.setPassword(password);
            }
            ZipFile zipFile = new ZipFile(targetFilePath);
            zipFile.setRunInThread(false);
            ArrayList<File> fileList = new ArrayList<File>();
            for (String filePath : list) {
                fileList.add(new File(filePath));
            }
            zipFile.addFiles(fileList, parameters);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private static boolean unzipAll(String zipFileName, String dstFile, char[] password) {
        if (TextUtils.isEmpty((CharSequence)zipFileName) || TextUtils.isEmpty((CharSequence)dstFile)) {
            return false;
        }
        try {
            ZipFile zipFile = new ZipFile(zipFileName);
            if (zipFile.isEncrypted() && password != null) {
                zipFile.setPassword(password);
            }
            zipFile.setRunInThread(false);
            zipFile.extractAll(dstFile);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private static boolean unzipFile(String zipFileName, String sourceFileName, String dstFolder, char[] password) {
        return ZipUtils.unzipFile(zipFileName, sourceFileName, dstFolder, null, password);
    }

    private static boolean unzipFile(String zipFileName, String sourceFileName, String dstFolder, String destFileName, char[] password) {
        if (TextUtils.isEmpty((CharSequence)zipFileName) || TextUtils.isEmpty((CharSequence)sourceFileName) || TextUtils.isEmpty((CharSequence)dstFolder)) {
            return false;
        }
        try {
            ZipFile zipFile = new ZipFile(zipFileName);
            if (zipFile.isEncrypted() && password != null) {
                zipFile.setPassword(password);
            }
            zipFile.setRunInThread(false);
            for (Object header : zipFile.getFileHeaders()) {
                if (!(header instanceof FileHeader) || !((FileHeader)header).getFileName().equalsIgnoreCase(sourceFileName)) continue;
                zipFile.extractFile((FileHeader)header, dstFolder, null, destFileName);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

