/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.lib.webview.jsbridge;

import android.app.Activity;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.net.Uri;
import android.os.Looper;
import android.text.TextUtils;
import com.bihe0832.android.lib.log.ZLog;
import com.bihe0832.android.lib.thread.ThreadManager;
import com.bihe0832.android.lib.ui.toast.ToastUtil;
import com.bihe0832.android.lib.utils.apk.APKUtils;
import com.bihe0832.android.lib.webview.jsbridge.JsBridge;
import com.tencent.smtt.sdk.WebView;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public abstract class BaseJsBridgeProxy {
    private static final String TAG = "BaseJsBridgeProxy";
    private static final String ACTIVITY_STATE_CHANGE_CALLBACK = "activityStateCallback";
    private final int PAGE_CONTROL_RELOAD = 0;
    private final int PAGE_CONTROL_GO_BACK = 1;
    private final int PAGE_CONTROL_GO_FORWARD = 2;
    protected JsBridge mJsBridge;
    private WebView mWebView;
    private Activity mActivity;
    private boolean canPullRefresh = true;

    public BaseJsBridgeProxy(WebView webView, Activity activity) {
        this.mWebView = webView;
        this.mActivity = activity;
        this.mJsBridge = new JsBridge(this.mWebView, (Context)this.mActivity);
    }

    public BaseJsBridgeProxy(WebView webView, Activity activity, JsBridge jsBridge) {
        this.mWebView = webView;
        this.mActivity = activity;
        this.mJsBridge = jsBridge;
    }

    public void invoke(final String url) {
        ThreadManager.getInstance().start(new Runnable(){

            @Override
            public void run() {
                BaseJsBridgeProxy.this.invokeAsync(url);
            }
        });
    }

    private void invokeAsync(String url) {
        Uri uri = Uri.parse((String)url);
        String hostAsMethodName = uri.getHost();
        if (TextUtils.isEmpty((CharSequence)hostAsMethodName)) {
            return;
        }
        List paths = uri.getPathSegments();
        int seqid = 0;
        String callbackName = null;
        if (paths != null && paths.size() > 0) {
            try {
                seqid = Integer.parseInt((String)paths.get(0));
            }
            catch (Exception e) {
                e.printStackTrace();
                seqid = 0;
            }
            if (paths.size() > 1) {
                callbackName = (String)paths.get(1);
            }
        }
        if (hostAsMethodName.equals("callBatch")) {
            try {
                String param = uri.getQueryParameter("param");
                JSONArray jsonArray = new JSONArray(param);
                int length = jsonArray.length();
                for (int i = 0; i < length; ++i) {
                    JSONObject args;
                    JSONObject jsonObject = jsonArray.getJSONObject(i);
                    String method = jsonObject.getString("method");
                    int seqidOfCall = jsonObject.getInt("seqid");
                    String callback = null;
                    if (jsonObject.has("ZixieCallback")) {
                        callback = jsonObject.optString("ZixieCallback");
                    }
                    StringBuilder uriBuilder = new StringBuilder();
                    uriBuilder.append("jsb://").append(method).append("/").append(seqidOfCall).append("/").append(!TextUtils.isEmpty((CharSequence)callback) ? callback : "").append("?");
                    if (jsonObject.has("args") && (args = jsonObject.getJSONObject("args")) != null) {
                        Iterator iterator = args.keys();
                        while (iterator.hasNext()) {
                            String key = (String)iterator.next();
                            String value = Uri.decode((String)args.getString(key));
                            uriBuilder.append(key).append("=").append(Uri.encode((String)value)).append("&");
                        }
                    }
                    Uri uriForCall = Uri.parse((String)uriBuilder.toString());
                    this.callAMethod(uriForCall, method, seqidOfCall, callback);
                }
            }
            catch (Exception ex) {
                ZLog.d((String)TAG, (String)ex.toString());
                ex.printStackTrace();
            }
        } else {
            this.callAMethod(uri, hostAsMethodName, seqid, callbackName);
        }
    }

    protected void callAMethod(Uri uri, String hostAsMethodName, int seqid, String callbackName) {
        block7: {
            try {
                if (!TextUtils.isEmpty((CharSequence)hostAsMethodName)) {
                    BaseJsBridgeProxy obj = this;
                    ZLog.e((String)TAG, (String)this.getClass().getName());
                    Method method = this.getClass().getMethod(hostAsMethodName, Uri.class, Integer.TYPE, String.class, String.class);
                    method.invoke((Object)obj, uri, seqid, hostAsMethodName, callbackName);
                } else if (!TextUtils.isEmpty((CharSequence)callbackName)) {
                    this.mJsBridge.responseFail(callbackName, seqid, hostAsMethodName, -2);
                }
            }
            catch (NoSuchMethodException e) {
                ZLog.e((String)TAG, (String)"JSBridge method 404");
                ZLog.d((String)TAG, (String)e.toString());
                if (!TextUtils.isEmpty((CharSequence)callbackName)) {
                    this.mJsBridge.responseFail(callbackName, seqid, hostAsMethodName, -7);
                }
            }
            catch (Exception ex) {
                ZLog.e((String)TAG, (String)"JSBridge method has error");
                ZLog.d((String)TAG, (String)ex.toString());
                if (TextUtils.isEmpty((CharSequence)callbackName)) break block7;
                this.mJsBridge.responseFail(callbackName, seqid, hostAsMethodName, -3);
            }
        }
    }

    public WebView getWebView() {
        return this.mWebView;
    }

    public void pageControl(Uri uri, int seqid, String method, String function) {
        int type = 0;
        try {
            type = Integer.parseInt(uri.getQueryParameter("type"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.mWebView != null) {
            final int loadType = type;
            ThreadManager.getInstance().runOnUIThread(new Runnable(){

                @Override
                public void run() {
                    if (loadType == 1) {
                        BaseJsBridgeProxy.this.mWebView.goBack();
                    } else if (loadType == 2) {
                        BaseJsBridgeProxy.this.mWebView.goForward();
                    } else {
                        BaseJsBridgeProxy.this.mWebView.reload();
                    }
                }
            });
        }
        this.mJsBridge.response(function, seqid, method, "");
    }

    public void toast(Uri uri, int seqid, String method, String callbackFun) {
        int def_duration = 0;
        try {
            String durationStr = uri.getQueryParameter("duration");
            if (!TextUtils.isEmpty((CharSequence)durationStr)) {
                def_duration = Integer.parseInt(durationStr);
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        final int duration = def_duration;
        final String text = uri.getQueryParameter("text");
        if (Thread.currentThread() != Looper.getMainLooper().getThread()) {
            ThreadManager.getInstance().runOnUIThread(new Runnable(){

                @Override
                public void run() {
                    ToastUtil.show((Context)BaseJsBridgeProxy.this.mActivity, (String)text, (int)(duration == 1 ? 1 : 0));
                }
            });
        } else {
            ToastUtil.show((Context)this.mActivity, (String)text, (int)(duration == 1 ? 1 : 0));
        }
    }

    public void onResume() {
        ZLog.e((String)TAG, (String)"JSBridge onResume");
        this.mJsBridge.response(ACTIVITY_STATE_CHANGE_CALLBACK, 0, ACTIVITY_STATE_CHANGE_CALLBACK, "onResume", null, JsBridge.ResponseType.Event);
    }

    public void onPause() {
        ZLog.e((String)TAG, (String)"JSBridge onPause");
        this.mJsBridge.response(ACTIVITY_STATE_CHANGE_CALLBACK, 0, ACTIVITY_STATE_CHANGE_CALLBACK, "onPause", null, JsBridge.ResponseType.Event);
    }

    public void getAppInfo(Uri uri, int seqid, String method, String callbackFun) {
        String packageName = uri.getQueryParameter("packagename");
        if (TextUtils.isEmpty((CharSequence)packageName) || TextUtils.isEmpty((CharSequence)callbackFun)) {
            this.mJsBridge.responseFail(callbackFun, seqid, method, -4);
            return;
        }
        JSONObject result = new JSONObject();
        String pkgName = packageName.trim();
        PackageInfo item = APKUtils.getInstalledPackage((Context)this.mActivity, (String)pkgName);
        JSONObject json = new JSONObject();
        try {
            if (null != item) {
                json.put("install", 1);
                json.put("verCode", item.versionCode);
                json.put("verName", (Object)(item.versionName == null ? "" : item.versionName));
                result.put(pkgName, (Object)json);
                this.mJsBridge.response(callbackFun, seqid, method, result.toString());
                return;
            }
            json.put("install", 0);
            result.put(pkgName, (Object)json);
        }
        catch (Exception e) {
            this.mJsBridge.responseFail(callbackFun, seqid, method, -3);
        }
        this.mJsBridge.response(callbackFun, seqid, method, result.toString());
    }

    public void disablePullRefresh(Uri uri, int seqid, String method, String callbackFun) {
        this.canPullRefresh = false;
        this.mJsBridge.response(callbackFun, seqid, method, String.valueOf(this.canPullRefresh));
    }

    public void enablePullRefresh(Uri uri, int seqid, String method, String callbackFun) {
        this.canPullRefresh = true;
        this.mJsBridge.response(callbackFun, seqid, method, String.valueOf(this.canPullRefresh));
    }

    public boolean canPullToRefresh() {
        return this.canPullRefresh;
    }

    public void closePage(Uri uri, int seqid, String method, String callbackFun) {
        if (null != this.mActivity) {
            this.mJsBridge.response(callbackFun, seqid, method, String.valueOf(0));
            this.mActivity.finish();
        } else {
            this.mJsBridge.responseFail(callbackFun, seqid, method, -4);
        }
    }
}

