/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.lib.webview.jsbridge;

import android.content.Context;
import android.os.Looper;
import android.text.TextUtils;
import android.util.Log;
import com.bihe0832.android.lib.thread.ThreadManager;
import com.tencent.smtt.sdk.WebView;
import java.util.Map;
import org.json.JSONObject;

public class JsBridge {
    private static final String TAG = "JsBridge";
    public static final int ST_PAGE_ORIGINAL = 2000;
    public WebView mWebView;
    public Context mContext;
    public static final String JS_BRIDGE_SCHEME = "jsb://";
    public static final String CALL_BATCH_NAME = "callBatch";
    public static final String FILE_CHOOSER_CALLBACK_FUNCTION_NAME = "fileChooserCallback";

    public JsBridge(WebView webView, Context context) {
        this.mWebView = webView;
        this.mContext = context;
    }

    public void response(String function, int seqid, String method, String result) {
        this.response(function, seqid, method, result, null);
    }

    public void response(String function, int seqid, String method, String result, Map<String, String> extMap) {
        this.response(function, seqid, method, result, extMap, ResponseType.Method);
    }

    public void response(String function, int seqid, String method, String result, Map<String, String> extMap, ResponseType type) {
        if (TextUtils.isEmpty((CharSequence)function)) {
            return;
        }
        JSONObject json = new JSONObject();
        try {
            json.put("result", 0);
            json.put("data", (Object)result);
            if (!TextUtils.isEmpty((CharSequence)method)) {
                json.put("method", (Object)method);
            }
            json.put("seqid", seqid);
            if (extMap != null) {
                for (String key : extMap.keySet()) {
                    json.put(key, (Object)extMap.get(key));
                }
            }
            this.callback(function, json.toString(), type);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void responseFail(String callbackFun, int seqid, String method, int code) {
        this.responseFail(callbackFun, seqid, method, code, null);
    }

    public void responseFail(String callbackFun, int seqid, String method, int code, Map<String, String> extMap) {
        this.responseFail(callbackFun, seqid, method, code, null, ResponseType.Method);
    }

    public void responseFail(String callbackFun, int seqid, String method, int code, Map<String, String> extMap, ResponseType type) {
        if (TextUtils.isEmpty((CharSequence)callbackFun)) {
            return;
        }
        JSONObject json = new JSONObject();
        try {
            json.put("result", -1);
            json.put("code", code);
            json.put("method", (Object)method);
            json.put("seqid", seqid);
            if (extMap != null) {
                for (String key : extMap.keySet()) {
                    json.put(key, (Object)extMap.get(key));
                }
            }
            this.callback(callbackFun, json.toString(), type);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void callback(final String function, final String result, final ResponseType type) {
        if (Thread.currentThread() != Looper.getMainLooper().getThread()) {
            ThreadManager.getInstance().runOnUIThread(new Runnable(){

                @Override
                public void run() {
                    JsBridge.this.callbackUiThread(function, result, type);
                }
            });
        } else {
            this.callbackUiThread(function, result, type);
        }
    }

    public void callbackUiThread(String function, String result, ResponseType type) {
        Log.e((String)TAG, (String)("callbackUiThread " + result));
        StringBuffer sb = new StringBuffer("javascript:");
        switch (type) {
            case Method: {
                sb.append("if(!!").append("window." + function).append("){");
                sb.append(function);
                sb.append("(");
                sb.append(result);
                sb.append(")}");
                break;
            }
            case Event: {
                sb.append("var event = document.createEvent('Events');");
                sb.append("event.initEvent('" + function + "');");
                sb.append("event.data = " + result + ";");
                sb.append("window.dispatchEvent(event);");
            }
        }
        if (this.mWebView != null) {
            try {
                this.mWebView.loadUrl(sb.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static enum ResponseType {
        Method,
        Event;

    }
}

