/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.lib.webview;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Bundle;
import android.util.AttributeSet;
import com.bihe0832.android.lib.utils.os.BuildUtils;
import com.tencent.smtt.sdk.WebSettings;
import com.tencent.smtt.sdk.WebView;
import com.tencent.smtt.sdk.WebViewClient;

public class BaseWebView
extends WebView {
    private static final String APP_CACAHE_DIRNAME = "/webcache";
    private OnScrollChangedCallback mOnScrollChangedCallback;

    public BaseWebView(Context arg0) {
        super(arg0);
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    public BaseWebView(Context arg0, AttributeSet arg1) {
        super(arg0, arg1);
        this.setWebViewClient(new WebViewClient(){

            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                view.loadUrl(url);
                return true;
            }
        });
        this.initWebViewSettings();
        this.getRootView().setClickable(true);
    }

    public BaseWebView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setWebViewClient(new WebViewClient(){

            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                view.loadUrl(url);
                return true;
            }
        });
        this.initWebViewSettings();
        this.getRootView().setClickable(true);
    }

    protected void onScrollChanged(int l, int t, int oldl, int oldt) {
        super.onScrollChanged(l, t, oldl, oldt);
        if (this.mOnScrollChangedCallback != null) {
            this.mOnScrollChangedCallback.onScroll(l, t);
        }
    }

    public void setOnScrollChangedCallback(OnScrollChangedCallback onScrollChangedCallback) {
        this.mOnScrollChangedCallback = onScrollChangedCallback;
    }

    private void initWebViewSettings() {
        if (BuildUtils.INSTANCE.getSDK_INT() >= 11) {
            this.removeJavascriptInterface("searchBoxJavaBridge_");
            this.removeJavascriptInterface("accessibility");
            this.removeJavascriptInterface("accessibilityTraversal");
            this.getSettings().setDisplayZoomControls(false);
        }
        this.setHTMLSupport(this.getSettings());
        this.resetCacheType(this.getSettings());
        if (this.getX5WebViewExtension() != null) {
            Bundle data = new Bundle();
            data.putBoolean("standardFullScreen", false);
            data.putBoolean("supportLiteWnd", false);
            data.putInt("DefaultVideoScreen", 2);
            this.getX5WebViewExtension().invokeMiscMethod("setVideoParams", data);
            if (BuildUtils.INSTANCE.getSDK_INT() >= 17) {
                this.getSettings().setMediaPlaybackRequiresUserGesture(true);
            }
            this.setDrawingCacheEnabled(true);
        }
    }

    private void setHTMLSupport(WebSettings webSetting) {
        webSetting.setJavaScriptEnabled(true);
        webSetting.setAllowFileAccess(true);
        webSetting.setSupportMultipleWindows(false);
        webSetting.setPluginState(WebSettings.PluginState.ON_DEMAND);
        webSetting.setUseWideViewPort(true);
        webSetting.setLoadWithOverviewMode(true);
        if (BuildUtils.INSTANCE.getSDK_INT() > 21) {
            webSetting.setMixedContentMode(0);
        }
        webSetting.setSupportZoom(true);
        webSetting.setBuiltInZoomControls(true);
        webSetting.setLayoutAlgorithm(WebSettings.LayoutAlgorithm.SINGLE_COLUMN);
        webSetting.supportMultipleWindows();
        webSetting.setNeedInitialFocus(true);
        webSetting.setJavaScriptCanOpenWindowsAutomatically(true);
        webSetting.setLoadsImagesAutomatically(true);
        webSetting.setDefaultTextEncodingName("utf-8");
    }

    private void resetCacheType(WebSettings webSetting) {
        String cacheDirPath = this.getContext().getApplicationContext().getFilesDir().getAbsolutePath() + APP_CACAHE_DIRNAME;
        webSetting.setCacheMode(-1);
        webSetting.setDomStorageEnabled(true);
        webSetting.setDatabaseEnabled(true);
        webSetting.setDatabasePath(cacheDirPath);
        webSetting.setAppCachePath(cacheDirPath);
        webSetting.setAppCacheEnabled(true);
        webSetting.setAppCacheMaxSize(Long.MAX_VALUE);
    }

    public static interface OnScrollChangedCallback {
        public void onScroll(int var1, int var2);
    }
}

