/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.lib.utils.time;

import com.bihe0832.android.lib.log.ZLog;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class DateUtil {
    private static final String TAG = "DateUtil";
    public static final long MILLISECOND_OF_MINUTE = 60000L;
    public static final long MILLISECOND_OF_HOUR = 3600000L;
    public static final long MILLISECOND_OF_DAY = 86400000L;
    public static final long MILLISECOND_OF_MONTH = 2592000000L;
    public static final long MILLISECOND_OF_YEAR = 31104000000L;
    public static final int ONE_DAY_MILLSEC = 86400000;

    public static String getDateEN(long currentTime, String pattern) {
        SimpleDateFormat format = new SimpleDateFormat(pattern, Locale.US);
        String date = format.format(new Date(currentTime));
        return date;
    }

    public static String getDateEN(long currentTime) {
        return DateUtil.getDateEN(currentTime, "yyyy-MM-dd HH:mm:ss");
    }

    public static String getCurrentDateEN(String pattern) {
        return DateUtil.getDateEN(System.currentTimeMillis(), pattern);
    }

    public static String getCurrentDateEN() {
        return DateUtil.getCurrentDateEN("yyyy-MM-dd HH:mm:ss");
    }

    public static int getDateDistance(String date1, String date2) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            Date dt1 = df.parse(date1);
            Date dt2 = df.parse(date2);
            return (int)(Math.abs(dt2.getTime() - dt1.getTime()) / 1000L);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return -1;
        }
    }

    public static long getTime(String dateString, String pattern) {
        SimpleDateFormat df = new SimpleDateFormat(pattern);
        try {
            Date dt = df.parse(dateString);
            return dt.getTime();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return -1L;
        }
    }

    public static int compareDate(Date date1, String date2, String pattern2) {
        try {
            long dt2 = DateUtil.getTime(date2, pattern2);
            long dt1 = date1.getTime();
            ZLog.d((String)TAG, (String)("dt1.getTime:" + dt1 + ",dt2.getTime:" + dt2));
            if (dt1 >= dt2) {
                return 1;
            }
            if (dt1 < dt2) {
                return -1;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return 0;
    }

    public static int compareDate(Date date1, String date2) {
        return DateUtil.compareDate(date1, date2, "yyyyMMddHHmmss");
    }

    public static String getDateCompareResult(long oldTimestamp) {
        long currentTimestamp = System.currentTimeMillis();
        long diffValue = currentTimestamp - oldTimestamp;
        long yearC = diffValue / 31104000000L;
        long monthC = diffValue / 2592000000L;
        long weekC = diffValue / 604800000L;
        long dayC = diffValue / 86400000L;
        long hourC = diffValue / 3600000L;
        long minC = diffValue / 60000L;
        if (yearC > 0L) {
            return DateUtil.getDateEN(oldTimestamp, "yyyy\u5e74M\u6708d\u65e5");
        }
        if (monthC > 0L) {
            return DateUtil.getDateEN(oldTimestamp, "M\u6708d\u65e5");
        }
        if (weekC > 0L) {
            return DateUtil.getDateEN(oldTimestamp, "M\u6708d\u65e5");
        }
        if (dayC > 1L) {
            return DateUtil.getDateEN(oldTimestamp, "M\u6708d\u65e5");
        }
        if (dayC > 0L) {
            return "\u6628\u5929";
        }
        if (hourC > 0L) {
            return hourC + "\u5c0f\u65f6\u524d";
        }
        if (minC > 0L) {
            return minC + "\u5206\u949f\u524d";
        }
        return "\u521a\u521a";
    }

    public static String getDateCompareResult1(long oldTimestamp) {
        long currentTimestamp = System.currentTimeMillis();
        long diffValue = currentTimestamp - oldTimestamp;
        long yearC = diffValue / 31104000000L;
        long monthC = diffValue / 2592000000L;
        long weekC = diffValue / 604800000L;
        long dayC = diffValue / 86400000L;
        long hourC = diffValue / 3600000L;
        long minC = diffValue / 60000L;
        if (yearC > 0L) {
            return yearC + "\u5e74\u524d";
        }
        if (monthC > 0L) {
            return monthC + "\u6708\u524d";
        }
        if (weekC > 0L) {
            return weekC + "\u5468\u524d";
        }
        if (dayC > 1L) {
            return DateUtil.getDateEN(oldTimestamp, "M\u6708d\u65e5");
        }
        if (dayC > 0L) {
            return "\u6628\u5929";
        }
        if (hourC > 0L) {
            return hourC + "\u5c0f\u65f6\u524d";
        }
        if (minC > 0L) {
            return minC + "\u5206\u949f\u524d";
        }
        return "\u521a\u521a";
    }

    public static String getDateCompareResult2(long oldTimestamp) {
        long currentTimestamp = System.currentTimeMillis();
        long diffValue = currentTimestamp - oldTimestamp;
        long yearC = diffValue / 31104000000L;
        long dayC = diffValue / 86400000L;
        long hourC = diffValue / 3600000L;
        long minC = diffValue / 60000L;
        if (yearC > 0L) {
            return DateUtil.getDateEN(oldTimestamp, "yyyy-MM-dd");
        }
        if (dayC > 0L) {
            return DateUtil.getDateEN(oldTimestamp, "MM-dd HH:mm");
        }
        if (hourC > 0L) {
            return hourC + "\u5c0f\u65f6\u524d";
        }
        if (minC > 0L) {
            return minC + "\u5206\u949f\u524d";
        }
        return "\u521a\u521a";
    }

    public static boolean isToady(long timestamp) {
        int diffDay;
        Calendar pre = Calendar.getInstance();
        pre.setTimeInMillis(timestamp);
        Calendar cur = Calendar.getInstance();
        cur.setTimeInMillis(System.currentTimeMillis());
        ZLog.d((String)TAG, (String)("isToady --" + pre.get(1) + "--" + cur.get(1) + "--" + cur.get(6) + "--" + pre.get(6)));
        return pre.get(1) == cur.get(1) && 0 == (diffDay = cur.get(6) - pre.get(6));
    }
}

