/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.lib.utils;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public final class ReflecterHelper {
    public static Class<?> mCurrentClass;

    public static final boolean setClass(String name) {
        Class<?> tmpClass = null;
        try {
            tmpClass = Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        mCurrentClass = tmpClass;
        return mCurrentClass != null;
    }

    public static final int getStaticIntValue(String name, int defvalue) {
        int result = defvalue;
        Field field = ReflecterHelper.getField(name);
        if (field != null) {
            try {
                result = field.getInt(null);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static final int getIntValue(Object owner, String name, int defvalue) {
        int result = defvalue;
        ReflecterHelper.setClass(owner.getClass().getName());
        Field field = ReflecterHelper.getField(name);
        if (field != null) {
            try {
                result = field.getInt(owner);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static final Field getField(String name) {
        Field field = null;
        try {
            field = mCurrentClass.getDeclaredField(name);
            field.setAccessible(true);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        return field;
    }

    public static Object getStaticProperty(String className, String fieldName) {
        ReflecterHelper.setClass(className);
        Field field = ReflecterHelper.getField(fieldName);
        Object result = null;
        if (field != null) {
            try {
                result = field.get(null);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static void setStaticProperty(String className, String fieldName, Object value) {
        ReflecterHelper.setClass(className);
        Field field = ReflecterHelper.getField(fieldName);
        if (field != null) {
            try {
                field.set(null, value);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static Object newInstance(String className, Object[] args) throws Exception {
        Class<?> newoneClass = Class.forName(className);
        Constructor<?> cons = newoneClass.getDeclaredConstructor(ReflecterHelper.getArgsClasses(args));
        cons.setAccessible(true);
        return cons.newInstance(args);
    }

    public static Object newInstance(String className) throws Exception {
        return ReflecterHelper.newInstance(className, null);
    }

    public static Object invokeMethod(Object owner, String methodName, Object[] args) throws Exception {
        return ReflecterHelper.invokeMethod(owner, methodName, ReflecterHelper.getArgsClasses(args), args);
    }

    public static Object invokeMethod(Object owner, String methodName) throws Exception {
        return ReflecterHelper.invokeMethod(owner, methodName, null);
    }

    public static Object invokeMethod(Object owner, String methodName, Class<?>[] argsClass, Object[] args) throws Exception {
        Method method;
        block3: {
            Class<?> ownerClass = owner.getClass();
            method = null;
            try {
                method = ownerClass.getDeclaredMethod(methodName, argsClass);
            }
            catch (Exception e) {
                if (method == null && ownerClass.getSuperclass() != null) {
                    method = ownerClass.getSuperclass().getDeclaredMethod(methodName, argsClass);
                }
                if (method != null) break block3;
                throw e;
            }
        }
        method.setAccessible(true);
        return method.invoke(owner, args);
    }

    public static Object getProperty(Object owner, String fieldName) throws Exception {
        Class<?> ownerClass = owner.getClass();
        Field field = ownerClass.getDeclaredField(fieldName);
        field.setAccessible(true);
        Object property = field.get(owner);
        return property;
    }

    public static void setProperty(Object owner, String fieldName, Object value) throws Exception {
        Class<?> ownerClass = owner.getClass();
        Field field = ownerClass.getDeclaredField(fieldName);
        field.setAccessible(true);
        field.set(owner, value);
    }

    public static Object newInstance(String className, Object[] args, Class<?>[] argsClass) throws Exception {
        Class<?> newoneClass = Class.forName(className);
        Constructor<?> cons = newoneClass.getDeclaredConstructor(argsClass);
        cons.setAccessible(true);
        return cons.newInstance(args);
    }

    public static Object invokeStaticMethod(String className, String methodName, Object[] args, Class<?>[] argsClass) throws Exception {
        Object ret;
        Method staticMethod;
        Class<?> cls;
        block3: {
            cls = Class.forName(className);
            staticMethod = null;
            ret = null;
            try {
                staticMethod = cls.getDeclaredMethod(methodName, argsClass);
            }
            catch (Exception e) {
                if (staticMethod == null && cls.getSuperclass() != null) {
                    staticMethod = cls.getSuperclass().getDeclaredMethod(methodName, argsClass);
                }
                if (staticMethod != null) break block3;
                throw e;
            }
        }
        staticMethod.setAccessible(true);
        ret = staticMethod.invoke(cls, args);
        return ret;
    }

    public static Object invokeStaticMethod(String className, String methodName, Object[] args) throws Exception {
        return ReflecterHelper.invokeStaticMethod(className, methodName, args, ReflecterHelper.getArgsClasses(args));
    }

    public static Object invokeStaticMethod(String className, String methodName) throws Exception {
        return ReflecterHelper.invokeStaticMethod(className, methodName, null);
    }

    public static Class<?>[] getArgsClasses(Object[] args) {
        Class[] argsClass = null;
        if (args != null) {
            argsClass = new Class[args.length];
            int j = args.length;
            for (int i = 0; i < j; ++i) {
                argsClass[i] = args[i] != null ? args[i].getClass() : String.class;
                if (argsClass[i] == Integer.class) {
                    argsClass[i] = Integer.TYPE;
                    continue;
                }
                if (argsClass[i] == Boolean.class) {
                    argsClass[i] = Boolean.TYPE;
                    continue;
                }
                if (argsClass[i] != Long.class) continue;
                argsClass[i] = Long.TYPE;
            }
        }
        return argsClass;
    }
}

