/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.lib.utils;

import android.text.TextUtils;
import java.util.List;
import java.util.regex.Pattern;

public class ConvertUtils {
    public static int parseInt(String str, int defaultValue) {
        int value = defaultValue;
        if (!TextUtils.isEmpty((CharSequence)str)) {
            try {
                Pattern pattern = Pattern.compile("^[-\\+]?[\\d]+$");
                if (pattern.matcher(str).matches()) {
                    value = Integer.parseInt(str);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return value;
    }

    public static int parseInt(String str) {
        return ConvertUtils.parseInt(str, -1);
    }

    public static long parseLong(String str, long defaultValue) {
        long value = defaultValue;
        if (!TextUtils.isEmpty((CharSequence)str)) {
            try {
                Pattern pattern = Pattern.compile("^[-\\+]?[\\d]+$");
                if (pattern.matcher(str).matches()) {
                    value = Long.parseLong(str);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return value;
    }

    public static boolean parseBoolean(String str, boolean defaultValue) {
        boolean value = defaultValue;
        if (!TextUtils.isEmpty((CharSequence)str)) {
            if ("true".equalsIgnoreCase(str)) {
                return true;
            }
            if ("0".equalsIgnoreCase(str)) {
                return false;
            }
            if ("1".equalsIgnoreCase(str)) {
                return true;
            }
            if ("false".equalsIgnoreCase(str)) {
                return false;
            }
        }
        return value;
    }

    public static float parseFloat(String str, float defaultValue) {
        float value = defaultValue;
        if (!TextUtils.isEmpty((CharSequence)str)) {
            try {
                Pattern pattern = Pattern.compile("^[-+]?[\\d]*\\.?[\\d]+$");
                if (pattern.matcher(str).matches()) {
                    value = Float.parseFloat(str);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return value;
    }

    public static double parseDouble(String str, double defaultValue) {
        double value = defaultValue;
        if (!TextUtils.isEmpty((CharSequence)str)) {
            try {
                Pattern pattern = Pattern.compile("^[-+]?[\\d]*\\.?[\\d]+$");
                if (pattern.matcher(str).matches()) {
                    value = Double.parseDouble(str);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return value;
    }

    public static float[] floatArrayList2Array(List<Float> origin) {
        if (origin == null || origin.size() <= 0) {
            return null;
        }
        float[] result = new float[origin.size()];
        for (int i = 0; i < origin.size(); ++i) {
            result[i] = origin.get(i).floatValue();
        }
        return result;
    }

    public static long getUnsignedInt(int x) {
        return (long)x & 0xFFFFFFFFL;
    }

    public static String getSafeValueFromArray(String[] valueList, int index, String defaultValue) {
        if (valueList != null && index > -1 && index < valueList.length && !TextUtils.isEmpty((CharSequence)valueList[index])) {
            return valueList[index];
        }
        return defaultValue;
    }

    public static String getSafeValueFromList(List<String> valueList, int index, String defaultValue) {
        if (valueList != null && index > -1 && index < valueList.size() && !TextUtils.isEmpty((CharSequence)valueList.get(index))) {
            return valueList.get(index);
        }
        return defaultValue;
    }
}

