/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.lib.utils.time;

import android.content.Context;
import com.bihe0832.android.lib.utils.common.R;

public class TimeUtil {
    private static final String TAG = "TimeUtil";

    public static String formatElapsedTime(long elapsedSeconds) {
        long hours = 0L;
        long minutes = 0L;
        long seconds = 0L;
        if (elapsedSeconds >= 3600L) {
            hours = elapsedSeconds / 3600L;
            elapsedSeconds -= hours * 3600L;
        }
        if (elapsedSeconds >= 60L) {
            minutes = elapsedSeconds / 60L;
            elapsedSeconds -= minutes * 60L;
        }
        seconds = elapsedSeconds;
        if (hours > 0L) {
            return hours + "hour " + minutes + "min " + seconds + "s";
        }
        return minutes + "min " + seconds + "s";
    }

    public static String formatSecondsTo00(long elapsedSeconds, boolean needHour, boolean needHourAlways, boolean needSpace) {
        long hours = 0L;
        long minutes = 0L;
        long seconds = 0L;
        if (needHour && elapsedSeconds >= 3600L) {
            hours = elapsedSeconds / 3600L;
            elapsedSeconds -= hours * 3600L;
        }
        if (elapsedSeconds >= 60L) {
            minutes = elapsedSeconds / 60L;
            elapsedSeconds -= minutes * 60L;
        }
        seconds = elapsedSeconds;
        String divider = ":";
        if (needSpace) {
            divider = " : ";
        }
        String result = String.format("%02d", minutes) + divider + String.format("%02d", seconds);
        if (needHour && (hours > 0L || needHourAlways)) {
            result = String.format("%02d", hours) + divider + result;
        }
        return result;
    }

    public static String formatSecondsTo00(long elapsedSeconds) {
        return TimeUtil.formatSecondsTo00(elapsedSeconds, true, false, false);
    }

    public static String formatSecondsToDurationDesc(Context context, long seconds) {
        String timeStr = "";
        if (seconds > 59L) {
            long second = seconds % 60L;
            long min = seconds / 60L;
            timeStr = second + context.getString(R.string.date_second_short);
            if (min > 59L) {
                long hour = min / 60L;
                timeStr = (min %= 60L) + context.getString(R.string.date_minute_short) + timeStr;
                if (hour > 23L) {
                    long day = hour / 24L;
                    timeStr = (hour %= 24L) + context.getString(R.string.date_hour_short) + timeStr;
                    timeStr = day + context.getString(R.string.date_day_short) + timeStr;
                } else {
                    timeStr = hour + context.getString(R.string.date_hour_short) + timeStr;
                }
            } else {
                timeStr = min + context.getString(R.string.date_minute_short) + timeStr;
            }
        } else {
            timeStr = seconds + context.getString(R.string.date_second_short);
        }
        return timeStr;
    }
}

