/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.lib.utils;

import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.Random;

public class MathUtils {
    public static int getRandNumByLimit(int min, int max) {
        return (int)Math.round(Math.random() * (double)(max - min) + (double)min);
    }

    public static int[] sample(int N, int K) {
        Random random = new Random();
        int[] result = new int[K];
        int selection = K;
        int remains = N;
        for (int i = 0; i < N; ++i) {
            if (random.nextInt(remains) < selection) {
                result[K - selection] = i;
                --selection;
            }
            --remains;
        }
        return result;
    }

    public static int getMin(int ... params) {
        int min = params[0];
        for (int para : params) {
            if (para >= min) continue;
            min = para;
        }
        return min;
    }

    public static int getMax(int ... params) {
        int max = params[0];
        for (int para : params) {
            if (para <= max) continue;
            max = para;
        }
        return max;
    }

    public static float getFormatPercent(int fenzi, int fenmu, int scale) {
        return MathUtils.getFormatPercent((double)fenzi, (double)fenmu, scale);
    }

    public static float getFormatPercent(long fenzi, long fenmu, int scale) {
        return MathUtils.getFormatPercent((double)fenzi, (double)fenmu, scale);
    }

    public static float getFormatPercent(double fenzi, double fenmu, int scale) {
        float percent = 0.0f;
        if (fenmu > 0.0) {
            try {
                percent = new BigDecimal(fenzi).divide(new BigDecimal(fenmu), scale, 4).floatValue();
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    percent = (float)(fenzi / fenmu);
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                }
            }
        }
        if (percent < 0.0f) {
            percent = 0.0f;
        }
        return percent;
    }

    public static String getFormatPercentDesc(double fenzi, double fenmu, int scale) {
        return NumberFormat.getPercentInstance().format(MathUtils.getFormatPercent(fenzi, fenmu, scale));
    }

    public static String getFormatPercentDesc(float percent) {
        return NumberFormat.getPercentInstance().format(percent);
    }
}

