/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.lib.ui.common;

import android.graphics.Color;

public class ColorTools {
    private static final ThreadLocal<double[]> TEMP_ARRAY = new ThreadLocal();

    public static int getColorWithAlpha(float alpha, int baseColor) {
        int a = Math.min(255, Math.max(0, (int)(alpha * 255.0f))) << 24;
        int rgb = 0xFFFFFF & baseColor;
        return a + rgb;
    }

    public static boolean isLightColor(int color) {
        return ColorTools.calculateLuminance(color) > 0.5;
    }

    private static double calculateLuminance(int color) {
        double[] result = ColorTools.getTempDouble3Array();
        ColorTools.colorToXYZ(color, result);
        return result[1] / 100.0;
    }

    private static double[] getTempDouble3Array() {
        double[] result = TEMP_ARRAY.get();
        if (result == null) {
            result = new double[3];
            TEMP_ARRAY.set(result);
        }
        return result;
    }

    public static void colorToXYZ(int color, double[] outXyz) {
        ColorTools.RGBToXYZ(Color.red((int)color), Color.green((int)color), Color.blue((int)color), outXyz);
    }

    public static void RGBToXYZ(int r, int g, int b, double[] outXyz) {
        if (outXyz.length != 3) {
            throw new IllegalArgumentException("outXyz must have a length of 3.");
        }
        double sr = (double)r / 255.0;
        sr = sr < 0.04045 ? sr / 12.92 : Math.pow((sr + 0.055) / 1.055, 2.4);
        double sg = (double)g / 255.0;
        sg = sg < 0.04045 ? sg / 12.92 : Math.pow((sg + 0.055) / 1.055, 2.4);
        double sb = (double)b / 255.0;
        sb = sb < 0.04045 ? sb / 12.92 : Math.pow((sb + 0.055) / 1.055, 2.4);
        outXyz[0] = 100.0 * (sr * 0.4124 + sg * 0.3576 + sb * 0.1805);
        outXyz[1] = 100.0 * (sr * 0.2126 + sg * 0.7152 + sb * 0.0722);
        outXyz[2] = 100.0 * (sr * 0.0193 + sg * 0.1192 + sb * 0.9505);
    }
}

