/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.lib.thread;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class ThreadManager {
    public static final int LOOPER_TYPE_ANDROID_MAIN = 0;
    public static final int LOOPER_TYPE_NORMAL = 1;
    public static final int LOOPER_TYPE_HIGHER = 2;
    public static final int LOOPER_TYPE_LOWER = 3;
    private HandlerThread mNormalHandlerThread = null;
    private HandlerThread mHigherHandlerThread = null;
    private HandlerThread mLowerHandlerThread = null;
    private static final String THREAD_NAME_NORMAL = "THREAD_NORMAL";
    private static final String THREAD_NAME_HIGHER = "THREAD_HIGHER";
    private static final String THREAD_NAME_LOWER = "THREAD_LOWER";
    private Handler mPostDelayTempHandler;
    private ExecutorService executor;
    private static final String EXECUTOR_NAME_TEMP = "TEMP_THREADS";
    private static volatile ThreadManager instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ThreadManager getInstance() {
        if (instance != null) return instance;
        Class<ThreadManager> clazz = ThreadManager.class;
        synchronized (ThreadManager.class) {
            if (instance != null) return instance;
            instance = new ThreadManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private ThreadManager() {
    }

    public Looper getLooper(int type) {
        if (type == 0) {
            return Looper.getMainLooper();
        }
        if (type == 3) {
            if (null == this.mLowerHandlerThread) {
                this.mLowerHandlerThread = new HandlerThread(THREAD_NAME_LOWER, 1);
                this.mLowerHandlerThread.start();
            }
            return this.mLowerHandlerThread.getLooper();
        }
        if (type == 2) {
            if (null == this.mHigherHandlerThread) {
                this.mHigherHandlerThread = new HandlerThread(THREAD_NAME_HIGHER, 10);
                this.mHigherHandlerThread.start();
            }
            return this.mHigherHandlerThread.getLooper();
        }
        if (null == this.mNormalHandlerThread) {
            this.mNormalHandlerThread = new HandlerThread(THREAD_NAME_NORMAL, 5);
            this.mNormalHandlerThread.start();
        }
        return this.mNormalHandlerThread.getLooper();
    }

    public void start(Runnable runnable) {
        if (null == this.executor) {
            try {
                this.executor = Executors.newCachedThreadPool(new CommonThreadFactory());
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        try {
            this.executor.submit(runnable);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void start(final Runnable runnable, long delayMillis) {
        if (null == this.mPostDelayTempHandler) {
            this.mPostDelayTempHandler = new Handler(this.getLooper(2));
        }
        this.mPostDelayTempHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                ThreadManager.this.start(runnable);
            }
        }, delayMillis);
    }

    public void start(Runnable runnable, int seconds) {
        this.start(runnable, (long)seconds * 1000L);
    }

    public void runOnUIThread(Runnable runnable) {
        try {
            new Handler(Looper.getMainLooper()).post(runnable);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class CommonThreadFactory
    implements ThreadFactory {
        private final AtomicInteger poolNumber = new AtomicInteger(1);
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;

        public CommonThreadFactory() {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = "TEMP_THREADS-POOL-" + this.poolNumber.getAndIncrement();
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 1) {
                t.setPriority(1);
            }
            return t;
        }
    }
}

