/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.lib.ui.textview.span;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.text.style.ReplacementSpan;

public class ZixieTextRadiusBackgroundSpan
extends ReplacementSpan {
    private static final int DEFAULT_REDIUS = 8;
    private static final int DEFAULT_MARGIN = 12;
    private static final int DEFAULT_PADDING_LEFT = 12;
    private static final int DEFAULT_PADDING_TOP = 8;
    private static final float DEFAULT_TEXT_SIZE = 0.0f;
    private static final int DEFAULT_TEXT_COLOR = 0;
    private int mTextDataLength;
    private int mBackgroundColor = 0;
    private int mRadius = 8;
    private int mMargin = 12;
    private int mPaddingLeft = 12;
    private int mPaddingTop = 8;
    private float mTextSize = 0.0f;
    private int mTextColor = 0;
    private Typeface mTypeface = null;

    public ZixieTextRadiusBackgroundSpan(int bgColor) {
        this(bgColor, 8);
    }

    public ZixieTextRadiusBackgroundSpan(int bgColor, int radius) {
        this(bgColor, radius, 0.0f);
    }

    public ZixieTextRadiusBackgroundSpan(int bgColor, int radius, float textSize) {
        this(bgColor, radius, 12, 12, 8, textSize, 0, null);
    }

    public ZixieTextRadiusBackgroundSpan(int bgColor, int radius, int paddingLeft, int paddingTop) {
        this(bgColor, radius, 12, paddingLeft, paddingTop, 0.0f, 0, null);
    }

    public ZixieTextRadiusBackgroundSpan(int bgColor, int radius, int textSize, int textColor, Typeface mTypeface) {
        this(bgColor, radius, 12, 12, 8, textSize, textColor, mTypeface);
    }

    public ZixieTextRadiusBackgroundSpan(int bgColor, int radius, int margin, int paddingLeft, int paddingTop, float textSize, int textColor, Typeface typeface) {
        this.initData(bgColor, radius, margin, paddingLeft, paddingTop, textSize, textColor, typeface);
    }

    private void initData(int bgColor, int radius, int margin, int paddingLeft, int paddingTop, float textSize, int textColor, Typeface typeface) {
        this.mBackgroundColor = bgColor;
        this.mRadius = radius;
        this.mMargin = margin;
        this.mPaddingLeft = paddingLeft;
        this.mPaddingTop = paddingTop;
        this.mTextSize = textSize;
        this.mTextColor = textColor;
        this.mTypeface = typeface;
    }

    public int getSize(Paint paint, CharSequence text, int start, int end, Paint.FontMetricsInt fm) {
        float textSize = paint.getTextSize();
        if (this.mTextSize > 0.0f && paint.getTextSize() >= this.mTextSize) {
            paint.setTextSize(this.mTextSize);
        }
        this.mTextDataLength = (int)(paint.measureText(text, start, end) + (float)(2 * this.mRadius) + (float)(2 * this.mPaddingLeft) + (float)(2 * this.mMargin));
        paint.setTextSize(textSize);
        return this.mTextDataLength;
    }

    public void draw(Canvas canvas, CharSequence text, int start, int end, float x, int top, int y, int bottom, Paint paint) {
        int space;
        int borderMinTop;
        int color = paint.getColor();
        Typeface typeface = paint.getTypeface();
        float size = paint.getTextSize();
        Paint.FontMetricsInt fm = paint.getFontMetricsInt();
        int sourceTextHeight = fm.descent - fm.ascent;
        int cent = fm.descent + fm.ascent;
        int halfCenter = cent / 2;
        if (cent < 0) {
            halfCenter = -cent / 2;
        }
        int borderMaxBottom = y + cent;
        if (cent < 0) {
            borderMaxBottom = y + halfCenter;
        }
        if (borderMaxBottom > bottom) {
            borderMaxBottom = bottom - 1;
        }
        if ((borderMinTop = borderMaxBottom - sourceTextHeight - halfCenter) < top) {
            borderMinTop = top + 1;
        }
        canvas.save();
        if (this.mTextSize > 0.0f && paint.getTextSize() >= this.mTextSize) {
            paint.setTextSize(this.mTextSize);
        }
        paint.setColor(this.mBackgroundColor);
        paint.setAntiAlias(true);
        Paint.FontMetricsInt newFm = paint.getFontMetricsInt();
        int textHeight = newFm.descent - newFm.ascent;
        int realHeight = borderMaxBottom - borderMinTop;
        int baseHeight = borderMaxBottom - y;
        int realPadding = space = (realHeight - baseHeight - textHeight) / 2;
        if (space > this.mPaddingTop) {
            realPadding = this.mPaddingTop;
        }
        int borderRealTop = borderMinTop + (space - realPadding);
        int borderRealBottom = borderMaxBottom - (space - realPadding);
        RectF oval = new RectF(x + (float)this.mMargin, (float)borderRealTop, x + (float)this.mTextDataLength - (float)this.mMargin, (float)borderRealBottom);
        canvas.drawRoundRect(oval, (float)this.mRadius, (float)this.mRadius, paint);
        int textBottom = realPadding > 0 ? y - (borderMaxBottom - y) : borderRealBottom - (borderMaxBottom - y);
        if (this.mTextColor != 0) {
            paint.setColor(this.mTextColor);
        } else {
            paint.setColor(color);
        }
        if (this.mTypeface != null) {
            paint.setTypeface(this.mTypeface);
        } else {
            paint.setTypeface(typeface);
        }
        canvas.drawText(text, start, end, x + (float)this.mMargin + (float)this.mRadius + (float)this.mPaddingLeft, (float)textBottom, paint);
        canvas.save();
        canvas.restore();
    }
}

