/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.lib.ui.textview.expandable;

import android.content.Context;
import android.text.DynamicLayout;
import android.text.Layout;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.util.AttributeSet;
import com.bihe0832.android.lib.ui.textview.expandable.ExpandableTextView;
import org.jetbrains.annotations.Nullable;

public class FoldedTextView
extends ExpandableTextView {
    public FoldedTextView(Context context) {
        super(context);
    }

    public FoldedTextView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public FoldedTextView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    protected CharSequence getTextByConfig() {
        if (TextUtils.isEmpty((CharSequence)this.mOriginText)) {
            return this.mOriginText;
        }
        if (this.mWidth == 0) {
            return this.mOriginText;
        }
        this.mPaint = this.getPaint();
        DynamicLayout mLayout = new DynamicLayout(this.mOriginText, this.mPaint, this.mWidth, Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, false);
        int lineCount = mLayout.getLineCount();
        if (lineCount <= this.mMaxLineOnStrike) {
            return this.mOriginText;
        }
        switch (this.mCurrentStatus) {
            case 0: {
                int indexEnd;
                String ellipsisHintFinal = this.mShowEllipsisHint ? this.mEllipsisHint : "";
                String expandHintFinal = this.mShowToExpandHint ? this.mToExpandHint : "";
                int indexStart = mLayout.getLineStart(this.mMaxLineOnStrike - 1);
                int indexEndTrimmed = indexEnd = mLayout.getLineEnd(this.mMaxLineOnStrike - 1);
                if (this.mOriginText.charAt(indexEnd - 1) == '\n' && indexEndTrimmed > indexStart) {
                    indexEndTrimmed = indexEnd - 1;
                }
                float trimmedWidth = this.mPaint.measureText(this.mOriginText.subSequence(indexStart, indexEndTrimmed).toString() + ellipsisHintFinal + expandHintFinal);
                while (trimmedWidth > (float)this.mWidth) {
                    trimmedWidth = this.mPaint.measureText(this.mOriginText.subSequence(indexStart, --indexEndTrimmed).toString() + ellipsisHintFinal + expandHintFinal);
                }
                CharSequence fixText = this.mOriginText.subSequence(0, indexEndTrimmed);
                String maxLineFixText = this.mOriginText.subSequence(indexStart, indexEndTrimmed).toString();
                String spaceText = this.getSpaceText(maxLineFixText, ellipsisHintFinal + expandHintFinal);
                SpannableStringBuilder stringBuilder = new SpannableStringBuilder(fixText).append((CharSequence)spaceText).append((CharSequence)ellipsisHintFinal);
                if (this.mShowToExpandHint) {
                    stringBuilder.append((CharSequence)this.mToExpandHint);
                    stringBuilder.setSpan((Object)this.mTouchableSpan, stringBuilder.length() - this.getLengthOfString(expandHintFinal), stringBuilder.length(), 33);
                }
                return stringBuilder;
            }
            case 1: {
                if (!this.mShowToShrinkHint) {
                    return this.mOriginText;
                }
                SpannableStringBuilder ssbExpand = new SpannableStringBuilder(this.mOriginText).append((CharSequence)this.mToShrinkHint);
                ssbExpand.setSpan((Object)this.mTouchableSpan, ssbExpand.length() - this.getLengthOfString(this.mToShrinkHint), ssbExpand.length(), 33);
                return ssbExpand;
            }
        }
        return this.mOriginText;
    }
}

