/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.lib.ui.textview;

import android.content.Context;
import android.support.constraint.ConstraintLayout;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.bihe0832.android.lib.ui.textview.R;

public class TextViewWithRedTips
extends ConstraintLayout {
    private TextView mContentView;
    private TextView mRedNumView;
    private View mReddotView;

    private void initView(Context context) {
        View.inflate((Context)context, (int)R.layout.com_bihe0832_textview_red_tips, (ViewGroup)this);
        this.mContentView = (TextView)this.findViewById(R.id.item_text);
        this.mRedNumView = (TextView)this.findViewById(R.id.item_red_num);
        this.mReddotView = this.findViewById(R.id.item_red_dot);
    }

    public TextView getContentView() {
        return this.mContentView;
    }

    public TextView getRedNumView() {
        return this.mRedNumView;
    }

    public View getReddotView() {
        return this.mReddotView;
    }

    public TextViewWithRedTips(Context context) {
        super(context);
        this.initView(context);
    }

    public TextViewWithRedTips(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(context);
    }

    public TextViewWithRedTips(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initView(context);
    }

    public void setText(String content) {
        this.mContentView.setText((CharSequence)content);
    }

    public void setRednum(int num) {
        if (num > 0) {
            String showText = String.valueOf(num);
            if (num > 10000) {
                showText = num / 1000 + "k";
            }
            this.mRedNumView.setText((CharSequence)showText);
            this.mRedNumView.setVisibility(0);
            this.mReddotView.setVisibility(8);
        } else {
            this.mRedNumView.setVisibility(8);
        }
    }

    public void showReddot() {
        this.mReddotView.setVisibility(0);
    }

    public void hideReddot() {
        this.mReddotView.setVisibility(8);
    }
}

