/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.lib.text;

import android.text.Html;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.style.ClickableSpan;
import android.text.style.URLSpan;
import android.text.style.UnderlineSpan;
import android.view.View;
import com.bihe0832.android.lib.utils.TextFactoryCore;
import com.bihe0832.android.lib.utils.os.BuildUtils;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class TextFactoryUtils {
    public static final String STRING_HTML_SPACE = "&nbsp;";

    public static String trimSpace(String str) {
        return TextFactoryCore.trimSpace((String)str);
    }

    public static String trimMarks(String source) {
        if (TextUtils.isEmpty((CharSequence)source)) {
            return source;
        }
        String result = source;
        if (result.startsWith("\"")) {
            result = result.substring(1, result.length());
        }
        if (result.endsWith("\"")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    public static String[] split(String line, String seperator) {
        if (line == null || seperator == null || seperator.length() == 0) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        int pos1 = 0;
        while (true) {
            int pos2;
            if ((pos2 = line.indexOf(seperator, pos1)) < 0) break;
            list.add(line.substring(pos1, pos2));
            pos1 = pos2 + seperator.length();
        }
        list.add(line.substring(pos1));
        for (int i = list.size() - 1; i >= 0 && ((String)list.get(i)).length() == 0; --i) {
            list.remove(i);
        }
        return list.toArray(new String[0]);
    }

    public static String getRandomString(int len) {
        String returnStr = "";
        char[] ch = new char[len];
        Random rd = new Random();
        for (int i = 0; i < len; ++i) {
            ch[i] = (char)(rd.nextInt(9) + 97);
        }
        returnStr = new String(ch);
        return returnStr;
    }

    public static byte[] getBytesUTF8(String str) {
        try {
            return str.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static String getSpecialText(String text, int color) {
        return "<font color='" + color + "'>" + text + "</font>";
    }

    public static String getTextHtmlAfterTransform(String text) {
        return text.replaceAll(" ", STRING_HTML_SPACE).replaceAll("\n", "<BR>");
    }

    public static Spannable getLinkText(String text) {
        Spannable s = (Spannable)TextFactoryUtils.getSpannedTextByHtml(text);
        for (URLSpan u : (URLSpan[])s.getSpans(0, s.length(), URLSpan.class)) {
            s.setSpan((Object)new UnderlineSpan(){

                public void updateDrawState(TextPaint tp) {
                    tp.setUnderlineText(false);
                }
            }, s.getSpanStart((Object)u), s.getSpanEnd((Object)u), 0);
        }
        return s;
    }

    public static Spanned getSpannedTextByHtml(String text) {
        if (BuildUtils.INSTANCE.getSDK_INT() >= 24) {
            return Html.fromHtml((String)text, (int)0);
        }
        return Html.fromHtml((String)text);
    }

    public static final CharSequence getCharSequenceWithClickAction(String content, String title, View.OnClickListener listener) {
        SpannableStringBuilder spannableStringBuilder = new SpannableStringBuilder((CharSequence)TextFactoryUtils.getSpannedTextByHtml(content));
        Pattern pattern = Pattern.compile(title);
        Matcher matcher = pattern.matcher((CharSequence)spannableStringBuilder);
        while (matcher.find()) {
            TextFactoryUtils.setClickableSpan(spannableStringBuilder, matcher, listener);
        }
        return spannableStringBuilder;
    }

    public static final CharSequence getCharSequenceWithClickAction(String content, HashMap<String, View.OnClickListener> listenerHashMap) {
        SpannableStringBuilder spannableStringBuilder = new SpannableStringBuilder((CharSequence)TextFactoryUtils.getSpannedTextByHtml(content));
        for (Map.Entry<String, View.OnClickListener> entry : listenerHashMap.entrySet()) {
            Pattern pattern = Pattern.compile(entry.getKey());
            Matcher matcher = pattern.matcher((CharSequence)spannableStringBuilder);
            while (matcher.find()) {
                TextFactoryUtils.setClickableSpan(spannableStringBuilder, matcher, entry.getValue());
            }
        }
        return spannableStringBuilder;
    }

    private static final void setClickableSpan(SpannableStringBuilder clickableHtmlBuilder, Matcher matcher, final View.OnClickListener listener) {
        int start = matcher.start();
        int end = matcher.end();
        clickableHtmlBuilder.setSpan((Object)new ClickableSpan(){

            public void onClick(@NotNull View view) {
                listener.onClick(view);
            }

            public void updateDrawState(@NotNull TextPaint ds) {
                ds.setUnderlineText(false);
            }
        }, start, end, 34);
    }
}

