/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.lib.request;

import android.net.Uri;
import android.text.TextUtils;
import android.webkit.URLUtil;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;

public class URLUtils {
    public static final String HTTP_REQ_ENTITY_START = "?";
    public static final String HTTP_REQ_ENTITY_MERGE = "=";
    public static final String HTTP_REQ_ENTITY_JOIN = "&";
    public static final String HTTP_REQ_ENTITY_SPECIAL = "#";

    public static String getNoQueryUrl(String source) {
        String dest = source;
        try {
            URL sUrl = new URL(source);
            URL dUrl = new URL(sUrl.getProtocol(), sUrl.getHost(), sUrl.getPort(), sUrl.getPath());
            dest = dUrl.toString();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return dest;
    }

    public static String getUrlEncodeValue(String origValue) {
        if (origValue == null) {
            origValue = "";
        }
        return URLUtils.encode(origValue);
    }

    public static String encode(String value) {
        String encoded = "";
        try {
            encoded = URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        StringBuffer buf = new StringBuffer(encoded.length());
        for (int i = 0; i < encoded.length(); ++i) {
            char focus = encoded.charAt(i);
            if (focus == '*') {
                buf.append("%2A");
                continue;
            }
            if (focus == '+') {
                buf.append("%20");
                continue;
            }
            if (focus == '%' && i + 1 < encoded.length() && encoded.charAt(i + 1) == '7' && encoded.charAt(i + 2) == 'E') {
                buf.append('~');
                i += 2;
                continue;
            }
            buf.append(focus);
        }
        return buf.toString();
    }

    public static String getValueByName(String url, String name) {
        try {
            Uri uri = Uri.parse((String)url);
            String query = uri.getEncodedQuery();
            if (TextUtils.isEmpty((CharSequence)query)) {
                return "";
            }
            String encodedKey = Uri.encode((String)name, null);
            int length = query.length();
            int start = 0;
            while (true) {
                int nextAmpersand;
                int end = (nextAmpersand = query.indexOf(HTTP_REQ_ENTITY_JOIN, start)) != -1 ? nextAmpersand : length;
                int separator = query.indexOf(HTTP_REQ_ENTITY_MERGE, start);
                if (separator > end || separator == -1) {
                    separator = end;
                }
                if (separator - start == encodedKey.length() && query.regionMatches(start, encodedKey, 0, encodedKey.length())) {
                    if (separator == end) {
                        return "";
                    }
                    return query.substring(separator + 1, end);
                }
                if (nextAmpersand != -1) {
                    start = nextAmpersand + 1;
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    public static String getFileName(String url) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            return "";
        }
        int start = url.lastIndexOf("/");
        int finish = url.indexOf(HTTP_REQ_ENTITY_START);
        if (start != -1) {
            if (finish != -1) {
                return url.substring(start + 1, finish);
            }
            return url.substring(start + 1);
        }
        return "";
    }

    public static String marge(String url, String para) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            return "";
        }
        if (TextUtils.isEmpty((CharSequence)para)) {
            return url;
        }
        String resultURL = "";
        if (url.contains(HTTP_REQ_ENTITY_START)) {
            if (url.contains(HTTP_REQ_ENTITY_SPECIAL)) {
                resultURL = url.substring(0, url.indexOf(HTTP_REQ_ENTITY_START) + 1) + para;
                resultURL = para.endsWith(HTTP_REQ_ENTITY_JOIN) ? resultURL + url.substring(url.indexOf(HTTP_REQ_ENTITY_START) + 1) : resultURL + HTTP_REQ_ENTITY_JOIN + url.substring(url.indexOf(HTTP_REQ_ENTITY_START) + 1);
            } else {
                resultURL = url + HTTP_REQ_ENTITY_JOIN + para;
            }
        } else {
            resultURL = url + HTTP_REQ_ENTITY_START + para;
        }
        return resultURL;
    }

    public static String marge(String url, HashMap<String, String> para) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            return "";
        }
        if (null == para) {
            return url;
        }
        Uri.Builder builder = Uri.parse((String)url).buildUpon();
        for (Map.Entry<String, String> entry : para.entrySet()) {
            builder.appendQueryParameter(entry.getKey(), entry.getValue());
        }
        return builder.toString();
    }

    public static boolean isHTTPUrl(String pInput) {
        if (pInput == null) {
            return false;
        }
        return URLUtil.isHttpsUrl((String)pInput) || URLUtil.isHttpUrl((String)pInput);
    }

    public static boolean isURL(String source) {
        return URLUtil.isValidUrl((String)source);
    }
}

