/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.lib.request;

import android.text.TextUtils;
import com.bihe0832.android.lib.utils.os.BuildUtils;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HTTPRequestUtils {
    private static final Pattern TITLE_TAG = Pattern.compile("\\<title>(.*)\\</title>", 34);
    public static final String USER_AGENT_COMMON_ZIXIE = "Mozilla/5.0 (Linux; Android 10; UNKnown) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/89.0.4389.72 Mobile Safari/537.36/ ";

    public static String getPageTitle(String url) {
        try {
            URL e = new URL(url);
            HttpURLConnection conn = (HttpURLConnection)e.openConnection();
            conn.addRequestProperty("User-Agent", USER_AGENT_COMMON_ZIXIE);
            conn.setConnectTimeout(1000);
            conn.setReadTimeout(1000);
            ContentType contentType = HTTPRequestUtils.getContentTypeHeader(conn);
            if (contentType != null && contentType.contentType.equals("text/html")) {
                int n1;
                Charset charset = HTTPRequestUtils.getCharset(contentType);
                if (charset == null) {
                    charset = Charset.defaultCharset();
                }
                InputStream in = conn.getInputStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(in, charset));
                boolean n = false;
                int totalRead = 0;
                char[] buf = new char[1024];
                StringBuilder content = new StringBuilder();
                while ((n1 = reader.read(buf, 0, buf.length)) != -1) {
                    content.append(buf, 0, n1);
                    totalRead += n1;
                }
                reader.close();
                Matcher matcher = TITLE_TAG.matcher(content);
                return matcher.find() ? matcher.group(1).replaceAll("[\\s\\<>]+", " ").trim() : "unknown(-2)";
            }
            return "unknown(-1)";
        }
        catch (Exception var12) {
            var12.printStackTrace();
            return "unknown(-3)";
        }
    }

    public static ContentType getContentTypeHeader(URLConnection conn) {
        try {
            String headerValue;
            String headerName;
            int e = 0;
            boolean moreHeaders = true;
            do {
                headerName = conn.getHeaderFieldKey(e);
                headerValue = conn.getHeaderField(e);
                if (headerName != null && headerName.equalsIgnoreCase("Content-Type")) {
                    return new ContentType(headerValue);
                }
                ++e;
            } while (moreHeaders = headerName != null || headerValue != null);
        }
        catch (Exception var5) {
            var5.printStackTrace();
        }
        return null;
    }

    public static long getContentLength(URLConnection conn) {
        try {
            if (BuildUtils.INSTANCE.getSDK_INT() >= 24) {
                return conn.getContentLengthLong();
            }
            return conn.getContentLength();
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1L;
        }
    }

    public static String getRedirectUrl(String url) {
        try {
            HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection();
            conn.setInstanceFollowRedirects(false);
            conn.setConnectTimeout(5000);
            String redirectUrl = conn.getHeaderField("Location");
            if (TextUtils.isEmpty((CharSequence)redirectUrl)) {
                return url;
            }
            return HTTPRequestUtils.getRedirectUrl(redirectUrl);
        }
        catch (Exception e) {
            e.printStackTrace();
            return url;
        }
    }

    public static Charset getCharset(ContentType contentType) {
        try {
            return contentType != null && contentType.charsetName != null && Charset.isSupported(contentType.charsetName) ? Charset.forName(contentType.charsetName) : null;
        }
        catch (Exception var2) {
            var2.printStackTrace();
            return null;
        }
    }

    public static final class ContentType {
        private static final Pattern CHARSET_HEADER = Pattern.compile("charset=([-_a-zA-Z0-9]+)", 34);
        private String contentType;
        private String charsetName;

        private ContentType(String headerValue) {
            try {
                if (headerValue == null) {
                    throw new IllegalArgumentException("ContentType must be constructed with a not-null headerValue");
                }
                int e = headerValue.indexOf(";");
                if (e != -1) {
                    this.contentType = headerValue.substring(0, e);
                    Matcher matcher = CHARSET_HEADER.matcher(headerValue);
                    if (matcher.find()) {
                        this.charsetName = matcher.group(1);
                    }
                } else {
                    this.contentType = headerValue;
                }
            }
            catch (Exception var4) {
                var4.printStackTrace();
            }
        }
    }
}

