/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.activity;

import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.Intent;
import android.content.res.AssetFileDescriptor;
import android.graphics.Bitmap;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Vibrator;
import android.support.v7.app.AppCompatActivity;
import android.text.TextUtils;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.widget.Button;
import android.widget.ImageButton;
import android.widget.Toast;
import com.bihe0832.android.lib.qrcode.R;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.ChecksumException;
import com.google.zxing.DecodeHintType;
import com.google.zxing.FormatException;
import com.google.zxing.LuminanceSource;
import com.google.zxing.NotFoundException;
import com.google.zxing.Result;
import com.google.zxing.camera.CameraManager;
import com.google.zxing.common.HybridBinarizer;
import com.google.zxing.decoding.CaptureActivityHandler;
import com.google.zxing.decoding.InactivityTimer;
import com.google.zxing.decoding.RGBLuminanceSource;
import com.google.zxing.qrcode.QRCodeReader;
import com.google.zxing.util.BitmapUtil;
import com.google.zxing.view.ViewfinderView;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;

public class CaptureActivity
extends AppCompatActivity
implements SurfaceHolder.Callback {
    private static final int REQUEST_CODE_SCAN_GALLERY = 100;
    private CaptureActivityHandler handler;
    private ViewfinderView viewfinderView;
    private ImageButton back;
    private ImageButton btnFlash;
    private Button btnAlbum;
    private boolean isFlashOn = false;
    private boolean hasSurface;
    private Vector<BarcodeFormat> decodeFormats;
    private String characterSet;
    private InactivityTimer inactivityTimer;
    private MediaPlayer mediaPlayer;
    private boolean playBeep;
    private static final float BEEP_VOLUME = 0.1f;
    private boolean vibrate;
    private ProgressDialog mProgress;
    private String photo_path;
    private Bitmap scanBitmap;
    private View.OnClickListener albumOnClick = new View.OnClickListener(){

        public void onClick(View view) {
            Intent innerIntent = new Intent("android.intent.action.GET_CONTENT");
            innerIntent.setType("image/*");
            CaptureActivity.this.startActivityForResult(innerIntent, 100);
        }
    };
    private static final long VIBRATE_DURATION = 200L;
    private final MediaPlayer.OnCompletionListener beepListener = new MediaPlayer.OnCompletionListener(){

        public void onCompletion(MediaPlayer mediaPlayer) {
            mediaPlayer.seekTo(0);
        }
    };
    private View.OnClickListener flashListener = new View.OnClickListener(){

        public void onClick(View view) {
            try {
                boolean isSuccess = CameraManager.get().setFlashLight(!CaptureActivity.this.isFlashOn);
                if (!isSuccess) {
                    Toast.makeText((Context)CaptureActivity.this, (CharSequence)"\u6682\u65f6\u65e0\u6cd5\u5f00\u542f\u95ea\u5149\u706f", (int)0).show();
                    return;
                }
                if (CaptureActivity.this.isFlashOn) {
                    CaptureActivity.this.btnFlash.setImageResource(R.mipmap.flash_off);
                    CaptureActivity.this.isFlashOn = false;
                } else {
                    CaptureActivity.this.btnFlash.setImageResource(R.mipmap.flash_on);
                    CaptureActivity.this.isFlashOn = true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_scanner);
        CameraManager.init((Context)this.getApplication());
        this.viewfinderView = (ViewfinderView)this.findViewById(R.id.viewfinder_content);
        this.back = (ImageButton)this.findViewById(R.id.btn_back);
        this.back.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                CaptureActivity.this.finish();
            }
        });
        this.btnFlash = (ImageButton)this.findViewById(R.id.btn_flash);
        this.btnFlash.setOnClickListener(this.flashListener);
        this.btnAlbum = (Button)this.findViewById(R.id.btn_album);
        this.btnAlbum.setOnClickListener(this.albumOnClick);
        this.hasSurface = false;
        this.inactivityTimer = new InactivityTimer((Activity)this);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (resultCode == -1) {
            switch (requestCode) {
                case 100: {
                    this.handleAlbumPic(data);
                }
            }
        }
        super.onActivityResult(requestCode, resultCode, data);
    }

    private void handleAlbumPic(Intent data) {
        final Uri uri = data.getData();
        this.mProgress = new ProgressDialog((Context)this);
        this.mProgress.setMessage((CharSequence)"\u6b63\u5728\u626b\u63cf...");
        this.mProgress.setCancelable(false);
        this.mProgress.show();
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                Result result = CaptureActivity.this.scanningImage(uri);
                CaptureActivity.this.mProgress.dismiss();
                if (result != null) {
                    Intent resultIntent = new Intent();
                    Bundle bundle = new Bundle();
                    bundle.putString("qr_scan_result", result.getText());
                    resultIntent.putExtras(bundle);
                    CaptureActivity.this.setResult(-1, resultIntent);
                    CaptureActivity.this.finish();
                } else {
                    Toast.makeText((Context)CaptureActivity.this, (CharSequence)"\u8bc6\u522b\u5931\u8d25", (int)0).show();
                }
            }
        });
    }

    public Result scanningImage(Uri uri) {
        if (uri == null) {
            return null;
        }
        Hashtable<DecodeHintType, String> hints = new Hashtable<DecodeHintType, String>();
        hints.put(DecodeHintType.CHARACTER_SET, "UTF8");
        this.scanBitmap = BitmapUtil.decodeUri((Context)this, uri, 500, 500);
        RGBLuminanceSource source = new RGBLuminanceSource(this.scanBitmap);
        BinaryBitmap bitmap1 = new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)source));
        QRCodeReader reader = new QRCodeReader();
        try {
            return reader.decode(bitmap1, hints);
        }
        catch (NotFoundException e) {
            e.printStackTrace();
        }
        catch (ChecksumException e) {
            e.printStackTrace();
        }
        catch (FormatException e) {
            e.printStackTrace();
        }
        return null;
    }

    protected void onResume() {
        super.onResume();
        SurfaceView surfaceView = (SurfaceView)this.findViewById(R.id.scanner_view);
        SurfaceHolder surfaceHolder = surfaceView.getHolder();
        if (this.hasSurface) {
            this.initCamera(surfaceHolder);
        } else {
            surfaceHolder.addCallback((SurfaceHolder.Callback)this);
            surfaceHolder.setType(3);
        }
        this.decodeFormats = null;
        this.characterSet = null;
        this.playBeep = true;
        AudioManager audioService = (AudioManager)this.getSystemService("audio");
        if (audioService.getRingerMode() != 2) {
            this.playBeep = false;
        }
        this.initBeepSound();
        this.vibrate = true;
    }

    protected void onPause() {
        super.onPause();
        if (this.handler != null) {
            this.handler.quitSynchronously();
            this.handler = null;
        }
        CameraManager.get().closeDriver();
    }

    protected void onDestroy() {
        this.inactivityTimer.shutdown();
        super.onDestroy();
    }

    public void handleDecode(Result result, Bitmap barcode) {
        this.inactivityTimer.onActivity();
        this.playBeepSoundAndVibrate();
        String resultString = result.getText();
        if (TextUtils.isEmpty((CharSequence)resultString)) {
            Toast.makeText((Context)this, (CharSequence)"Scan failed!", (int)0).show();
        } else {
            Intent resultIntent = new Intent();
            Bundle bundle = new Bundle();
            bundle.putString("qr_scan_result", resultString);
            System.out.println("sssssssssssssssss scan 0 = " + resultString);
            resultIntent.putExtras(bundle);
            this.setResult(-1, resultIntent);
        }
        this.finish();
    }

    private void initCamera(SurfaceHolder surfaceHolder) {
        try {
            CameraManager.get().openDriver(surfaceHolder);
        }
        catch (IOException ioe) {
            return;
        }
        catch (RuntimeException e) {
            return;
        }
        if (this.handler == null) {
            this.handler = new CaptureActivityHandler(this, this.decodeFormats, this.characterSet);
        }
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
    }

    public void surfaceCreated(SurfaceHolder holder) {
        if (!this.hasSurface) {
            this.hasSurface = true;
            this.initCamera(holder);
        }
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        this.hasSurface = false;
    }

    public ViewfinderView getViewfinderView() {
        return this.viewfinderView;
    }

    public Handler getHandler() {
        return this.handler;
    }

    public void drawViewfinder() {
        this.viewfinderView.drawViewfinder();
    }

    private void initBeepSound() {
        if (this.playBeep && this.mediaPlayer == null) {
            this.setVolumeControlStream(3);
            this.mediaPlayer = new MediaPlayer();
            this.mediaPlayer.setAudioStreamType(3);
            this.mediaPlayer.setOnCompletionListener(this.beepListener);
            AssetFileDescriptor file = this.getResources().openRawResourceFd(R.raw.beep);
            try {
                this.mediaPlayer.setDataSource(file.getFileDescriptor(), file.getStartOffset(), file.getLength());
                file.close();
                this.mediaPlayer.setVolume(0.1f, 0.1f);
                this.mediaPlayer.prepare();
            }
            catch (IOException e) {
                this.mediaPlayer = null;
            }
        }
    }

    private void playBeepSoundAndVibrate() {
        if (this.playBeep && this.mediaPlayer != null) {
            this.mediaPlayer.start();
        }
        if (this.vibrate) {
            Vibrator vibrator = (Vibrator)this.getSystemService("vibrator");
            vibrator.vibrate(200L);
        }
    }
}

