/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.lib.okhttp.wrapper.interceptor;

import com.bihe0832.android.lib.okhttp.wrapper.OkHttpClientExtKt;
import com.bihe0832.android.lib.okhttp.wrapper.OkHttpWrapper;
import com.bihe0832.android.lib.okhttp.wrapper.interceptor.data.AAFRequestDataRepository;
import com.bihe0832.android.lib.okhttp.wrapper.interceptor.data.RequestContentDataRecord;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Connection;
import okhttp3.Interceptor;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u001a\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000e\u001a\u00020\fH\u0004J\u001a\u0010\u000f\u001a\u00020\b2\b\u0010\r\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0010\u001a\u00020\bH\u0004R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/bihe0832/android/lib/okhttp/wrapper/interceptor/AAFOKHttpInterceptor;", "Lokhttp3/Interceptor;", "enableIntercept", "", "(Z)V", "HTTP_REQ_PROPERTY_CONTENT_ENCODING", "", "intercept", "Lokhttp3/Response;", "chain", "Lokhttp3/Interceptor$Chain;", "interceptRequest", "Lokhttp3/Request;", "requestId", "request", "interceptResponse", "response", "LibOkhttpWrapper_release"})
public class AAFOKHttpInterceptor
implements Interceptor {
    private boolean enableIntercept;
    @NotNull
    private final String HTTP_REQ_PROPERTY_CONTENT_ENCODING;

    public AAFOKHttpInterceptor(boolean enableIntercept) {
        this.enableIntercept = enableIntercept;
        this.HTTP_REQ_PROPERTY_CONTENT_ENCODING = "Content-Encoding";
    }

    public /* synthetic */ AAFOKHttpInterceptor(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        this(bl);
    }

    @NotNull
    protected final Response interceptResponse(@Nullable String requestId, @NotNull Response response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        return response;
    }

    @NotNull
    protected final Request interceptRequest(@Nullable String requestId, @NotNull Request request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return request;
    }

    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) {
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        String requestId = OkHttpWrapper.INSTANCE.generateRequestID();
        RequestContentDataRecord requestContentDataRecord = null;
        Request request = chain.request().newBuilder().header("AAF-Content-Request-Id", requestId).build();
        Intrinsics.checkNotNullExpressionValue((Object)request, (String)"chain.request().newBuild\u2026ST_ID, requestId).build()");
        Request request2 = this.interceptRequest(requestId, request);
        if (this.enableIntercept) {
            Connection connection;
            requestContentDataRecord = AAFRequestDataRepository.INSTANCE.getNetworkContentDataRecordByContentID(requestId);
            Connection connection2 = connection = chain.connection();
            Object object = connection2 != null ? connection2.protocol() : null;
            if (object == null) {
                object = Protocol.HTTP_1_1;
            }
            Protocol protocol = object;
            String string = request2.url().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"request.url().toString()");
            requestContentDataRecord.setUrl(string);
            String string2 = request2.method();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"request.method()");
            requestContentDataRecord.setMethod(string2);
            requestContentDataRecord.setProtocol(protocol);
            requestContentDataRecord.setRequestHeadersMap(request2.headers());
            RequestBody requestBody = request2.body();
            if (requestBody != null) {
                long contentLength = requestBody.contentLength();
                requestContentDataRecord.setRequestBodyLength(contentLength != -1L ? contentLength + "-byte" : "unknown-length");
                if (requestBody.contentType() != null) {
                    requestContentDataRecord.setRequestContentType(requestBody.contentType());
                }
                requestContentDataRecord.setRequestBody(OkHttpClientExtKt.getRequestParams(request2));
            }
        }
        Response response = null;
        try {
            Response response2 = chain.proceed(request2);
            Intrinsics.checkNotNullExpressionValue((Object)response2, (String)"chain.proceed(request)");
            response = this.interceptResponse(requestId, response2);
        }
        catch (Exception var25) {
            if (this.enableIntercept) {
                RequestContentDataRecord requestContentDataRecord2 = requestContentDataRecord;
                if (requestContentDataRecord2 != null) {
                    requestContentDataRecord2.setErrorMsg(var25.toString());
                }
            }
            throw var25;
        }
        if (this.enableIntercept) {
            ResponseBody responseBody;
            RequestContentDataRecord requestContentDataRecord3 = requestContentDataRecord;
            if (requestContentDataRecord3 != null) {
                requestContentDataRecord3.setResponseHeadersMap(response.headers());
            }
            RequestContentDataRecord requestContentDataRecord4 = requestContentDataRecord;
            if (requestContentDataRecord4 != null) {
                requestContentDataRecord4.setStatus(response.code());
            }
            RequestContentDataRecord requestContentDataRecord5 = requestContentDataRecord;
            if (requestContentDataRecord5 != null) {
                String string = response.message();
                if (string == null) {
                    string = "";
                }
                requestContentDataRecord5.setErrorMsg(string);
            }
            if ((responseBody = response.body()) != null) {
                long contentLength = responseBody.contentLength();
                RequestContentDataRecord requestContentDataRecord6 = requestContentDataRecord;
                if (requestContentDataRecord6 != null) {
                    requestContentDataRecord6.setResponseBodyLength(contentLength != -1L ? contentLength + "-byte" : "unknown-length");
                }
                if (responseBody.contentType() != null) {
                    RequestContentDataRecord requestContentDataRecord7 = requestContentDataRecord;
                    if (requestContentDataRecord7 != null) {
                        requestContentDataRecord7.setResponseContentType(responseBody.contentType());
                    }
                }
                RequestContentDataRecord requestContentDataRecord8 = requestContentDataRecord;
                if (requestContentDataRecord8 != null) {
                    requestContentDataRecord8.setResponseBody(OkHttpClientExtKt.getResponseData(response));
                }
            }
        }
        return response;
    }

    public AAFOKHttpInterceptor() {
        this(false, 1, null);
    }
}

