/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.lib.log;

import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import com.bihe0832.android.lib.log.LogImpl;
import com.bihe0832.android.lib.log.LogImplForLogcat;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;

public final class ZLog {
    private static boolean sDebug;
    private static final String TAG = "ZLog";
    private static final int STACK_TRACE_DEEP = 6;
    private static final int LOG_LENGTH = 3000;
    private static final ConcurrentHashMap<String, LogImpl> logImplList;

    private static final String getTag() {
        return ZLog.getTag(null, 6);
    }

    private static final String getTag(String subTag, int index) {
        String tag = "";
        StackTraceElement[] traces = Thread.currentThread().getStackTrace();
        if (index < 0 || index >= traces.length) {
            return tag;
        }
        String clsName = traces[index].getClassName();
        String methodName = traces[index].getMethodName();
        String shortClsName = "";
        int dot = clsName.lastIndexOf(46);
        if (dot != -1) {
            shortClsName = clsName.substring(dot + 1);
        }
        tag = TextUtils.isEmpty((CharSequence)subTag) ? "ZLog " + shortClsName + "." + methodName : "ZLog->" + subTag + " " + shortClsName + "." + methodName;
        return tag;
    }

    public static void info(String log) {
        ZLog.info(ZLog.getTag(), log);
    }

    public static void info(String tag, String log) {
        if (log.length() > 3000) {
            for (int i = 0; i < log.length(); i += 3000) {
                if (i + 3000 < log.length()) {
                    ZLog.info(tag, log.substring(i, i + 3000));
                    continue;
                }
                ZLog.info(tag, log.substring(i));
            }
        } else {
            for (LogImpl tpl : logImplList.values()) {
                tpl.info(tag, log);
            }
        }
    }

    public static void i(String log) {
        if (sDebug) {
            ZLog.i(ZLog.getTag(), log);
        }
    }

    public static void i(String tag, String log) {
        block5: {
            if (!sDebug) break block5;
            if (log.length() > 3000) {
                for (int i = 0; i < log.length(); i += 3000) {
                    if (i + 3000 < log.length()) {
                        ZLog.i(tag, log.substring(i, i + 3000));
                        continue;
                    }
                    ZLog.i(tag, log);
                }
            } else {
                for (LogImpl tpl : logImplList.values()) {
                    tpl.i(tag, log);
                }
            }
        }
    }

    private static void debugLog(String tag, String log) {
        if (log.length() > 3000) {
            for (int i = 0; i < log.length(); i += 3000) {
                if (i + 3000 < log.length()) {
                    ZLog.debugLog(tag, log.substring(i, i + 3000));
                    continue;
                }
                ZLog.debugLog(tag, log.substring(i));
            }
        } else {
            for (LogImpl tpl : logImplList.values()) {
                tpl.d(tag, log);
            }
        }
    }

    public static void d(String tag, Bundle b) {
        if (sDebug) {
            if (b == null) {
                ZLog.debugLog(tag, "empty bundle");
                return;
            }
            Set keys = b.keySet();
            for (String key : keys) {
                if (b.get(key) instanceof byte[]) {
                    ZLog.debugLog(tag, key + ":" + new String(b.getByteArray(key)));
                    continue;
                }
                if (b.get(key) instanceof String) {
                    ZLog.debugLog(tag, key + ":" + b.getString(key));
                    continue;
                }
                if (b.get(key) instanceof Long) {
                    ZLog.debugLog(tag, key + ":" + b.getLong(key));
                    continue;
                }
                if (b.get(key) instanceof Integer) {
                    ZLog.debugLog(tag, key + ":" + b.getInt(key));
                    continue;
                }
                ZLog.debugLog(tag, key);
            }
        }
    }

    public static void d(String subTag, Intent i) {
        if (sDebug) {
            if (i == null || i.getExtras() == null) {
                ZLog.debugLog(subTag, "********************** INTENT START **************************");
                ZLog.debugLog(subTag, "********************** INTENT END **************************");
                return;
            }
            ZLog.debugLog(subTag, "********************** INTENT START **************************");
            ZLog.debugLog(subTag, "Action: " + i.getAction());
            ZLog.debugLog(subTag, "Component: " + i.getComponent());
            ZLog.debugLog(subTag, "Flags: " + i.getFlags());
            ZLog.debugLog(subTag, "Scheme: " + i.getScheme());
            Bundle b = i.getExtras();
            Set keys = b.keySet();
            for (String key : keys) {
                if (b.get(key) instanceof byte[]) {
                    ZLog.debugLog(subTag, key + ":" + new String(b.getByteArray(key)));
                    continue;
                }
                if (b.get(key) instanceof String) {
                    ZLog.debugLog(subTag, key + ":" + b.getString(key));
                    continue;
                }
                if (b.get(key) instanceof Long) {
                    ZLog.debugLog(subTag, key + ":" + b.getLong(key));
                    continue;
                }
                if (b.get(key) instanceof Integer) {
                    ZLog.debugLog(subTag, key + ":" + b.getInt(key));
                    continue;
                }
                ZLog.debugLog(subTag, key);
            }
            ZLog.debugLog(subTag, "********************** INTENT END **************************");
        }
    }

    public static void d(String log) {
        if (sDebug) {
            ZLog.debugLog(ZLog.getTag(), log);
        }
    }

    public static void d(String tag, String log) {
        if (sDebug) {
            ZLog.debugLog(tag, log);
        }
    }

    public static void d(Bundle b) {
        if (sDebug) {
            String tag = ZLog.getTag(null, 6);
            ZLog.d(tag, b);
        }
    }

    public static void d(Intent i) {
        if (sDebug) {
            String tag = ZLog.getTag(null, 6);
            ZLog.d(tag, i);
        }
    }

    public static void w(String tag, String log) {
        block5: {
            if (!sDebug) break block5;
            if (log.length() > 3000) {
                for (int i = 0; i < log.length(); i += 3000) {
                    if (i + 3000 < log.length()) {
                        ZLog.w(tag, log.substring(i, i + 3000));
                        continue;
                    }
                    ZLog.w(tag, log.substring(i));
                }
            } else {
                for (LogImpl tpl : logImplList.values()) {
                    tpl.w(tag, log);
                }
            }
        }
    }

    public static void w(String log) {
        if (sDebug) {
            ZLog.w(ZLog.getTag(), log);
        }
    }

    public static void e(String tag, String log) {
        block5: {
            if (!sDebug) break block5;
            if (log.length() > 3000) {
                for (int i = 0; i < log.length(); i += 3000) {
                    if (i + 3000 < log.length()) {
                        ZLog.e(tag, log.substring(i, i + 3000));
                        continue;
                    }
                    ZLog.e(tag, log.substring(i));
                }
            } else {
                for (LogImpl tpl : logImplList.values()) {
                    tpl.e(tag, log);
                }
            }
        }
    }

    public static void e(String log) {
        if (sDebug) {
            ZLog.e(ZLog.getTag(), log);
        }
    }

    public static final void setDebug(boolean debug) {
        sDebug = debug;
    }

    public static final void addLogImpl(@NotNull LogImpl impl) {
        if (!logImplList.containsKey(impl.getName())) {
            logImplList.put(impl.getName(), impl);
        }
    }

    public static final void removeImpl(@NotNull String name) {
        logImplList.remove(name);
    }

    public static final void closeLogcat() {
        ZLog.removeImpl(LogImplForLogcat.INSTANCE.getName());
    }

    static {
        logImplList = new ConcurrentHashMap<String, LogImpl>(){
            {
                this.put(LogImplForLogcat.INSTANCE.getName(), LogImplForLogcat.INSTANCE);
            }
        };
    }
}

