/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.lib.install;

import android.content.Context;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.bihe0832.android.lib.file.FileUtils;
import com.bihe0832.android.lib.file.mimetype.FileMimeTypes;
import com.bihe0832.android.lib.file.provider.ZixieFileProvider;
import com.bihe0832.android.lib.install.APKInstall;
import com.bihe0832.android.lib.install.InstallListener;
import com.bihe0832.android.lib.install.ObbFileInstall;
import com.bihe0832.android.lib.install.obb.OBBFormats;
import com.bihe0832.android.lib.install.splitapk.SplitApksInstallHelper;
import com.bihe0832.android.lib.log.ZLog;
import com.bihe0832.android.lib.thread.ThreadManager;
import com.bihe0832.android.lib.ui.toast.ToastUtil;
import com.bihe0832.android.lib.utils.intent.IntentUtils;
import com.bihe0832.android.lib.utils.os.BuildUtils;
import com.bihe0832.android.lib.zip.ZipUtils;
import java.io.File;
import java.util.LinkedList;
import org.jetbrains.annotations.NotNull;

public class InstallUtils {
    private static final String TAG = "InstallUtils";

    public static ApkInstallType getFileType(String filepath) {
        if (TextUtils.isEmpty((CharSequence)filepath)) {
            return ApkInstallType.NULL;
        }
        if (FileMimeTypes.INSTANCE.isApkFile(filepath)) {
            return ApkInstallType.APK;
        }
        File apkFile = new File(filepath);
        if (apkFile.isDirectory()) {
            return InstallUtils.getApkInstallTypeByFolder(apkFile);
        }
        return InstallUtils.getApkInstallTypeByZip(filepath);
    }

    public static boolean hasInstallAPPPermission(Context context, boolean showToast, boolean autoSettings) {
        boolean haveInstallPermission = true;
        if (BuildUtils.INSTANCE.getSDK_INT() >= 26) {
            try {
                haveInstallPermission = context.getPackageManager().canRequestPackageInstalls();
            }
            catch (Exception e) {
                haveInstallPermission = false;
                e.printStackTrace();
            }
            if (!haveInstallPermission) {
                if (showToast) {
                    ToastUtil.showShort((Context)context, (String)"\u5b89\u88c5\u5e94\u7528\u9700\u8981\u6253\u5f00\u672a\u77e5\u6765\u6e90\u6743\u9650\uff0c\u8bf7\u5728\u8bbe\u7f6e\u4e2d\u5f00\u542f\u6743\u9650");
                }
                if (autoSettings) {
                    IntentUtils.startAppSettings((Context)context, (String)"android.settings.MANAGE_UNKNOWN_APP_SOURCES");
                }
            }
        }
        return haveInstallPermission;
    }

    public static void uninstallAPP(Context context, String packageName) {
        APKInstall.unInstallAPK(context, packageName);
    }

    public static void installAPP(Context context, Uri fileProvider, File file) {
        APKInstall.realInstallAPK(context, fileProvider, file, null);
    }

    public static void installAPP(Context context, String filePath) {
        InstallUtils.installAPP(context, filePath, "");
    }

    public static void installAPP(Context context, String filePath, String packageName) {
        InstallUtils.installAPP(context, filePath, packageName, null);
    }

    public static void installAPP(final Context context, final String filePath, final String packageName, final InstallListener listener) {
        if (InstallUtils.hasInstallAPPPermission(context, true, true)) {
            ThreadManager.getInstance().start(new Runnable(){

                @Override
                public void run() {
                    InstallUtils.installAllAPK(context, filePath, packageName, new InstallListener(){

                        @Override
                        public void onUnCompress() {
                            ZLog.d((String)"InstallUtils installAllApk onUnCompress");
                            if (listener != null) {
                                listener.onUnCompress();
                            }
                        }

                        @Override
                        public void onInstallPrepare() {
                            ZLog.d((String)"InstallUtils installAllApk onInstallPrepare");
                            if (listener != null) {
                                listener.onInstallPrepare();
                            }
                        }

                        @Override
                        public void onInstallStart() {
                            ZLog.d((String)"InstallUtils installAllApk onInstallStart");
                            if (listener != null) {
                                listener.onInstallStart();
                            }
                        }

                        @Override
                        public void onInstallFailed(int errorcode) {
                            ZLog.d((String)("InstallUtils installAllApk onInstallFailed : " + errorcode));
                            if (listener != null) {
                                listener.onInstallFailed(errorcode);
                            }
                        }
                    });
                }
            });
        }
    }

    static void installAllAPK(Context context, String filePath, String packageName, InstallListener listener) {
        try {
            File downloadedFile = new File(filePath);
            ZLog.d((String)("InstallUtilsinstallAllApk downloadedFile:" + downloadedFile.getAbsolutePath()));
            if (downloadedFile == null || !downloadedFile.exists()) {
                listener.onInstallFailed(-1);
                return;
            }
            if (FileMimeTypes.INSTANCE.isApkFile(filePath)) {
                APKInstall.installAPK(context, downloadedFile.getAbsolutePath(), listener);
            } else if (ZipUtils.isZipFile((String)downloadedFile.getAbsolutePath(), (boolean)true)) {
                InstallUtils.installSpecialAPKByZip(context, filePath, packageName, listener);
            } else if (!downloadedFile.isDirectory()) {
                APKInstall.installAPK(context, downloadedFile.getAbsolutePath(), listener);
            } else {
                InstallUtils.installSpecialAPKByFolder(context, downloadedFile.getAbsolutePath(), packageName, listener);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            ZLog.d((String)("InstallUtilsinstallAllApk failed:" + e.getMessage()));
            listener.onInstallFailed(-3);
        }
    }

    static void installSpecialAPKByZip(@NotNull Context context, @NonNull String zipFilePath, String packageName, InstallListener listener) {
        ZLog.d((String)("InstallUtilsinstallSpecialAPKByZip:" + zipFilePath));
        String finalPackageName = "";
        finalPackageName = TextUtils.isEmpty((CharSequence)packageName) ? FileUtils.INSTANCE.getFileNameWithoutEx(zipFilePath) : packageName;
        ApkInstallType apkInstallType = InstallUtils.getApkInstallTypeByZip(zipFilePath);
        if (apkInstallType == ApkInstallType.OBB) {
            ObbFileInstall.installObbAPKByZip(context, zipFilePath, finalPackageName, listener);
        } else if (apkInstallType == ApkInstallType.SPLIT_APKS) {
            String fileDir = ZixieFileProvider.getZixieFilePath((Context)context) + "/" + packageName;
            ZLog.d((String)"InstallUtilsinstallSpecialAPKByZip start unCompress:");
            listener.onUnCompress();
            ZipUtils.unCompress((String)zipFilePath, (String)fileDir);
            ZLog.d((String)"InstallUtilsinstallSpecialAPKByZip finished unCompress ");
            SplitApksInstallHelper.INSTANCE.installApk(context, new File(fileDir), finalPackageName, listener);
        } else if (apkInstallType == ApkInstallType.APK) {
            String fileDir = ZixieFileProvider.getZixieFilePath((Context)context) + "/" + packageName;
            ZLog.d((String)"InstallUtilsinstallSpecialAPKByZip start unCompress:");
            listener.onUnCompress();
            ZipUtils.unCompress((String)zipFilePath, (String)fileDir);
            ZLog.d((String)"InstallUtilsinstallSpecialAPKByZip finished unCompress ");
            InstallUtils.installSpecialAPKByFolder(context, fileDir, finalPackageName, listener);
        } else {
            listener.onInstallFailed(-6);
        }
    }

    static void installSpecialAPKByFolder(@NotNull Context context, @NonNull String folderPath, String packageName, InstallListener listener) {
        ZLog.d((String)("InstallUtilsinstallSpecialAPKByFolder:" + folderPath));
        String finalPackageName = "";
        finalPackageName = TextUtils.isEmpty((CharSequence)packageName) ? FileUtils.INSTANCE.getFileName(folderPath) : packageName;
        ApkInstallType apkInstallType = InstallUtils.getApkInstallTypeByFolder(new File(folderPath));
        ZLog.d((String)("InstallUtilsinstallSpecialAPKByFolder start install:" + folderPath));
        if (apkInstallType == ApkInstallType.OBB) {
            ObbFileInstall.installObbAPKByFile(context, folderPath, finalPackageName, listener);
        } else if (apkInstallType == ApkInstallType.SPLIT_APKS) {
            SplitApksInstallHelper.INSTANCE.installApk(context, new File(folderPath), finalPackageName, listener);
        } else if (apkInstallType == ApkInstallType.APK) {
            boolean hasInstall = false;
            for (File file2 : new File(folderPath).listFiles()) {
                if (!FileMimeTypes.INSTANCE.isApkFile(file2.getAbsolutePath())) continue;
                hasInstall = true;
                APKInstall.installAPK(context, file2.getAbsolutePath(), listener);
                break;
            }
            if (!hasInstall) {
                listener.onInstallFailed(-6);
            }
        } else {
            listener.onInstallFailed(-6);
        }
    }

    static ApkInstallType getApkInstallTypeByZip(String zipFile) {
        if (zipFile == null) {
            return ApkInstallType.APK;
        }
        int apkFileCount = 0;
        for (String fileName : ZipUtils.getFileList((String)zipFile)) {
            if (OBBFormats.isObbFile(fileName)) {
                return ApkInstallType.OBB;
            }
            if (!FileMimeTypes.INSTANCE.isApkFile(fileName)) continue;
            if (apkFileCount > 0) {
                return ApkInstallType.SPLIT_APKS;
            }
            ++apkFileCount;
        }
        if (apkFileCount > 1) {
            return ApkInstallType.SPLIT_APKS;
        }
        if (apkFileCount > 0) {
            return ApkInstallType.APK;
        }
        return ApkInstallType.NULL;
    }

    static ApkInstallType getApkInstallTypeByFolder(File apkInstallFile) {
        if (apkInstallFile == null || !apkInstallFile.exists()) {
            return ApkInstallType.NULL;
        }
        int apkFileCount = 0;
        LinkedList<File> folderList = new LinkedList<File>();
        for (File file2 : apkInstallFile.listFiles()) {
            if (file2.isDirectory()) {
                folderList.add(file2);
                continue;
            }
            if (OBBFormats.isObbFile(file2.getAbsolutePath())) {
                return ApkInstallType.OBB;
            }
            if (!FileMimeTypes.INSTANCE.isApkFile(file2.getAbsolutePath())) continue;
            if (apkFileCount > 0) {
                return ApkInstallType.SPLIT_APKS;
            }
            ++apkFileCount;
        }
        while (!folderList.isEmpty()) {
            File temp_file = (File)folderList.removeFirst();
            for (File file2 : temp_file.listFiles()) {
                if (file2.isDirectory()) {
                    folderList.add(file2);
                    continue;
                }
                if (OBBFormats.isObbFile(file2.getAbsolutePath())) {
                    return ApkInstallType.OBB;
                }
                if (!FileMimeTypes.INSTANCE.isApkFile(file2.getAbsolutePath())) continue;
                if (apkFileCount > 0) {
                    return ApkInstallType.SPLIT_APKS;
                }
                ++apkFileCount;
            }
        }
        if (apkFileCount > 1) {
            return ApkInstallType.SPLIT_APKS;
        }
        if (apkFileCount > 0) {
            return ApkInstallType.APK;
        }
        return ApkInstallType.NULL;
    }

    public static enum ApkInstallType {
        NULL,
        APK,
        OBB,
        SPLIT_APKS;

    }
}

