/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.lib.install;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Log;
import com.bihe0832.android.lib.file.provider.ZixieFileProvider;
import com.bihe0832.android.lib.install.InstallListener;
import com.bihe0832.android.lib.utils.os.BuildUtils;
import java.io.File;

class APKInstall {
    private static String INSTALL_TYPE = "application/vnd.android.package-archive";

    APKInstall() {
    }

    static void installAPK(Context context, String filePath, InstallListener listener) {
        if (!TextUtils.isEmpty((CharSequence)filePath)) {
            try {
                File file = new File(filePath);
                Uri fileProvider = ZixieFileProvider.getZixieFileProvider((Context)context, (File)file);
                APKInstall.realInstallAPK(context, fileProvider, file, listener);
            }
            catch (ActivityNotFoundException e) {
                e.printStackTrace();
                listener.onInstallFailed(-2);
            }
        } else {
            listener.onInstallFailed(-1);
        }
    }

    static void realInstallAPK(Context context, Uri fileProvider, File file, InstallListener listener) {
        block9: {
            if (file != null && file.exists()) {
                Intent intent = new Intent("android.intent.action.VIEW");
                intent.setFlags(0x10000000);
                try {
                    if (BuildUtils.INSTANCE.getSDK_INT() < 24) {
                        intent.setDataAndType(Uri.fromFile((File)file), INSTALL_TYPE);
                    } else {
                        intent.setDataAndType(fileProvider, INSTALL_TYPE);
                        intent.addFlags(1);
                        intent.addFlags(2);
                    }
                    if (BuildUtils.INSTANCE.getSDK_INT() > 26 && !context.getPackageManager().canRequestPackageInstalls()) {
                        Log.e((String)"InstallUtils", (String)"app don't hava install permission");
                        Log.e((String)"InstallUtils", (String)"app don't hava install permission");
                        Log.e((String)"InstallUtils", (String)"app don't hava install permission");
                    }
                    context.startActivity(intent);
                    if (null != listener) {
                        listener.onInstallStart();
                    }
                    break block9;
                }
                catch (ActivityNotFoundException e) {
                    e.printStackTrace();
                    if (null != listener) {
                        listener.onInstallFailed(-2);
                    }
                    break block9;
                }
            }
            if (null != listener) {
                listener.onInstallFailed(-1);
            }
        }
    }

    static void unInstallAPK(Context context, String packageName) {
        try {
            Intent intent = new Intent("android.intent.action.DELETE");
            intent.setData(Uri.parse((String)("package:" + packageName)));
            intent.addFlags(0x10000000);
            context.startActivity(intent);
        }
        catch (ActivityNotFoundException e) {
            e.printStackTrace();
        }
    }
}

