/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.lib.http.common.core;

import android.content.Context;
import android.text.TextUtils;
import com.bihe0832.android.lib.http.common.HTTPServer;
import com.bihe0832.android.lib.http.common.core.BaseConnection;
import com.bihe0832.android.lib.http.common.core.FileInfo;
import com.bihe0832.android.lib.log.ZLog;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class HttpFileUpload {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String postRequest(Context context, BaseConnection baseConnection, Map<String, String> strParams, List<FileInfo> fileParams) {
        baseConnection.setURLConnectionCommonPara();
        HashMap<String, String> requestProperty = new HashMap<String, String>();
        requestProperty.put("Charset", "UTF-8");
        requestProperty.put("Content-Type", "multipart/form-data");
        baseConnection.setURLConnectionRequestProperty(requestProperty);
        HttpURLConnection urlConnection = baseConnection.getURLConnection();
        FilterOutputStream paramDataOutputStream = null;
        InputStream resultInptStream = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            urlConnection.setRequestMethod("POST");
            urlConnection.setDoOutput(true);
            urlConnection.setDoInput(true);
            urlConnection.setRequestProperty("Connection", "Keep-Alive");
            urlConnection.setRequestProperty("Charset", "UTF-8");
            urlConnection.setRequestProperty("Content-Type", "multipart/form-data;boundary=" + HTTPServer.BOUNDARY);
            paramDataOutputStream = new DataOutputStream(urlConnection.getOutputStream());
            ((DataOutputStream)paramDataOutputStream).writeBytes(this.getFormDataString(strParams).toString());
            ((DataOutputStream)paramDataOutputStream).flush();
            for (FileInfo fileInfo : fileParams) {
                ((DataOutputStream)paramDataOutputStream).writeBytes(fileInfo.getRequesetData(HTTPServer.BOUNDARY));
                ((DataOutputStream)paramDataOutputStream).flush();
                InputStream paramInputStream = null;
                paramInputStream = fileInfo.getFileUri() != null ? context.getContentResolver().openInputStream(fileInfo.getFileUri()) : new FileInputStream(fileInfo.getFile());
                if (paramInputStream != null) {
                    byte[] buffer = new byte[1024];
                    int len = 0;
                    while ((len = paramInputStream.read(buffer)) != -1) {
                        ((DataOutputStream)paramDataOutputStream).write(buffer, 0, len);
                    }
                    paramInputStream.close();
                }
                ((DataOutputStream)paramDataOutputStream).writeBytes("\r\n");
            }
            ((DataOutputStream)paramDataOutputStream).writeBytes("--" + HTTPServer.BOUNDARY + "--" + "\r\n");
            ((DataOutputStream)paramDataOutputStream).flush();
            paramDataOutputStream.close();
            ZLog.e((String)"bihe0832 REQUEST", (String)("postResponseCode() = " + urlConnection.getResponseCode()));
            if (urlConnection.getResponseCode() == 200) {
                int resultLen;
                resultInptStream = urlConnection.getInputStream();
                byteArrayOutputStream = new ByteArrayOutputStream();
                byte[] resultBuffer = new byte[8192];
                while ((resultLen = resultInptStream.read(resultBuffer)) != -1) {
                    byteArrayOutputStream.write(resultBuffer, 0, resultLen);
                }
                resultInptStream.close();
                String string = byteArrayOutputStream.toString("UTF-8");
                return string;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (paramDataOutputStream != null) {
                    paramDataOutputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (resultInptStream != null) {
                    resultInptStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (byteArrayOutputStream != null) {
                    byteArrayOutputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (urlConnection != null) {
                    urlConnection.disconnect();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return "";
    }

    public String getFormDataString(Map<String, String> strParams) {
        Map.Entry<String, String> entry;
        StringBuffer stringBuffer = new StringBuffer();
        Iterator<Map.Entry<String, String>> iterator = strParams.entrySet().iterator();
        while (!(!iterator.hasNext() || TextUtils.isEmpty((CharSequence)(entry = iterator.next()).getKey()) && TextUtils.isEmpty((CharSequence)entry.getValue()))) {
            stringBuffer.append("--").append(HTTPServer.BOUNDARY).append("\r\n").append("Content-Disposition").append(": ").append("form-data").append(";").append(" name").append("=").append("\"").append(entry.getKey()).append("\"").append("\r\n").append("Content-Type").append(": ").append("text/plain").append("; ").append("Charset").append("=").append("UTF-8").append("\r\n").append("Content-Transfer-Encoding").append(": 8bit").append("\r\n").append("\r\n").append(entry.getValue()).append("\r\n");
        }
        String result = stringBuffer.toString();
        ZLog.e((String)"bihe0832 REQUEST", (String)("getFormDataString = " + result));
        return stringBuffer.toString();
    }
}

