/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.lib.http.common.core;

import android.text.TextUtils;
import com.bihe0832.android.lib.http.common.core.HttpBasicRequest;
import com.bihe0832.android.lib.log.ZLog;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLHandshakeException;

public abstract class BaseConnection {
    private static final String LOG_TAG = "bihe0832 REQUEST";
    public static final String HTTP_REQ_PROPERTY_CHARSET = "Charset";
    public static final String HTTP_REQ_VALUE_CHARSET_UTF8 = "UTF-8";
    public static final String HTTP_REQ_VALUE_CHARSET_ISO_8599_1 = "ISO-8859-1";
    public static final String HTTP_REQ_PROPERTY_CONTENT_DISPOSITION = "Content-Disposition";
    public static final String HTTP_REQ_PROPERTY_CONTENT_TRANSFER_ENCODING = "Content-Transfer-Encoding";
    public static final String HTTP_REQ_PROPERTY_CONTENT_TYPE = "Content-Type";
    public static final String HTTP_REQ_VALUE_CONTENT_TYPE_URL_ENCODD = "application/x-www-form-urlencoded";
    public static final String HTTP_REQ_VALUE_CONTENT_TYPE_TEXT = "text/plain";
    public static final String HTTP_REQ_VALUE_CONTENT_TYPE_FORM = "multipart/form-data";
    public static final String HTTP_REQ_VALUE_CONTENT_TYPE_OCTET_STREAM = "application/octet-stream";
    public static final String HTTP_REQ_ENTITY_MERGE = "=";
    public static final String HTTP_REQ_ENTITY_JOIN = "&";
    public static final String HTTP_REQ_ENTITY_PREFIX = "--";
    public static final String HTTP_REQ_ENTITY_LINE_END = "\r\n";
    public static final String HTTP_REQ_PROPERTY_CONTENT_LENGTH = "Content-Length";
    public static final String HTTP_REQ_METHOD_GET = "GET";
    public static final String HTTP_REQ_METHOD_POST = "POST";
    public static final String HTTP_REQ_COOKIE = "Cookie";
    protected static final int CONNECT_TIMEOUT = 5000;
    protected static final int DEFAULT_READ_TIMEOUT = 10000;

    protected void setURLConnectionCommonPara() {
        HttpURLConnection connection = this.getURLConnection();
        if (null == connection) {
            return;
        }
        connection.setConnectTimeout(5000);
        connection.setReadTimeout(10000);
        connection.setUseCaches(false);
    }

    protected void setURLConnectionRequestProperty(HashMap<String, String> requestProperty) {
        HttpURLConnection connection = this.getURLConnection();
        for (Map.Entry<String, String> entry : requestProperty.entrySet()) {
            if (TextUtils.isEmpty((CharSequence)entry.getKey()) || TextUtils.isEmpty((CharSequence)entry.getValue())) {
                ZLog.d((String)LOG_TAG, (String)"requestProperty is bad");
                continue;
            }
            connection.setRequestProperty(entry.getKey(), entry.getValue());
        }
    }

    protected void setURLConnectionCookie(HashMap<String, String> cookieInfo) {
        HttpURLConnection connection = this.getURLConnection();
        if (null == connection) {
            return;
        }
        String cookieString = connection.getRequestProperty(HTTP_REQ_COOKIE);
        cookieString = !TextUtils.isEmpty((CharSequence)cookieString) ? cookieString + ";" : "";
        for (Map.Entry<String, String> entry : cookieInfo.entrySet()) {
            if (TextUtils.isEmpty((CharSequence)entry.getKey()) || TextUtils.isEmpty((CharSequence)entry.getValue())) {
                ZLog.d((String)LOG_TAG, (String)"cookie inf is bad");
                continue;
            }
            cookieString = cookieString + entry.getKey() + HTTP_REQ_ENTITY_MERGE + entry.getValue() + ";";
        }
        connection.setRequestProperty(HTTP_REQ_COOKIE, cookieString);
    }

    public String doRequest(HttpBasicRequest request) {
        if (null == this.getURLConnection()) {
            ZLog.e((String)LOG_TAG, (String)"URLConnection is null");
            return "";
        }
        this.setURLConnectionCommonPara();
        HashMap<String, String> requestProperty = new HashMap<String, String>();
        if (request.getRequestProperties() != null) {
            requestProperty.putAll(request.getRequestProperties());
        }
        requestProperty.put(HTTP_REQ_PROPERTY_CHARSET, HTTP_REQ_VALUE_CHARSET_UTF8);
        requestProperty.put(HTTP_REQ_PROPERTY_CONTENT_TYPE, request.getContentType());
        this.setURLConnectionRequestProperty(requestProperty);
        if (null != request.cookieInfo && request.cookieInfo.size() > 0) {
            this.setURLConnectionCookie(request.cookieInfo);
        }
        if (null == request.data) {
            return this.doGetRequest();
        }
        return this.doPostRequest(request.data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String doGetRequest() {
        String result = "";
        InputStream is = null;
        BufferedReader br = null;
        try {
            int len;
            HttpURLConnection connection = this.getURLConnection();
            if (null == connection) {
                String string = "";
                return string;
            }
            connection.setRequestMethod(HTTP_REQ_METHOD_GET);
            is = connection.getInputStream();
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            byte[] buffer = new byte[8192];
            while ((len = is.read(buffer)) != -1) {
                os.write(buffer, 0, len);
            }
            is.close();
            result = os.toString(HTTP_REQ_VALUE_CHARSET_ISO_8599_1);
            return result;
        }
        catch (SSLHandshakeException ee) {
            ZLog.e((String)LOG_TAG, (String)"javax.net.ssl.SSLPeerUnverifiedException");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException ee) {}
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException ee) {}
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String doPostRequest(byte[] data) {
        BufferedReader br = null;
        InputStream inptStream = null;
        OutputStream outputStream = null;
        HttpURLConnection connection = this.getURLConnection();
        try {
            if (null == connection) {
                String string = "";
                return string;
            }
            connection.setRequestMethod(HTTP_REQ_METHOD_POST);
            connection.setRequestProperty(HTTP_REQ_PROPERTY_CONTENT_LENGTH, String.valueOf(data.length));
            outputStream = connection.getOutputStream();
            outputStream.write(data);
            outputStream.flush();
            int response = connection.getResponseCode();
            if (response == 200) {
                int len;
                inptStream = connection.getInputStream();
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                byte[] buffer = new byte[8192];
                while ((len = inptStream.read(buffer)) != -1) {
                    os.write(buffer, 0, len);
                }
                inptStream.close();
                String string = os.toString(HTTP_REQ_VALUE_CHARSET_ISO_8599_1);
                return string;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (connection != null) {
                    connection.disconnect();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (inptStream != null) {
                    inptStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return "";
    }

    public String getResponseMessage() {
        HttpURLConnection connection = this.getURLConnection();
        if (null == connection) {
            return "";
        }
        try {
            return this.getURLConnection().getResponseMessage();
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    public int getResponseCode() {
        HttpURLConnection connection = this.getURLConnection();
        if (null == connection) {
            return -1;
        }
        try {
            return this.getURLConnection().getResponseCode();
        }
        catch (IOException e) {
            e.printStackTrace();
            return -1;
        }
    }

    protected abstract HttpURLConnection getURLConnection();
}

