/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.lib.floatview;

import android.content.Context;
import android.os.Handler;
import android.os.Message;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.view.animation.RotateAnimation;
import android.view.animation.TranslateAnimation;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.bihe0832.android.lib.aaf.tools.AAFException;
import com.bihe0832.android.lib.config.Config;
import com.bihe0832.android.lib.log.ZLog;
import com.bihe0832.android.lib.thread.ThreadManager;
import com.bihe0832.android.lib.utils.os.BuildUtils;
import com.bihe0832.android.lib.utils.os.DisplayUtil;

public abstract class IconView
extends LinearLayout
implements View.OnClickListener {
    public static final String TAG = "ICON_VIEW";
    public static final int TIME_DELAY_SHADOW_ICON = 3000;
    public static final int TIME_DELAY_HIDE_ICON = 2000;
    private static final int MSG_ICON_CHANGE_ICON_WINDOW_SHADOW = 1;
    private static final int MSG_ICON_CHANGE_ICON_WINDOW_HIDE = -1;
    public static int sViewWidth;
    public static int sViewHeight;
    private static int sStatusBarHeight;
    private WindowManager mWindowManager;
    private WindowManager.LayoutParams mParams;
    private float xInScreen;
    private float yInScreen;
    private float xDownInScreen;
    private float yDownInScreen;
    private float xInView;
    private float yInView;
    private float mSlidePercent = 0.3f;
    private Animation mIconMovingAnim;
    private boolean isLogoAnimRunning;
    public volatile boolean hasBeenAdded = false;
    private View.OnClickListener mOnClickListener = null;
    Handler mUiHandler = new Handler(ThreadManager.getInstance().getLooper(0)){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    IconView.this.shadowIcon();
                    break;
                }
                case -1: {
                    IconView.this.hideIcon();
                }
            }
        }
    };

    public abstract ImageView getIconView();

    public abstract View getIconLayout();

    public abstract int getLayoutId();

    public abstract void initView();

    public IconView(Context context) throws AAFException {
        super(context);
        this.mWindowManager = (WindowManager)context.getSystemService("window");
        LayoutInflater.from((Context)context).inflate(this.getLayoutId(), (ViewGroup)this);
        this.initView();
        if (null == this.getIconView()) {
            throw new AAFException("IconView must have IconView");
        }
        if (null == this.getIconLayout()) {
            throw new AAFException("IconView must have IconLayout");
        }
        this.getIconView().setOnClickListener((View.OnClickListener)this);
        sViewWidth = this.getIconLayout().getLayoutParams().width;
        sViewHeight = this.getIconLayout().getLayoutParams().height;
        this.initIconMovingAnim();
    }

    public void setSlidePercent(float percent) {
        if (percent < 0.8f) {
            this.mSlidePercent = percent;
        }
    }

    public void setClickListener(View.OnClickListener listener) {
        this.mOnClickListener = listener;
    }

    private void initIconMovingAnim() {
        if (this.mIconMovingAnim == null) {
            this.mIconMovingAnim = new RotateAnimation(359.0f, 0.0f, 1, 0.5f, 1, 0.5f);
            this.mIconMovingAnim.setInterpolator((Interpolator)new LinearInterpolator());
            this.mIconMovingAnim.setDuration(800L);
            this.mIconMovingAnim.setRepeatCount(-1);
        }
    }

    public boolean onInterceptTouchEvent(MotionEvent event) {
        this.clearIconLayoutAnimation();
        this.xInScreen = event.getRawX();
        this.yInScreen = this.ignoreStatusBar() ? event.getRawY() : event.getRawY() - (float)this.getStatusBarHeight();
        switch (event.getAction()) {
            case 0: {
                this.getIconView().startAnimation(this.mIconMovingAnim);
                this.xInView = event.getX();
                this.yInView = event.getY();
                this.xDownInScreen = event.getRawX();
                this.yDownInScreen = this.ignoreStatusBar() ? event.getRawY() : event.getRawY() - (float)this.getStatusBarHeight();
                this.mUiHandler.removeMessages(1);
                this.mUiHandler.removeMessages(-1);
                if (BuildUtils.INSTANCE.getSDK_INT() <= 10) break;
                this.getIconView().setAlpha(1.0f);
                break;
            }
            case 2: {
                if (!this.needUpdateViewPosition()) break;
                this.updateViewPosition();
                break;
            }
            case 1: {
                this.clearViewAnimation();
                this.startShadowIcon();
                Config.writeConfig((String)TAG, (int)new Integer(this.mParams.y));
                int screenWidth = DisplayUtil.getRealScreenSizeX((Context)this.getContext());
                if (this.xInScreen - this.xInView > (float)(screenWidth / 2)) {
                    this.moveToEdge(false);
                } else {
                    this.moveToEdge(true);
                }
                if (this.xInScreen - this.xInView < 0.0f) {
                    this.startHideIcon(0);
                    return true;
                }
                this.startHideIcon(2000);
                break;
            }
        }
        return super.onInterceptTouchEvent(event);
    }

    protected boolean needUpdateViewPosition() {
        return Math.abs(this.xInScreen - this.xDownInScreen) > 12.0f || Math.abs(this.yInScreen - this.yDownInScreen) > 12.0f;
    }

    public void onClick(final View v) {
        this.doIconClickAnimation(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationEnd(Animation animation) {
                if (IconView.this.mOnClickListener != null) {
                    IconView.this.mOnClickListener.onClick(v);
                }
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
    }

    public void setParams(WindowManager.LayoutParams params) {
        this.mParams = params;
        this.resetParams(this.mParams);
    }

    public int getIconLocationX() {
        if (null != this.mParams) {
            return this.mParams.x;
        }
        return this.getConfigLocationX();
    }

    public int getIconLocationY() {
        if (null != this.mParams) {
            ZLog.d((String)("y:" + this.mParams.y));
            return this.mParams.y;
        }
        return this.getConfigLocationY();
    }

    protected int getConfigLocationX() {
        return 0;
    }

    protected int getConfigLocationY() {
        int height = DisplayUtil.dip2px((Context)this.getContext(), (float)92.0f);
        ZLog.d((String)("height:" + height));
        return height;
    }

    protected void updateViewPosition() {
        this.mParams.x = (int)(this.xInScreen - this.xInView);
        this.mParams.y = (int)(this.yInScreen - this.yInView) - 60;
        int minUnit = 0;
        minUnit = this.ignoreStatusBar() ? 0 : this.getStatusBarHeight();
        if (this.mParams.y < minUnit) {
            this.mParams.y = minUnit;
        } else if (this.mParams.y > DisplayUtil.getScreenHeight((Context)this.getContext()) - minUnit) {
            this.mParams.y = DisplayUtil.getScreenHeight((Context)this.getContext()) - minUnit;
        }
        int screenWidth = DisplayUtil.getRealScreenSizeX((Context)this.getContext());
        if ((this.mParams.x <= 0 || this.mParams.x >= screenWidth - 90) && this.isLogoAnimRunning) {
            this.clearViewAnimation();
        }
        this.updateViewLayout();
    }

    public void clearViewAnimation() {
        this.getIconView().clearAnimation();
        this.isLogoAnimRunning = false;
    }

    public void clearIconLayoutAnimation() {
        if (this.getIconLayout().getAnimation() != null) {
            this.getIconLayout().clearAnimation();
        }
    }

    public void moveToEdge(boolean isLeft) {
        int screenWidth = DisplayUtil.getRealScreenSizeX((Context)this.getContext());
        this.mParams.x = isLeft ? 0 : screenWidth;
        ZLog.d((String)("ICON_VIEW screenWidth:" + screenWidth));
        this.updateViewLayout();
        if (BuildUtils.INSTANCE.getSDK_INT() > 10) {
            this.getIconView().setAlpha(1.0f);
        }
    }

    protected void updateViewLayout() {
        this.resetParams(this.mParams);
        this.mWindowManager.updateViewLayout((View)this, (ViewGroup.LayoutParams)this.mParams);
    }

    public void doIconClickAnimation(Animation.AnimationListener listener) {
        RotateAnimation rotateAnimation = new RotateAnimation(359.0f, 0.0f, 1, 0.5f, 1, 0.5f);
        rotateAnimation.setRepeatCount(0);
        rotateAnimation.setDuration(300L);
        rotateAnimation.setFillAfter(true);
        rotateAnimation.setAnimationListener(listener);
        this.getIconView().setAnimation((Animation)rotateAnimation);
        this.getIconView().startAnimation((Animation)rotateAnimation);
    }

    protected boolean ignoreStatusBar() {
        return false;
    }

    protected int getStatusBarHeight() {
        if (sStatusBarHeight == 0) {
            sStatusBarHeight = DisplayUtil.getStatusBarHeight((Context)this.getContext());
        }
        return sStatusBarHeight;
    }

    public void onDestroy() {
        this.mUiHandler.removeMessages(1);
        this.mUiHandler.removeMessages(-1);
    }

    public void showIcon() {
        this.startShadowIcon();
        this.startHideIcon(2000);
        this.setVisibility(0);
    }

    protected void startShadowIcon() {
        this.mUiHandler.sendEmptyMessageDelayed(1, 3000L);
    }

    protected void shadowIcon() {
        AlphaAnimation alphaAnimation = new AlphaAnimation(1.0f, 0.5f);
        alphaAnimation.setDuration(300L);
        alphaAnimation.setFillAfter(true);
        this.getIconView().startAnimation((Animation)alphaAnimation);
    }

    protected void startHideIcon(int time) {
        if (time > 0) {
            this.mUiHandler.sendEmptyMessageDelayed(-1, (long)time);
        } else {
            this.mUiHandler.sendEmptyMessage(-1);
        }
    }

    protected void hideIcon() {
        int screenWidth;
        int le;
        if (BuildUtils.INSTANCE.getSDK_INT() > 10) {
            this.getIconView().setAlpha(0.5f);
        }
        boolean isLeft = (le = this.getIconLocationX()) < (screenWidth = DisplayUtil.getRealScreenSizeX((Context)this.getContext())) / 2;
        TranslateAnimation animation = new TranslateAnimation(1, 0.0f, 1, isLeft ? 0.0f - this.mSlidePercent : this.mSlidePercent, 1, 0.0f, 1, 0.0f);
        animation.setDuration(300L);
        animation.setFillAfter(true);
        animation.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationEnd(Animation animation) {
                if (BuildUtils.INSTANCE.getSDK_INT() > 10) {
                    IconView.this.getIconView().setAlpha(1.0f);
                }
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
        this.getIconLayout().startAnimation((Animation)animation);
    }

    protected void resetParams(WindowManager.LayoutParams mParams) {
    }

    protected boolean iconLocationIsLeft() {
        int screenWidth = DisplayUtil.getRealScreenSizeX((Context)this.getContext());
        boolean iconLocationIsLeft = this.mParams.x < screenWidth / 2;
        return iconLocationIsLeft;
    }
}

